/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.utils.AggregateUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AggregationExecutor.class);
    private List<PartialPath> selectedSeries;
    protected List<TSDataType> dataTypes;
    protected List<String> aggregations;
    protected IExpression expression;
    protected boolean ascending;
    private int aggregateFetchSize;

    protected AggregationExecutor(AggregationPlan aggregationPlan) {
        this.selectedSeries = aggregationPlan.getDeduplicatedPaths();
        this.dataTypes = aggregationPlan.getDeduplicatedDataTypes();
        this.aggregations = aggregationPlan.getDeduplicatedAggregations();
        this.expression = aggregationPlan.getExpression();
        this.aggregateFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
        this.ascending = aggregationPlan.isAscending();
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context, AggregationPlan aggregationPlan) throws StorageEngineException, IOException, QueryProcessException {
        Filter timeFilter = null;
        if (this.expression != null) {
            timeFilter = ((GlobalTimeExpression)this.expression).getFilter();
        }
        Map<PartialPath, List<Integer>> pathToAggrIndexesMap = this.groupAggregationsBySeries(this.selectedSeries);
        AggregateResult[] aggregateResultList = new AggregateResult[this.selectedSeries.size()];
        Pair<List<StorageGroupProcessor>, Map<StorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(new ArrayList<PartialPath>(pathToAggrIndexesMap.keySet()));
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (Map.Entry<PartialPath, List<Integer>> entry : pathToAggrIndexesMap.entrySet()) {
            this.aggregateOneSeries(entry, aggregateResultList, aggregationPlan.getAllMeasurementsInDevice(entry.getKey().getDevice()), timeFilter, context);
        }
        return this.constructDataSet(Arrays.asList(aggregateResultList), aggregationPlan);
    }

    protected void aggregateOneSeries(Map.Entry<PartialPath, List<Integer>> pathToAggrIndexes, AggregateResult[] aggregateResultList, Set<String> measurements, Filter timeFilter, QueryContext context) throws IOException, QueryProcessException, StorageEngineException {
        ArrayList<AggregateResult> ascAggregateResultList = new ArrayList<AggregateResult>();
        ArrayList<AggregateResult> descAggregateResultList = new ArrayList<AggregateResult>();
        boolean[] isAsc = new boolean[aggregateResultList.length];
        PartialPath seriesPath = pathToAggrIndexes.getKey();
        TSDataType tsDataType = this.dataTypes.get(pathToAggrIndexes.getValue().get(0));
        for (int i : pathToAggrIndexes.getValue()) {
            AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), tsDataType);
            if (aggregateResult.isAscending()) {
                ascAggregateResultList.add(aggregateResult);
                isAsc[i] = true;
                continue;
            }
            descAggregateResultList.add(aggregateResult);
        }
        AggregationExecutor.aggregateOneSeries(seriesPath, measurements, context, timeFilter, tsDataType, ascAggregateResultList, descAggregateResultList, null);
        int ascIndex = 0;
        int descIndex = 0;
        for (int i : pathToAggrIndexes.getValue()) {
            aggregateResultList[i] = isAsc[i] ? (AggregateResult)ascAggregateResultList.get(ascIndex++) : (AggregateResult)descAggregateResultList.get(descIndex++);
        }
    }

    public static void aggregateOneSeries(PartialPath seriesPath, Set<String> measurements, QueryContext context, Filter timeFilter, TSDataType tsDataType, List<AggregateResult> ascAggregateResultList, List<AggregateResult> descAggregateResultList, TsFileFilter fileFilter) throws StorageEngineException, IOException, QueryProcessException {
        SeriesAggregateReader seriesReader;
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context, timeFilter);
        timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
        if (ascAggregateResultList != null && !ascAggregateResultList.isEmpty()) {
            seriesReader = new SeriesAggregateReader(seriesPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, true);
            AggregationExecutor.aggregateFromReader(seriesReader, ascAggregateResultList);
        }
        if (descAggregateResultList != null && !descAggregateResultList.isEmpty()) {
            seriesReader = new SeriesAggregateReader(seriesPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, false);
            AggregationExecutor.aggregateFromReader(seriesReader, descAggregateResultList);
        }
    }

    private static void aggregateFromReader(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList) throws QueryProcessException, IOException {
        int remainingToCalculate = aggregateResultList.size();
        boolean[] isCalculatedArray = new boolean[aggregateResultList.size()];
        while (seriesReader.hasNextFile()) {
            if (seriesReader.canUseCurrentFileStatistics()) {
                Statistics fileStatistics = seriesReader.currentFileStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, fileStatistics)) == 0) {
                    return;
                }
                seriesReader.skipCurrentFile();
                continue;
            }
            while (seriesReader.hasNextChunk()) {
                if (seriesReader.canUseCurrentChunkStatistics()) {
                    Statistics chunkStatistics = seriesReader.currentChunkStatistics();
                    if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, chunkStatistics)) == 0) {
                        return;
                    }
                    seriesReader.skipCurrentChunk();
                    continue;
                }
                if ((remainingToCalculate = AggregationExecutor.aggregatePages(seriesReader, aggregateResultList, isCalculatedArray, remainingToCalculate)) != 0) continue;
                return;
            }
        }
    }

    private static int aggregateStatistics(List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate, Statistics statistics) throws QueryProcessException {
        int newRemainingToCalculate = remainingToCalculate;
        for (int i = 0; i < aggregateResultList.size(); ++i) {
            if (isCalculatedArray[i]) continue;
            AggregateResult aggregateResult = aggregateResultList.get(i);
            aggregateResult.updateResultFromStatistics(statistics);
            if (!aggregateResult.hasFinalResult()) continue;
            isCalculatedArray[i] = true;
            if (--newRemainingToCalculate != 0) continue;
            return newRemainingToCalculate;
        }
        return newRemainingToCalculate;
    }

    private static int aggregatePages(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate) throws IOException, QueryProcessException {
        while (seriesReader.hasNextPage()) {
            if (seriesReader.canUseCurrentPageStatistics()) {
                Statistics pageStatistic = seriesReader.currentPageStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, pageStatistic)) == 0) {
                    return 0;
                }
                seriesReader.skipCurrentPage();
                continue;
            }
            BatchData nextOverlappedPageData = seriesReader.nextPage();
            for (int i = 0; i < aggregateResultList.size(); ++i) {
                if (isCalculatedArray[i]) continue;
                AggregateResult aggregateResult = aggregateResultList.get(i);
                aggregateResult.updateResultFromPageData(nextOverlappedPageData);
                nextOverlappedPageData.resetBatchData();
                if (!aggregateResult.hasFinalResult()) continue;
                isCalculatedArray[i] = true;
                if (--remainingToCalculate != 0) continue;
                return 0;
            }
        }
        return remainingToCalculate;
    }

    public QueryDataSet executeWithValueFilter(QueryContext context, AggregationPlan queryPlan) throws StorageEngineException, IOException, QueryProcessException {
        this.optimizeLastElementFunc(queryPlan);
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, queryPlan);
        Map<PartialPath, List<Integer>> pathToAggrIndexesMap = this.groupAggregationsBySeries(this.selectedSeries);
        HashMap<IReaderByTimestamp, List<Integer>> readerToAggrIndexesMap = new HashMap<IReaderByTimestamp, List<Integer>>();
        Pair<List<StorageGroupProcessor>, Map<StorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(new ArrayList<PartialPath>(pathToAggrIndexesMap.keySet()));
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timestampGenerator.getTimeFilter());
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            PartialPath path = this.selectedSeries.get(i);
            List<Integer> indexes = pathToAggrIndexesMap.remove(path);
            if (indexes == null) continue;
            IReaderByTimestamp seriesReaderByTimestamp = this.getReaderByTime(path, queryPlan, this.dataTypes.get(i), context);
            readerToAggrIndexesMap.put(seriesReaderByTimestamp, indexes);
        }
        ArrayList<AggregateResult> aggregateResults = new ArrayList<AggregateResult>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            AggregateResult result = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), this.dataTypes.get(i), this.ascending);
            aggregateResults.add(result);
        }
        this.aggregateWithValueFilter(aggregateResults, timestampGenerator, readerToAggrIndexesMap);
        return this.constructDataSet(aggregateResults, queryPlan);
    }

    private void optimizeLastElementFunc(QueryPlan queryPlan) {
        String aggregationFunc;
        int index;
        for (index = 0; index < this.aggregations.size() && ((aggregationFunc = this.aggregations.get(index)).equals("max_time") || aggregationFunc.equals("last_value")); ++index) {
        }
        if (index >= this.aggregations.size()) {
            queryPlan.setAscending(false);
            this.ascending = false;
        }
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan queryPlan, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), null, this.ascending);
    }

    private void aggregateWithValueFilter(List<AggregateResult> aggregateResults, TimeGenerator timestampGenerator, Map<IReaderByTimestamp, List<Integer>> readerToAggrIndexesMap) throws IOException {
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.expression, new ArrayList<PartialPath>(this.selectedSeries), (boolean)timestampGenerator.hasOrNode());
        while (timestampGenerator.hasNext()) {
            long[] timeArray = new long[this.aggregateFetchSize];
            int timeArrayLength = 0;
            for (int cnt = 0; cnt < this.aggregateFetchSize && timestampGenerator.hasNext(); ++cnt) {
                timeArray[timeArrayLength++] = timestampGenerator.next();
            }
            for (Map.Entry<IReaderByTimestamp, List<Integer>> entry : readerToAggrIndexesMap.entrySet()) {
                Object[] values;
                int pathId = entry.getValue().get(0);
                if (((Boolean)cached.get(pathId)).booleanValue()) {
                    values = timestampGenerator.getValues((Path)this.selectedSeries.get(pathId));
                    for (Integer i : entry.getValue()) {
                        aggregateResults.get(i).updateResultUsingValues(timeArray, timeArrayLength, values);
                    }
                    continue;
                }
                if (entry.getValue().size() == 1) {
                    aggregateResults.get(entry.getValue().get(0)).updateResultUsingTimestamps(timeArray, timeArrayLength, entry.getKey());
                    continue;
                }
                values = entry.getKey().getValuesInTimestamps(timeArray, timeArrayLength);
                if (values == null) continue;
                for (Integer i : entry.getValue()) {
                    aggregateResults.get(i).updateResultUsingValues(timeArray, timeArrayLength, values);
                }
            }
        }
    }

    private QueryDataSet constructDataSet(List<AggregateResult> aggregateResultList, AggregationPlan plan) throws QueryProcessException {
        SingleDataSet dataSet;
        RowRecord record = new RowRecord(0L);
        for (AggregateResult resultData : aggregateResultList) {
            TSDataType dataType = resultData.getResultDataType();
            record.addField(resultData.getResult(), dataType);
        }
        if (plan.isGroupByLevel()) {
            Map<String, AggregateResult> finalPaths = plan.getAggPathByLevel();
            List<AggregateResult> mergedAggResults = AggregateUtils.mergeRecordByPath(plan, aggregateResultList, finalPaths);
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            for (int i = 0; i < mergedAggResults.size(); ++i) {
                dataTypes.add(mergedAggResults.get(i).getResultDataType());
            }
            RowRecord curRecord = new RowRecord(0L);
            for (AggregateResult resultData : mergedAggResults) {
                TSDataType dataType = resultData.getResultDataType();
                curRecord.addField(resultData.getResult(), dataType);
            }
            dataSet = new SingleDataSet(paths, dataTypes);
            dataSet.setRecord(curRecord);
        } else {
            dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
            dataSet.setRecord(record);
        }
        return dataSet;
    }

    private Map<PartialPath, List<Integer>> groupAggregationsBySeries(List<PartialPath> selectedSeries) {
        HashMap<PartialPath, List<Integer>> pathToAggrIndexesMap = new HashMap<PartialPath, List<Integer>>();
        for (int i = 0; i < selectedSeries.size(); ++i) {
            PartialPath series = selectedSeries.get(i);
            pathToAggrIndexesMap.computeIfAbsent(series, key -> new ArrayList()).add(i);
        }
        return pathToAggrIndexesMap;
    }
}

