/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.GroupByLevelController;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AggregationPlan
extends RawDataQueryPlan {
    private List<String> aggregations = new ArrayList<String>();
    private List<String> deduplicatedAggregations = new ArrayList<String>();
    private GroupByLevelController groupByLevelController;
    private boolean isCountStar;
    private int[] levels;
    private final Map<String, AggregateResult> levelAggPaths = new LinkedHashMap<String, AggregateResult>();

    public AggregationPlan() {
        this.setOperatorType(Operator.OperatorType.AGGREGATION);
    }

    @Override
    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations;
    }

    public List<String> getDeduplicatedAggregations() {
        return this.deduplicatedAggregations;
    }

    public void addDeduplicatedAggregations(String aggregations) {
        this.deduplicatedAggregations.add(aggregations);
    }

    public void setDeduplicatedAggregations(List<String> deduplicatedAggregations) {
        this.deduplicatedAggregations = deduplicatedAggregations;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public void setLevels(int[] levels) {
        this.levels = levels;
    }

    public boolean isGroupByLevel() {
        return this.levels != null && this.levels.length != 0;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    public void setCountStar(boolean countStar) {
        this.isCountStar = countStar;
    }

    public Map<String, AggregateResult> getAggPathByLevel() {
        if (!this.levelAggPaths.isEmpty()) {
            return this.levelAggPaths;
        }
        List<PartialPath> seriesPaths = this.getPaths();
        List<TSDataType> dataTypes = this.getDataTypes();
        int i = 0;
        while (i < seriesPaths.size()) {
            String rawPath = this.getAggregations().get(i) + "(" + seriesPaths.get(i).getFullPath() + ")";
            String key = this.groupByLevelController.getGroupedPath(rawPath);
            int finalI = i++;
            this.levelAggPaths.computeIfAbsent(key, k -> AggregateResultFactory.getAggrResultByName(this.getAggregations().get(finalI), (TSDataType)dataTypes.get(finalI)));
        }
        return this.levelAggPaths;
    }

    @Override
    public void setAlignByTime(boolean align) throws QueryProcessException {
        if (!align) {
            throw new QueryProcessException(this.getOperatorType().name() + " doesn't support disable align clause.");
        }
    }

    @Override
    public String getColumnForReaderFromPath(PartialPath path, int pathIndex) {
        String columnForReader = super.getColumnForReaderFromPath(path, pathIndex);
        if (!path.isTsAliasExists()) {
            columnForReader = this.getAggregations().get(pathIndex) + "(" + columnForReader + ")";
        }
        return columnForReader;
    }

    @Override
    public String getColumnForDisplay(String columnForReader, int pathIndex) {
        String columnForDisplay = columnForReader;
        if (this.isGroupByLevel()) {
            columnForDisplay = this.groupByLevelController.getGroupedPath(columnForDisplay);
        }
        return columnForDisplay;
    }

    public GroupByLevelController getGroupByLevelController() {
        return this.groupByLevelController;
    }

    public void setGroupByLevelController(GroupByLevelController groupByLevelController) {
        this.groupByLevelController = groupByLevelController;
    }
}

