/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.recover;

import java.io.File;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.compaction.InvalidCompactionLogException;

public class MergeFileInfo {
    String logicalStorageGroup;
    String virtualStorageGroup;
    long timePartition;
    String filename;
    boolean sequence;

    private MergeFileInfo(String logicalStorageGroup, String virtualStorageGroup, long timePartition, String filename, boolean sequence) {
        this.logicalStorageGroup = logicalStorageGroup;
        this.virtualStorageGroup = virtualStorageGroup;
        this.timePartition = timePartition;
        this.filename = filename;
        this.sequence = sequence;
    }

    public static MergeFileInfo getFileInfoFromFile(File file) {
        String filePath = file.getAbsolutePath();
        String splitSeparator = File.separator;
        if (splitSeparator.equals("\\")) {
            splitSeparator = "\\\\";
        }
        String[] paths = filePath.split(splitSeparator);
        int pathLength = paths.length;
        return new MergeFileInfo(paths[pathLength - 4], paths[pathLength - 3], Long.parseLong(paths[pathLength - 2]), paths[pathLength - 1], paths[pathLength - 5].equals("sequence"));
    }

    public static MergeFileInfo getFileInfoFromString(String infoString) throws InvalidCompactionLogException {
        if (!infoString.contains(File.separator)) {
            String[] splits = infoString.split(" ");
            if (splits.length != 5) {
                throw new InvalidCompactionLogException("Invalid file info string " + infoString);
            }
            return new MergeFileInfo(splits[0], splits[1], Long.parseLong(splits[2]), splits[3], Boolean.parseBoolean(splits[4]));
        }
        return MergeFileInfo.getFileInfoFromFile(new File(infoString));
    }

    public File getFileFromDataDirs() {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            File file = new File(dataDir.concat(File.separator) + (this.sequence ? "sequence" : "unsequence").concat(File.separator) + this.logicalStorageGroup.concat(File.separator) + this.virtualStorageGroup.concat(File.separator) + String.valueOf(this.timePartition).concat(File.separator) + this.filename);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public String toString() {
        return String.format("%s %s %d %s %s", this.logicalStorageGroup, this.virtualStorageGroup, this.timePartition, this.filename, this.sequence);
    }

    public boolean equals(Object other) {
        if (other instanceof MergeFileInfo) {
            MergeFileInfo otherInfo = (MergeFileInfo)other;
            return this.logicalStorageGroup.equals(otherInfo.logicalStorageGroup) && this.virtualStorageGroup.equals(otherInfo.virtualStorageGroup) && this.timePartition == otherInfo.timePartition && this.sequence == otherInfo.sequence && this.filename.equals(otherInfo.filename);
        }
        return false;
    }
}

