/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileInfo;

public class CompactionLogAnalyzer {
    public static final String STR_DEVICE_OFFSET_SEPARATOR = " ";
    private File logFile;
    private List<String> deviceList = new ArrayList<String>();
    private List<Long> offsets = new ArrayList<Long>();
    private List<String> sourceFiles = new ArrayList<String>();
    private List<CompactionFileInfo> sourceFileInfo = new ArrayList<CompactionFileInfo>();
    private CompactionFileInfo targetFileInfo = null;
    private String targetFile = null;
    private boolean isSeq = false;
    private boolean fullMerge = false;

    public CompactionLogAnalyzer(File logFile) {
        this.logFile = logFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyze() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            block23: while ((currLine = bufferedReader.readLine()) != null) {
                switch (currLine) {
                    case "source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFileInfo.add(CompactionFileInfo.parseCompactionFileInfoFromPath(currLine));
                        continue block23;
                    }
                    case "info-source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFileInfo.add(CompactionFileInfo.parseCompactionFileInfo(currLine));
                        continue block23;
                    }
                    case "target": {
                        currLine = bufferedReader.readLine();
                        this.targetFileInfo = CompactionFileInfo.parseCompactionFileInfoFromPath(currLine);
                        continue block23;
                    }
                    case "info-target": {
                        currLine = bufferedReader.readLine();
                        this.targetFileInfo = CompactionFileInfo.parseCompactionFileInfo(currLine);
                        continue block23;
                    }
                    case "full merge": {
                        this.fullMerge = true;
                        continue block23;
                    }
                    case "sequence": {
                        this.isSeq = true;
                        continue block23;
                    }
                    case "unsequence": {
                        this.isSeq = false;
                        continue block23;
                    }
                }
                int separatorIndex = currLine.lastIndexOf(STR_DEVICE_OFFSET_SEPARATOR);
                this.deviceList.add(currLine.substring(0, separatorIndex));
                this.offsets.add(Long.parseLong(currLine.substring(separatorIndex + 1)));
            }
            return;
        }
    }

    public Set<String> getDeviceSet() {
        if (this.offsets.size() < 2) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this.deviceList.subList(0, this.deviceList.size() - 1));
    }

    public long getOffset() {
        if (this.offsets.size() > 2) {
            return this.offsets.get(this.offsets.size() - 2);
        }
        return 0L;
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isFullMerge() {
        return this.fullMerge;
    }

    public List<CompactionFileInfo> getSourceFileInfo() {
        return this.sourceFileInfo;
    }

    public CompactionFileInfo getTargetFileInfo() {
        return this.targetFileInfo;
    }
}

