/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.StatusUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;

public class InsertRowsPlan
extends InsertPlan
implements BatchPlan {
    private List<Integer> insertRowPlanIndexList;
    private List<InsertRowPlan> insertRowPlanList;
    boolean[] isExecuted;
    private Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();
    private List<PartialPath> paths;
    private List<PartialPath> prefixPaths;

    public InsertRowsPlan() {
        super(Operator.OperatorType.BATCH_INSERT_ROWS);
        this.insertRowPlanList = new ArrayList<InsertRowPlan>();
        this.insertRowPlanIndexList = new ArrayList<Integer>();
    }

    @Override
    public long getMinTime() {
        long minTime = Long.MAX_VALUE;
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            if (insertRowPlan.getMinTime() >= minTime) continue;
            minTime = insertRowPlan.getMinTime();
        }
        return minTime;
    }

    @Override
    public List<PartialPath> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        for (InsertRowPlan plan : this.insertRowPlanList) {
            pathSet.addAll(plan.getPaths());
        }
        this.paths = new ArrayList<PartialPath>(pathSet);
        return this.paths;
    }

    @Override
    public List<PartialPath> getPrefixPaths() {
        if (this.prefixPaths != null) {
            return this.prefixPaths;
        }
        this.prefixPaths = new ArrayList<PartialPath>(this.insertRowPlanList.size());
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            this.prefixPaths.add(insertRowPlan.getDeviceId());
        }
        return this.prefixPaths;
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        if (this.insertRowPlanList.isEmpty()) {
            throw new QueryProcessException("sub plan are empty.");
        }
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            insertRowPlan.checkIntegrity();
        }
    }

    @Override
    public void recoverFromFailure() {
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            insertRowPlan.recoverFromFailure();
        }
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        ArrayList<InsertRowPlan> plans = new ArrayList<InsertRowPlan>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.insertRowPlanList.size(); ++i) {
            if (!this.insertRowPlanList.get(i).hasFailedValues()) continue;
            plans.add((InsertRowPlan)this.insertRowPlanList.get(i).getPlanFromFailed());
            indexes.add(i);
        }
        this.insertRowPlanList = plans;
        this.insertRowPlanIndexList = indexes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertRowsPlan that = (InsertRowsPlan)o;
        if (!Objects.equals(this.insertRowPlanIndexList, that.insertRowPlanIndexList)) {
            return false;
        }
        if (!Objects.equals(this.insertRowPlanList, that.insertRowPlanList)) {
            return false;
        }
        return Objects.equals(this.results, that.results);
    }

    public int hashCode() {
        int result = this.insertRowPlanIndexList != null ? this.insertRowPlanIndexList.hashCode() : 0;
        result = 31 * result + (this.insertRowPlanList != null ? this.insertRowPlanList.hashCode() : 0);
        result = 31 * result + (this.results != null ? this.results.hashCode() : 0);
        return result;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCH_INSERT_ROWS.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.insertRowPlanList.size());
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            insertRowPlan.subSerialize(buffer);
        }
        for (Integer index : this.insertRowPlanIndexList) {
            buffer.putInt(index);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCH_INSERT_ROWS.ordinal();
        stream.writeByte((byte)type);
        stream.writeInt(this.insertRowPlanList.size());
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            insertRowPlan.subSerialize(stream);
        }
        for (Integer index : this.insertRowPlanIndexList) {
            stream.writeInt(index);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        int size = buffer.getInt();
        this.insertRowPlanList = new ArrayList<InsertRowPlan>(size);
        this.insertRowPlanIndexList = new ArrayList<Integer>(size);
        for (i = 0; i < size; ++i) {
            InsertRowPlan insertRowPlan = new InsertRowPlan();
            insertRowPlan.deserialize(buffer);
            this.insertRowPlanList.add(insertRowPlan);
        }
        for (i = 0; i < size; ++i) {
            this.insertRowPlanIndexList.add(buffer.getInt());
        }
    }

    @Override
    public void setIndex(long index) {
        super.setIndex(index);
        for (InsertRowPlan insertRowPlan : this.insertRowPlanList) {
            insertRowPlan.setIndex(index);
        }
    }

    @Override
    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public void addOneInsertRowPlan(InsertRowPlan plan, int index) {
        this.insertRowPlanList.add(plan);
        this.insertRowPlanIndexList.add(index);
    }

    public List<Integer> getInsertRowPlanIndexList() {
        return this.insertRowPlanIndexList;
    }

    public List<InsertRowPlan> getInsertRowPlanList() {
        return this.insertRowPlanList;
    }

    public int getRowCount() {
        return this.insertRowPlanList.size();
    }

    public PartialPath getFirstDeviceId() {
        return this.insertRowPlanList.get(0).getDeviceId();
    }

    public String toString() {
        return "InsertRowsPlan{ insertRowPlanIndexList's size=" + this.insertRowPlanIndexList.size() + ", insertRowPlanList's size=" + this.insertRowPlanList.size() + ", results=" + this.results + "}";
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, this.insertRowPlanList.size());
    }

    @Override
    public void setIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = true;
    }

    @Override
    public boolean isExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        return this.isExecuted[i];
    }

    @Override
    public int getBatchSize() {
        return this.insertRowPlanList.size();
    }

    @Override
    public void unsetIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = false;
        if (this.insertRowPlanIndexList != null && !this.insertRowPlanIndexList.isEmpty()) {
            this.results.remove(this.insertRowPlanIndexList.get(i));
        } else {
            this.results.remove(i);
        }
    }
}

