/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.virtualSg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.HashVirtualPartitioner;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.VirtualPartitioner;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualStorageGroupManager {
    private static final Logger logger = LoggerFactory.getLogger(VirtualStorageGroupManager.class);
    VirtualPartitioner partitioner = HashVirtualPartitioner.getInstance();
    StorageGroupProcessor[] virtualStorageGroupProcessor = new StorageGroupProcessor[this.partitioner.getPartitionCount()];
    private long monitorSeriesValue;

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void syncCloseAllWorkingTsFileProcessors() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void checkTTL() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.checkFilesTTL();
        }
    }

    public void timedFlushSeqMemTable() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.timedFlushSeqMemTable();
        }
    }

    public void timedFlushUnseqMemTable() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.timedFlushUnseqMemTable();
        }
    }

    public void timedCloseTsFileProcessor() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.timedCloseTsFileProcessor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageGroupProcessor getProcessor(PartialPath partialPath, StorageGroupMNode storageGroupMNode) throws StorageGroupProcessorException, StorageEngineException {
        int loc = this.partitioner.deviceToVirtualStorageGroupId(partialPath);
        StorageGroupProcessor processor = this.virtualStorageGroupProcessor[loc];
        if (processor == null) {
            if (StorageEngine.getInstance().isAllSgReady()) {
                StorageGroupMNode storageGroupMNode2 = storageGroupMNode;
                synchronized (storageGroupMNode2) {
                    processor = this.virtualStorageGroupProcessor[loc];
                    if (processor == null) {
                        this.virtualStorageGroupProcessor[loc] = processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(loc));
                    }
                }
            } else {
                throw new StorageGroupNotReadyException(storageGroupMNode.getFullPath(), TSStatusCode.STORAGE_GROUP_NOT_READY.getStatusCode());
            }
        }
        return processor;
    }

    public void recover(final StorageGroupMNode storageGroupMNode) {
        ArrayList<Thread> threadList = new ArrayList<Thread>(this.partitioner.getPartitionCount());
        int i = 0;
        while (i < this.partitioner.getPartitionCount()) {
            final int cur = i++;
            Thread recoverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StorageGroupProcessor processor = null;
                    try {
                        processor = StorageEngine.getInstance().buildNewStorageGroupProcessor(storageGroupMNode.getPartialPath(), storageGroupMNode, String.valueOf(cur));
                    }
                    catch (StorageGroupProcessorException e) {
                        logger.error("failed to recover storage group processor in " + storageGroupMNode.getFullPath() + " virtual storage group id is " + cur);
                    }
                    VirtualStorageGroupManager.this.virtualStorageGroupProcessor[cur] = processor;
                }
            });
            threadList.add(recoverThread);
            recoverThread.start();
        }
        for (i = 0; i < this.partitioner.getPartitionCount(); ++i) {
            try {
                ((Thread)threadList.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                logger.error("failed to recover storage group processor in " + storageGroupMNode.getFullPath() + " virtual storage group id is " + i);
                Thread.currentThread().interrupt();
            }
        }
    }

    public long getMonitorSeriesValue() {
        return this.monitorSeriesValue;
    }

    public void setMonitorSeriesValue(long monitorSeriesValue) {
        this.monitorSeriesValue = monitorSeriesValue;
    }

    public void updateMonitorSeriesValue(int successPointsNum) {
        this.monitorSeriesValue += (long)successPointsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(boolean isSeq, boolean isSync) {
        for (StorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("{} closing sg processor is called for closing {}, seq = {}", new Object[]{isSync ? "sync" : "async", processor.getVirtualStorageGroupId() + "-" + processor.getLogicalStorageGroupName(), isSeq});
            }
            processor.writeLock("VirtualCloseStorageGroupProcessor-boolean-boolean");
            try {
                if (isSeq) {
                    for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors())) {
                        if (isSync) {
                            processor.syncCloseOneTsFileProcessor(true, tsfileProcessor);
                            continue;
                        }
                        processor.asyncCloseOneTsFileProcessor(true, tsfileProcessor);
                    }
                    continue;
                }
                for (TsFileProcessor tsfileProcessor : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors())) {
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(false, tsfileProcessor);
                        continue;
                    }
                    processor.asyncCloseOneTsFileProcessor(false, tsfileProcessor);
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorageGroupProcessor(long partitionId, boolean isSeq, boolean isSync) {
        block3: for (StorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            logger.info("async closing sg processor is called for closing {}, seq = {}, partitionId = {}", new Object[]{processor.getVirtualStorageGroupId() + "-" + processor.getLogicalStorageGroupName(), isSeq, partitionId});
            processor.writeLock("VirtualCloseStorageGroupProcessor-long-boolean-boolean");
            try {
                ArrayList<TsFileProcessor> processors = isSeq ? new ArrayList<TsFileProcessor>(processor.getWorkSequenceTsFileProcessors()) : new ArrayList<TsFileProcessor>(processor.getWorkUnsequenceTsFileProcessors());
                for (TsFileProcessor tsfileProcessor : processors) {
                    if (tsfileProcessor.getTimeRangeId() != partitionId) continue;
                    if (isSync) {
                        processor.syncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                        continue block3;
                    }
                    processor.asyncCloseOneTsFileProcessor(isSeq, tsfileProcessor);
                    continue block3;
                }
            }
            finally {
                processor.writeUnlock();
            }
        }
    }

    public void delete(PartialPath path, long startTime, long endTime, long planIndex) throws IOException {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.delete(path, startTime, endTime, planIndex);
        }
    }

    public int countUpgradeFiles() {
        int totalUpgradeFileNum = 0;
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            totalUpgradeFileNum += storageGroupProcessor.countUpgradeFiles();
        }
        return totalUpgradeFileNum;
    }

    public void upgradeAll() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.upgrade();
        }
    }

    public void mergeAll(boolean isFullMerge) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.merge();
        }
    }

    public void syncDeleteDataFiles() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.syncDeleteDataFiles();
        }
    }

    public void setTTL(long dataTTL) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.setDataTTL(dataTTL);
        }
    }

    public void deleteStorageGroupSystemFolder(String path) {
        for (StorageGroupProcessor processor : this.virtualStorageGroupProcessor) {
            if (processor == null) continue;
            processor.deleteFolder(path);
        }
    }

    public void getAllClosedStorageGroupTsFile(PartialPath storageGroupName, Map<PartialPath, Map<Long, List<TsFileResource>>> ret) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            List<TsFileResource> allResources = storageGroupProcessor.getSequenceFileTreeSet();
            allResources.addAll(storageGroupProcessor.getUnSequenceFileList());
            for (TsFileResource tsfile : allResources) {
                if (!tsfile.isClosed()) continue;
                long partitionNum = tsfile.getTimePartition();
                Map storageGroupFiles = ret.computeIfAbsent(storageGroupName, n -> new HashMap());
                storageGroupFiles.computeIfAbsent(partitionNum, n -> new ArrayList()).add(tsfile);
            }
        }
    }

    public void setPartitionVersionToMax(long partitionId, long newMaxVersion) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.setPartitionFileVersionToMax(partitionId, newMaxVersion);
        }
    }

    public void removePartitions(StorageGroupProcessor.TimePartitionFilter filter) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.removePartitions(filter);
        }
    }

    public void getWorkingStorageGroupPartitions(String storageGroupName, Map<String, List<Pair<Long, Boolean>>> res) {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            Pair tmpPair;
            if (storageGroupProcessor == null) continue;
            ArrayList<Pair> partitionIdList = new ArrayList<Pair>();
            for (TsFileProcessor tsFileProcessor : storageGroupProcessor.getWorkSequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)true);
                partitionIdList.add(tmpPair);
            }
            for (TsFileProcessor tsFileProcessor : storageGroupProcessor.getWorkUnsequenceTsFileProcessors()) {
                tmpPair = new Pair((Object)tsFileProcessor.getTimeRangeId(), (Object)false);
                partitionIdList.add(tmpPair);
            }
            res.put(storageGroupName, partitionIdList);
        }
    }

    public void releaseWalDirectByteBufferPool() {
        for (StorageGroupProcessor storageGroupProcessor : this.virtualStorageGroupProcessor) {
            if (storageGroupProcessor == null) continue;
            storageGroupProcessor.releaseWalDirectByteBufferPool();
        }
    }

    public void reset() {
        Arrays.fill(this.virtualStorageGroupProcessor, null);
    }

    public void stopSchedulerPool() {
        for (StorageGroupProcessor vsg : this.virtualStorageGroupProcessor) {
            if (vsg == null) continue;
            ThreadUtils.stopThreadPool(vsg.getWALTrimScheduleTask(), ThreadName.WAL_TRIM.getName());
        }
    }
}

