/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.rpc.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class MultSeriesQueryRequest
implements TBase<MultSeriesQueryRequest, _Fields>,
Serializable,
Cloneable,
Comparable<MultSeriesQueryRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("MultSeriesQueryRequest");
    private static final TField PATH_FIELD_DESC = new TField("path", 15, 1);
    private static final TField TIME_FILTER_BYTES_FIELD_DESC = new TField("timeFilterBytes", 11, 2);
    private static final TField VALUE_FILTER_BYTES_FIELD_DESC = new TField("valueFilterBytes", 11, 3);
    private static final TField QUERY_ID_FIELD_DESC = new TField("queryId", 10, 4);
    private static final TField REQUESTER_FIELD_DESC = new TField("requester", 12, 5);
    private static final TField HEADER_FIELD_DESC = new TField("header", 12, 6);
    private static final TField DATA_TYPE_ORDINAL_FIELD_DESC = new TField("dataTypeOrdinal", 15, 7);
    private static final TField DEVICE_MEASUREMENTS_FIELD_DESC = new TField("deviceMeasurements", 13, 8);
    private static final TField ASCENDING_FIELD_DESC = new TField("ascending", 2, 9);
    private static final TField FETCH_SIZE_FIELD_DESC = new TField("fetchSize", 8, 10);
    private static final TField DEDUPLICATED_PATH_NUM_FIELD_DESC = new TField("deduplicatedPathNum", 8, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new MultSeriesQueryRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new MultSeriesQueryRequestTupleSchemeFactory();
    @Nullable
    public List<String> path;
    @Nullable
    public ByteBuffer timeFilterBytes;
    @Nullable
    public ByteBuffer valueFilterBytes;
    public long queryId;
    @Nullable
    public Node requester;
    @Nullable
    public Node header;
    @Nullable
    public List<Integer> dataTypeOrdinal;
    @Nullable
    public Map<String, Set<String>> deviceMeasurements;
    public boolean ascending;
    public int fetchSize;
    public int deduplicatedPathNum;
    private static final int __QUERYID_ISSET_ID = 0;
    private static final int __ASCENDING_ISSET_ID = 1;
    private static final int __FETCHSIZE_ISSET_ID = 2;
    private static final int __DEDUPLICATEDPATHNUM_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.TIME_FILTER_BYTES, _Fields.VALUE_FILTER_BYTES};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public MultSeriesQueryRequest() {
    }

    public MultSeriesQueryRequest(List<String> path, long queryId, Node requester, Node header, List<Integer> dataTypeOrdinal, Map<String, Set<String>> deviceMeasurements, boolean ascending, int fetchSize, int deduplicatedPathNum) {
        this();
        this.path = path;
        this.queryId = queryId;
        this.setQueryIdIsSet(true);
        this.requester = requester;
        this.header = header;
        this.dataTypeOrdinal = dataTypeOrdinal;
        this.deviceMeasurements = deviceMeasurements;
        this.ascending = ascending;
        this.setAscendingIsSet(true);
        this.fetchSize = fetchSize;
        this.setFetchSizeIsSet(true);
        this.deduplicatedPathNum = deduplicatedPathNum;
        this.setDeduplicatedPathNumIsSet(true);
    }

    public MultSeriesQueryRequest(MultSeriesQueryRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetPath()) {
            ArrayList<String> __this__path = new ArrayList<String>(other.path);
            this.path = __this__path;
        }
        if (other.isSetTimeFilterBytes()) {
            this.timeFilterBytes = TBaseHelper.copyBinary((ByteBuffer)other.timeFilterBytes);
        }
        if (other.isSetValueFilterBytes()) {
            this.valueFilterBytes = TBaseHelper.copyBinary((ByteBuffer)other.valueFilterBytes);
        }
        this.queryId = other.queryId;
        if (other.isSetRequester()) {
            this.requester = new Node(other.requester);
        }
        if (other.isSetHeader()) {
            this.header = new Node(other.header);
        }
        if (other.isSetDataTypeOrdinal()) {
            ArrayList<Integer> __this__dataTypeOrdinal = new ArrayList<Integer>(other.dataTypeOrdinal.size());
            for (Integer n : other.dataTypeOrdinal) {
                __this__dataTypeOrdinal.add(n);
            }
            this.dataTypeOrdinal = __this__dataTypeOrdinal;
        }
        if (other.isSetDeviceMeasurements()) {
            HashMap<String, Set<String>> __this__deviceMeasurements = new HashMap<String, Set<String>>(other.deviceMeasurements.size());
            for (Map.Entry entry : other.deviceMeasurements.entrySet()) {
                String other_element_key = (String)entry.getKey();
                Set other_element_value = (Set)entry.getValue();
                String __this__deviceMeasurements_copy_key = other_element_key;
                HashSet __this__deviceMeasurements_copy_value = new HashSet(other_element_value);
                __this__deviceMeasurements.put(__this__deviceMeasurements_copy_key, __this__deviceMeasurements_copy_value);
            }
            this.deviceMeasurements = __this__deviceMeasurements;
        }
        this.ascending = other.ascending;
        this.fetchSize = other.fetchSize;
        this.deduplicatedPathNum = other.deduplicatedPathNum;
    }

    public MultSeriesQueryRequest deepCopy() {
        return new MultSeriesQueryRequest(this);
    }

    public void clear() {
        this.path = null;
        this.timeFilterBytes = null;
        this.valueFilterBytes = null;
        this.setQueryIdIsSet(false);
        this.queryId = 0L;
        this.requester = null;
        this.header = null;
        this.dataTypeOrdinal = null;
        this.deviceMeasurements = null;
        this.setAscendingIsSet(false);
        this.ascending = false;
        this.setFetchSizeIsSet(false);
        this.fetchSize = 0;
        this.setDeduplicatedPathNumIsSet(false);
        this.deduplicatedPathNum = 0;
    }

    public int getPathSize() {
        return this.path == null ? 0 : this.path.size();
    }

    @Nullable
    public Iterator<String> getPathIterator() {
        return this.path == null ? null : this.path.iterator();
    }

    public void addToPath(String elem) {
        if (this.path == null) {
            this.path = new ArrayList<String>();
        }
        this.path.add(elem);
    }

    @Nullable
    public List<String> getPath() {
        return this.path;
    }

    public MultSeriesQueryRequest setPath(@Nullable List<String> path) {
        this.path = path;
        return this;
    }

    public void unsetPath() {
        this.path = null;
    }

    public boolean isSetPath() {
        return this.path != null;
    }

    public void setPathIsSet(boolean value) {
        if (!value) {
            this.path = null;
        }
    }

    public byte[] getTimeFilterBytes() {
        this.setTimeFilterBytes(TBaseHelper.rightSize((ByteBuffer)this.timeFilterBytes));
        return this.timeFilterBytes == null ? null : this.timeFilterBytes.array();
    }

    public ByteBuffer bufferForTimeFilterBytes() {
        return TBaseHelper.copyBinary((ByteBuffer)this.timeFilterBytes);
    }

    public MultSeriesQueryRequest setTimeFilterBytes(byte[] timeFilterBytes) {
        this.timeFilterBytes = timeFilterBytes == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])timeFilterBytes.clone());
        return this;
    }

    public MultSeriesQueryRequest setTimeFilterBytes(@Nullable ByteBuffer timeFilterBytes) {
        this.timeFilterBytes = TBaseHelper.copyBinary((ByteBuffer)timeFilterBytes);
        return this;
    }

    public void unsetTimeFilterBytes() {
        this.timeFilterBytes = null;
    }

    public boolean isSetTimeFilterBytes() {
        return this.timeFilterBytes != null;
    }

    public void setTimeFilterBytesIsSet(boolean value) {
        if (!value) {
            this.timeFilterBytes = null;
        }
    }

    public byte[] getValueFilterBytes() {
        this.setValueFilterBytes(TBaseHelper.rightSize((ByteBuffer)this.valueFilterBytes));
        return this.valueFilterBytes == null ? null : this.valueFilterBytes.array();
    }

    public ByteBuffer bufferForValueFilterBytes() {
        return TBaseHelper.copyBinary((ByteBuffer)this.valueFilterBytes);
    }

    public MultSeriesQueryRequest setValueFilterBytes(byte[] valueFilterBytes) {
        this.valueFilterBytes = valueFilterBytes == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])valueFilterBytes.clone());
        return this;
    }

    public MultSeriesQueryRequest setValueFilterBytes(@Nullable ByteBuffer valueFilterBytes) {
        this.valueFilterBytes = TBaseHelper.copyBinary((ByteBuffer)valueFilterBytes);
        return this;
    }

    public void unsetValueFilterBytes() {
        this.valueFilterBytes = null;
    }

    public boolean isSetValueFilterBytes() {
        return this.valueFilterBytes != null;
    }

    public void setValueFilterBytesIsSet(boolean value) {
        if (!value) {
            this.valueFilterBytes = null;
        }
    }

    public long getQueryId() {
        return this.queryId;
    }

    public MultSeriesQueryRequest setQueryId(long queryId) {
        this.queryId = queryId;
        this.setQueryIdIsSet(true);
        return this;
    }

    public void unsetQueryId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetQueryId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setQueryIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public Node getRequester() {
        return this.requester;
    }

    public MultSeriesQueryRequest setRequester(@Nullable Node requester) {
        this.requester = requester;
        return this;
    }

    public void unsetRequester() {
        this.requester = null;
    }

    public boolean isSetRequester() {
        return this.requester != null;
    }

    public void setRequesterIsSet(boolean value) {
        if (!value) {
            this.requester = null;
        }
    }

    @Nullable
    public Node getHeader() {
        return this.header;
    }

    public MultSeriesQueryRequest setHeader(@Nullable Node header) {
        this.header = header;
        return this;
    }

    public void unsetHeader() {
        this.header = null;
    }

    public boolean isSetHeader() {
        return this.header != null;
    }

    public void setHeaderIsSet(boolean value) {
        if (!value) {
            this.header = null;
        }
    }

    public int getDataTypeOrdinalSize() {
        return this.dataTypeOrdinal == null ? 0 : this.dataTypeOrdinal.size();
    }

    @Nullable
    public Iterator<Integer> getDataTypeOrdinalIterator() {
        return this.dataTypeOrdinal == null ? null : this.dataTypeOrdinal.iterator();
    }

    public void addToDataTypeOrdinal(int elem) {
        if (this.dataTypeOrdinal == null) {
            this.dataTypeOrdinal = new ArrayList<Integer>();
        }
        this.dataTypeOrdinal.add(elem);
    }

    @Nullable
    public List<Integer> getDataTypeOrdinal() {
        return this.dataTypeOrdinal;
    }

    public MultSeriesQueryRequest setDataTypeOrdinal(@Nullable List<Integer> dataTypeOrdinal) {
        this.dataTypeOrdinal = dataTypeOrdinal;
        return this;
    }

    public void unsetDataTypeOrdinal() {
        this.dataTypeOrdinal = null;
    }

    public boolean isSetDataTypeOrdinal() {
        return this.dataTypeOrdinal != null;
    }

    public void setDataTypeOrdinalIsSet(boolean value) {
        if (!value) {
            this.dataTypeOrdinal = null;
        }
    }

    public int getDeviceMeasurementsSize() {
        return this.deviceMeasurements == null ? 0 : this.deviceMeasurements.size();
    }

    public void putToDeviceMeasurements(String key, Set<String> val) {
        if (this.deviceMeasurements == null) {
            this.deviceMeasurements = new HashMap<String, Set<String>>();
        }
        this.deviceMeasurements.put(key, val);
    }

    @Nullable
    public Map<String, Set<String>> getDeviceMeasurements() {
        return this.deviceMeasurements;
    }

    public MultSeriesQueryRequest setDeviceMeasurements(@Nullable Map<String, Set<String>> deviceMeasurements) {
        this.deviceMeasurements = deviceMeasurements;
        return this;
    }

    public void unsetDeviceMeasurements() {
        this.deviceMeasurements = null;
    }

    public boolean isSetDeviceMeasurements() {
        return this.deviceMeasurements != null;
    }

    public void setDeviceMeasurementsIsSet(boolean value) {
        if (!value) {
            this.deviceMeasurements = null;
        }
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public MultSeriesQueryRequest setAscending(boolean ascending) {
        this.ascending = ascending;
        this.setAscendingIsSet(true);
        return this;
    }

    public void unsetAscending() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetAscending() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setAscendingIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public MultSeriesQueryRequest setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        this.setFetchSizeIsSet(true);
        return this;
    }

    public void unsetFetchSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetFetchSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setFetchSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getDeduplicatedPathNum() {
        return this.deduplicatedPathNum;
    }

    public MultSeriesQueryRequest setDeduplicatedPathNum(int deduplicatedPathNum) {
        this.deduplicatedPathNum = deduplicatedPathNum;
        this.setDeduplicatedPathNumIsSet(true);
        return this;
    }

    public void unsetDeduplicatedPathNum() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetDeduplicatedPathNum() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setDeduplicatedPathNumIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PATH: {
                if (value == null) {
                    this.unsetPath();
                    break;
                }
                this.setPath((List)value);
                break;
            }
            case TIME_FILTER_BYTES: {
                if (value == null) {
                    this.unsetTimeFilterBytes();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setTimeFilterBytes((byte[])value);
                    break;
                }
                this.setTimeFilterBytes((ByteBuffer)value);
                break;
            }
            case VALUE_FILTER_BYTES: {
                if (value == null) {
                    this.unsetValueFilterBytes();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setValueFilterBytes((byte[])value);
                    break;
                }
                this.setValueFilterBytes((ByteBuffer)value);
                break;
            }
            case QUERY_ID: {
                if (value == null) {
                    this.unsetQueryId();
                    break;
                }
                this.setQueryId((Long)value);
                break;
            }
            case REQUESTER: {
                if (value == null) {
                    this.unsetRequester();
                    break;
                }
                this.setRequester((Node)value);
                break;
            }
            case HEADER: {
                if (value == null) {
                    this.unsetHeader();
                    break;
                }
                this.setHeader((Node)value);
                break;
            }
            case DATA_TYPE_ORDINAL: {
                if (value == null) {
                    this.unsetDataTypeOrdinal();
                    break;
                }
                this.setDataTypeOrdinal((List)value);
                break;
            }
            case DEVICE_MEASUREMENTS: {
                if (value == null) {
                    this.unsetDeviceMeasurements();
                    break;
                }
                this.setDeviceMeasurements((Map)value);
                break;
            }
            case ASCENDING: {
                if (value == null) {
                    this.unsetAscending();
                    break;
                }
                this.setAscending((Boolean)value);
                break;
            }
            case FETCH_SIZE: {
                if (value == null) {
                    this.unsetFetchSize();
                    break;
                }
                this.setFetchSize((Integer)value);
                break;
            }
            case DEDUPLICATED_PATH_NUM: {
                if (value == null) {
                    this.unsetDeduplicatedPathNum();
                    break;
                }
                this.setDeduplicatedPathNum((Integer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PATH: {
                return this.getPath();
            }
            case TIME_FILTER_BYTES: {
                return this.getTimeFilterBytes();
            }
            case VALUE_FILTER_BYTES: {
                return this.getValueFilterBytes();
            }
            case QUERY_ID: {
                return this.getQueryId();
            }
            case REQUESTER: {
                return this.getRequester();
            }
            case HEADER: {
                return this.getHeader();
            }
            case DATA_TYPE_ORDINAL: {
                return this.getDataTypeOrdinal();
            }
            case DEVICE_MEASUREMENTS: {
                return this.getDeviceMeasurements();
            }
            case ASCENDING: {
                return this.isAscending();
            }
            case FETCH_SIZE: {
                return this.getFetchSize();
            }
            case DEDUPLICATED_PATH_NUM: {
                return this.getDeduplicatedPathNum();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PATH: {
                return this.isSetPath();
            }
            case TIME_FILTER_BYTES: {
                return this.isSetTimeFilterBytes();
            }
            case VALUE_FILTER_BYTES: {
                return this.isSetValueFilterBytes();
            }
            case QUERY_ID: {
                return this.isSetQueryId();
            }
            case REQUESTER: {
                return this.isSetRequester();
            }
            case HEADER: {
                return this.isSetHeader();
            }
            case DATA_TYPE_ORDINAL: {
                return this.isSetDataTypeOrdinal();
            }
            case DEVICE_MEASUREMENTS: {
                return this.isSetDeviceMeasurements();
            }
            case ASCENDING: {
                return this.isSetAscending();
            }
            case FETCH_SIZE: {
                return this.isSetFetchSize();
            }
            case DEDUPLICATED_PATH_NUM: {
                return this.isSetDeduplicatedPathNum();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof MultSeriesQueryRequest) {
            return this.equals((MultSeriesQueryRequest)that);
        }
        return false;
    }

    public boolean equals(MultSeriesQueryRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_path = this.isSetPath();
        boolean that_present_path = that.isSetPath();
        if (this_present_path || that_present_path) {
            if (!this_present_path || !that_present_path) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
        }
        boolean this_present_timeFilterBytes = this.isSetTimeFilterBytes();
        boolean that_present_timeFilterBytes = that.isSetTimeFilterBytes();
        if (this_present_timeFilterBytes || that_present_timeFilterBytes) {
            if (!this_present_timeFilterBytes || !that_present_timeFilterBytes) {
                return false;
            }
            if (!this.timeFilterBytes.equals(that.timeFilterBytes)) {
                return false;
            }
        }
        boolean this_present_valueFilterBytes = this.isSetValueFilterBytes();
        boolean that_present_valueFilterBytes = that.isSetValueFilterBytes();
        if (this_present_valueFilterBytes || that_present_valueFilterBytes) {
            if (!this_present_valueFilterBytes || !that_present_valueFilterBytes) {
                return false;
            }
            if (!this.valueFilterBytes.equals(that.valueFilterBytes)) {
                return false;
            }
        }
        boolean this_present_queryId = true;
        boolean that_present_queryId = true;
        if (this_present_queryId || that_present_queryId) {
            if (!this_present_queryId || !that_present_queryId) {
                return false;
            }
            if (this.queryId != that.queryId) {
                return false;
            }
        }
        boolean this_present_requester = this.isSetRequester();
        boolean that_present_requester = that.isSetRequester();
        if (this_present_requester || that_present_requester) {
            if (!this_present_requester || !that_present_requester) {
                return false;
            }
            if (!this.requester.equals(that.requester)) {
                return false;
            }
        }
        boolean this_present_header = this.isSetHeader();
        boolean that_present_header = that.isSetHeader();
        if (this_present_header || that_present_header) {
            if (!this_present_header || !that_present_header) {
                return false;
            }
            if (!this.header.equals(that.header)) {
                return false;
            }
        }
        boolean this_present_dataTypeOrdinal = this.isSetDataTypeOrdinal();
        boolean that_present_dataTypeOrdinal = that.isSetDataTypeOrdinal();
        if (this_present_dataTypeOrdinal || that_present_dataTypeOrdinal) {
            if (!this_present_dataTypeOrdinal || !that_present_dataTypeOrdinal) {
                return false;
            }
            if (!this.dataTypeOrdinal.equals(that.dataTypeOrdinal)) {
                return false;
            }
        }
        boolean this_present_deviceMeasurements = this.isSetDeviceMeasurements();
        boolean that_present_deviceMeasurements = that.isSetDeviceMeasurements();
        if (this_present_deviceMeasurements || that_present_deviceMeasurements) {
            if (!this_present_deviceMeasurements || !that_present_deviceMeasurements) {
                return false;
            }
            if (!this.deviceMeasurements.equals(that.deviceMeasurements)) {
                return false;
            }
        }
        boolean this_present_ascending = true;
        boolean that_present_ascending = true;
        if (this_present_ascending || that_present_ascending) {
            if (!this_present_ascending || !that_present_ascending) {
                return false;
            }
            if (this.ascending != that.ascending) {
                return false;
            }
        }
        boolean this_present_fetchSize = true;
        boolean that_present_fetchSize = true;
        if (this_present_fetchSize || that_present_fetchSize) {
            if (!this_present_fetchSize || !that_present_fetchSize) {
                return false;
            }
            if (this.fetchSize != that.fetchSize) {
                return false;
            }
        }
        boolean this_present_deduplicatedPathNum = true;
        boolean that_present_deduplicatedPathNum = true;
        if (this_present_deduplicatedPathNum || that_present_deduplicatedPathNum) {
            if (!this_present_deduplicatedPathNum || !that_present_deduplicatedPathNum) {
                return false;
            }
            if (this.deduplicatedPathNum != that.deduplicatedPathNum) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPath() ? 131071 : 524287);
        if (this.isSetPath()) {
            hashCode = hashCode * 8191 + this.path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTimeFilterBytes() ? 131071 : 524287);
        if (this.isSetTimeFilterBytes()) {
            hashCode = hashCode * 8191 + this.timeFilterBytes.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetValueFilterBytes() ? 131071 : 524287);
        if (this.isSetValueFilterBytes()) {
            hashCode = hashCode * 8191 + this.valueFilterBytes.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.queryId);
        hashCode = hashCode * 8191 + (this.isSetRequester() ? 131071 : 524287);
        if (this.isSetRequester()) {
            hashCode = hashCode * 8191 + this.requester.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetHeader() ? 131071 : 524287);
        if (this.isSetHeader()) {
            hashCode = hashCode * 8191 + this.header.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDataTypeOrdinal() ? 131071 : 524287);
        if (this.isSetDataTypeOrdinal()) {
            hashCode = hashCode * 8191 + this.dataTypeOrdinal.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDeviceMeasurements() ? 131071 : 524287);
        if (this.isSetDeviceMeasurements()) {
            hashCode = hashCode * 8191 + this.deviceMeasurements.hashCode();
        }
        hashCode = hashCode * 8191 + (this.ascending ? 131071 : 524287);
        hashCode = hashCode * 8191 + this.fetchSize;
        hashCode = hashCode * 8191 + this.deduplicatedPathNum;
        return hashCode;
    }

    @Override
    public int compareTo(MultSeriesQueryRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPath(), other.isSetPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath() && (lastComparison = TBaseHelper.compareTo(this.path, other.path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeFilterBytes(), other.isSetTimeFilterBytes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeFilterBytes() && (lastComparison = TBaseHelper.compareTo((Comparable)this.timeFilterBytes, (Comparable)other.timeFilterBytes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetValueFilterBytes(), other.isSetValueFilterBytes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValueFilterBytes() && (lastComparison = TBaseHelper.compareTo((Comparable)this.valueFilterBytes, (Comparable)other.valueFilterBytes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQueryId(), other.isSetQueryId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryId() && (lastComparison = TBaseHelper.compareTo((long)this.queryId, (long)other.queryId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRequester(), other.isSetRequester());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequester() && (lastComparison = TBaseHelper.compareTo((Comparable)this.requester, (Comparable)other.requester)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHeader(), other.isSetHeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHeader() && (lastComparison = TBaseHelper.compareTo((Comparable)this.header, (Comparable)other.header)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDataTypeOrdinal(), other.isSetDataTypeOrdinal());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataTypeOrdinal() && (lastComparison = TBaseHelper.compareTo(this.dataTypeOrdinal, other.dataTypeOrdinal)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDeviceMeasurements(), other.isSetDeviceMeasurements());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDeviceMeasurements() && (lastComparison = TBaseHelper.compareTo(this.deviceMeasurements, other.deviceMeasurements)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAscending(), other.isSetAscending());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAscending() && (lastComparison = TBaseHelper.compareTo((boolean)this.ascending, (boolean)other.ascending)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFetchSize(), other.isSetFetchSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFetchSize() && (lastComparison = TBaseHelper.compareTo((int)this.fetchSize, (int)other.fetchSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDeduplicatedPathNum(), other.isSetDeduplicatedPathNum());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDeduplicatedPathNum() && (lastComparison = TBaseHelper.compareTo((int)this.deduplicatedPathNum, (int)other.deduplicatedPathNum)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        MultSeriesQueryRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        MultSeriesQueryRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MultSeriesQueryRequest(");
        boolean first = true;
        sb.append("path:");
        if (this.path == null) {
            sb.append("null");
        } else {
            sb.append(this.path);
        }
        first = false;
        if (this.isSetTimeFilterBytes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeFilterBytes:");
            if (this.timeFilterBytes == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.timeFilterBytes, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetValueFilterBytes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("valueFilterBytes:");
            if (this.valueFilterBytes == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.valueFilterBytes, (StringBuilder)sb);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("queryId:");
        sb.append(this.queryId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("requester:");
        if (this.requester == null) {
            sb.append("null");
        } else {
            sb.append(this.requester);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("header:");
        if (this.header == null) {
            sb.append("null");
        } else {
            sb.append(this.header);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dataTypeOrdinal:");
        if (this.dataTypeOrdinal == null) {
            sb.append("null");
        } else {
            sb.append(this.dataTypeOrdinal);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("deviceMeasurements:");
        if (this.deviceMeasurements == null) {
            sb.append("null");
        } else {
            sb.append(this.deviceMeasurements);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ascending:");
        sb.append(this.ascending);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("fetchSize:");
        sb.append(this.fetchSize);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("deduplicatedPathNum:");
        sb.append(this.deduplicatedPathNum);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.path == null) {
            throw new TProtocolException("Required field 'path' was not present! Struct: " + this.toString());
        }
        if (this.requester == null) {
            throw new TProtocolException("Required field 'requester' was not present! Struct: " + this.toString());
        }
        if (this.header == null) {
            throw new TProtocolException("Required field 'header' was not present! Struct: " + this.toString());
        }
        if (this.dataTypeOrdinal == null) {
            throw new TProtocolException("Required field 'dataTypeOrdinal' was not present! Struct: " + this.toString());
        }
        if (this.deviceMeasurements == null) {
            throw new TProtocolException("Required field 'deviceMeasurements' was not present! Struct: " + this.toString());
        }
        if (this.requester != null) {
            this.requester.validate();
        }
        if (this.header != null) {
            this.header.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.TIME_FILTER_BYTES, new FieldMetaData("timeFilterBytes", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.VALUE_FILTER_BYTES, new FieldMetaData("valueFilterBytes", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.QUERY_ID, new FieldMetaData("queryId", 1, new FieldValueMetaData(10, "long")));
        tmpMap.put(_Fields.REQUESTER, new FieldMetaData("requester", 1, (FieldValueMetaData)new StructMetaData(12, Node.class)));
        tmpMap.put(_Fields.HEADER, new FieldMetaData("header", 1, (FieldValueMetaData)new StructMetaData(12, Node.class)));
        tmpMap.put(_Fields.DATA_TYPE_ORDINAL, new FieldMetaData("dataTypeOrdinal", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8, "int"))));
        tmpMap.put(_Fields.DEVICE_MEASUREMENTS, new FieldMetaData("deviceMeasurements", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11)))));
        tmpMap.put(_Fields.ASCENDING, new FieldMetaData("ascending", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.FETCH_SIZE, new FieldMetaData("fetchSize", 1, new FieldValueMetaData(8, "int")));
        tmpMap.put(_Fields.DEDUPLICATED_PATH_NUM, new FieldMetaData("deduplicatedPathNum", 1, new FieldValueMetaData(8, "int")));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(MultSeriesQueryRequest.class, metaDataMap);
    }

    private static class MultSeriesQueryRequestTupleScheme
    extends TupleScheme<MultSeriesQueryRequest> {
        private MultSeriesQueryRequestTupleScheme() {
        }

        public void write(TProtocol prot, MultSeriesQueryRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.path.size());
            for (String string : struct.path) {
                oprot.writeString(string);
            }
            oprot.writeI64(struct.queryId);
            struct.requester.write((TProtocol)oprot);
            struct.header.write((TProtocol)oprot);
            oprot.writeI32(struct.dataTypeOrdinal.size());
            Iterator<Object> iterator = struct.dataTypeOrdinal.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                oprot.writeI32(n);
            }
            oprot.writeI32(struct.deviceMeasurements.size());
            for (Map.Entry entry : struct.deviceMeasurements.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeI32(((Set)entry.getValue()).size());
                for (String _iter70 : (Set)entry.getValue()) {
                    oprot.writeString(_iter70);
                }
            }
            oprot.writeBool(struct.ascending);
            oprot.writeI32(struct.fetchSize);
            oprot.writeI32(struct.deduplicatedPathNum);
            BitSet optionals = new BitSet();
            if (struct.isSetTimeFilterBytes()) {
                optionals.set(0);
            }
            if (struct.isSetValueFilterBytes()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetTimeFilterBytes()) {
                oprot.writeBinary(struct.timeFilterBytes);
            }
            if (struct.isSetValueFilterBytes()) {
                oprot.writeBinary(struct.valueFilterBytes);
            }
        }

        public void read(TProtocol prot, MultSeriesQueryRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list71 = iprot.readListBegin((byte)11);
            struct.path = new ArrayList<String>(_list71.size);
            for (int _i73 = 0; _i73 < _list71.size; ++_i73) {
                String _elem72 = iprot.readString();
                struct.path.add(_elem72);
            }
            struct.setPathIsSet(true);
            struct.queryId = iprot.readI64();
            struct.setQueryIdIsSet(true);
            struct.requester = new Node();
            struct.requester.read((TProtocol)iprot);
            struct.setRequesterIsSet(true);
            struct.header = new Node();
            struct.header.read((TProtocol)iprot);
            struct.setHeaderIsSet(true);
            TList _list74 = iprot.readListBegin((byte)8);
            struct.dataTypeOrdinal = new ArrayList<Integer>(_list74.size);
            for (int _i76 = 0; _i76 < _list74.size; ++_i76) {
                int _elem75 = iprot.readI32();
                struct.dataTypeOrdinal.add(_elem75);
            }
            struct.setDataTypeOrdinalIsSet(true);
            TMap _map77 = iprot.readMapBegin((byte)11, (byte)14);
            struct.deviceMeasurements = new HashMap<String, Set<String>>(2 * _map77.size);
            for (int _i80 = 0; _i80 < _map77.size; ++_i80) {
                String _key78 = iprot.readString();
                TSet _set81 = iprot.readSetBegin((byte)11);
                HashSet<String> _val79 = new HashSet<String>(2 * _set81.size);
                for (int _i83 = 0; _i83 < _set81.size; ++_i83) {
                    String _elem82 = iprot.readString();
                    _val79.add(_elem82);
                }
                struct.deviceMeasurements.put(_key78, _val79);
            }
            struct.setDeviceMeasurementsIsSet(true);
            struct.ascending = iprot.readBool();
            struct.setAscendingIsSet(true);
            struct.fetchSize = iprot.readI32();
            struct.setFetchSizeIsSet(true);
            struct.deduplicatedPathNum = iprot.readI32();
            struct.setDeduplicatedPathNumIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.timeFilterBytes = iprot.readBinary();
                struct.setTimeFilterBytesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.valueFilterBytes = iprot.readBinary();
                struct.setValueFilterBytesIsSet(true);
            }
        }
    }

    private static class MultSeriesQueryRequestTupleSchemeFactory
    implements SchemeFactory {
        private MultSeriesQueryRequestTupleSchemeFactory() {
        }

        public MultSeriesQueryRequestTupleScheme getScheme() {
            return new MultSeriesQueryRequestTupleScheme();
        }
    }

    private static class MultSeriesQueryRequestStandardScheme
    extends StandardScheme<MultSeriesQueryRequest> {
        private MultSeriesQueryRequestStandardScheme() {
        }

        public void read(TProtocol iprot, MultSeriesQueryRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list50 = iprot.readListBegin();
                            struct.path = new ArrayList<String>(_list50.size);
                            for (int _i52 = 0; _i52 < _list50.size; ++_i52) {
                                String _elem51 = iprot.readString();
                                struct.path.add(_elem51);
                            }
                            iprot.readListEnd();
                            struct.setPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.timeFilterBytes = iprot.readBinary();
                            struct.setTimeFilterBytesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.valueFilterBytes = iprot.readBinary();
                            struct.setValueFilterBytesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.queryId = iprot.readI64();
                            struct.setQueryIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.requester = new Node();
                            struct.requester.read(iprot);
                            struct.setRequesterIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.header = new Node();
                            struct.header.read(iprot);
                            struct.setHeaderIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list53 = iprot.readListBegin();
                            struct.dataTypeOrdinal = new ArrayList<Integer>(_list53.size);
                            for (int _i55 = 0; _i55 < _list53.size; ++_i55) {
                                int _elem54 = iprot.readI32();
                                struct.dataTypeOrdinal.add(_elem54);
                            }
                            iprot.readListEnd();
                            struct.setDataTypeOrdinalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 13) {
                            TMap _map56 = iprot.readMapBegin();
                            struct.deviceMeasurements = new HashMap<String, Set<String>>(2 * _map56.size);
                            for (int _i59 = 0; _i59 < _map56.size; ++_i59) {
                                String _key57 = iprot.readString();
                                TSet _set60 = iprot.readSetBegin();
                                HashSet<String> _val58 = new HashSet<String>(2 * _set60.size);
                                for (int _i62 = 0; _i62 < _set60.size; ++_i62) {
                                    String _elem61 = iprot.readString();
                                    _val58.add(_elem61);
                                }
                                iprot.readSetEnd();
                                struct.deviceMeasurements.put(_key57, _val58);
                            }
                            iprot.readMapEnd();
                            struct.setDeviceMeasurementsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 2) {
                            struct.ascending = iprot.readBool();
                            struct.setAscendingIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.fetchSize = iprot.readI32();
                            struct.setFetchSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.deduplicatedPathNum = iprot.readI32();
                            struct.setDeduplicatedPathNumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetQueryId()) {
                throw new TProtocolException("Required field 'queryId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetAscending()) {
                throw new TProtocolException("Required field 'ascending' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetFetchSize()) {
                throw new TProtocolException("Required field 'fetchSize' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetDeduplicatedPathNum()) {
                throw new TProtocolException("Required field 'deduplicatedPathNum' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, MultSeriesQueryRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.path != null) {
                oprot.writeFieldBegin(PATH_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.path.size()));
                for (String string : struct.path) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.timeFilterBytes != null && struct.isSetTimeFilterBytes()) {
                oprot.writeFieldBegin(TIME_FILTER_BYTES_FIELD_DESC);
                oprot.writeBinary(struct.timeFilterBytes);
                oprot.writeFieldEnd();
            }
            if (struct.valueFilterBytes != null && struct.isSetValueFilterBytes()) {
                oprot.writeFieldBegin(VALUE_FILTER_BYTES_FIELD_DESC);
                oprot.writeBinary(struct.valueFilterBytes);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(QUERY_ID_FIELD_DESC);
            oprot.writeI64(struct.queryId);
            oprot.writeFieldEnd();
            if (struct.requester != null) {
                oprot.writeFieldBegin(REQUESTER_FIELD_DESC);
                struct.requester.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.header != null) {
                oprot.writeFieldBegin(HEADER_FIELD_DESC);
                struct.header.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.dataTypeOrdinal != null) {
                oprot.writeFieldBegin(DATA_TYPE_ORDINAL_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.dataTypeOrdinal.size()));
                Iterator<Object> iterator = struct.dataTypeOrdinal.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    oprot.writeI32(n);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.deviceMeasurements != null) {
                oprot.writeFieldBegin(DEVICE_MEASUREMENTS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 14, struct.deviceMeasurements.size()));
                for (Map.Entry entry : struct.deviceMeasurements.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeSetBegin(new TSet(11, ((Set)entry.getValue()).size()));
                    for (String _iter66 : (Set)entry.getValue()) {
                        oprot.writeString(_iter66);
                    }
                    oprot.writeSetEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(ASCENDING_FIELD_DESC);
            oprot.writeBool(struct.ascending);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(FETCH_SIZE_FIELD_DESC);
            oprot.writeI32(struct.fetchSize);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DEDUPLICATED_PATH_NUM_FIELD_DESC);
            oprot.writeI32(struct.deduplicatedPathNum);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MultSeriesQueryRequestStandardSchemeFactory
    implements SchemeFactory {
        private MultSeriesQueryRequestStandardSchemeFactory() {
        }

        public MultSeriesQueryRequestStandardScheme getScheme() {
            return new MultSeriesQueryRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PATH(1, "path"),
        TIME_FILTER_BYTES(2, "timeFilterBytes"),
        VALUE_FILTER_BYTES(3, "valueFilterBytes"),
        QUERY_ID(4, "queryId"),
        REQUESTER(5, "requester"),
        HEADER(6, "header"),
        DATA_TYPE_ORDINAL(7, "dataTypeOrdinal"),
        DEVICE_MEASUREMENTS(8, "deviceMeasurements"),
        ASCENDING(9, "ascending"),
        FETCH_SIZE(10, "fetchSize"),
        DEDUPLICATED_PATH_NUM(11, "deduplicatedPathNum");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PATH;
                }
                case 2: {
                    return TIME_FILTER_BYTES;
                }
                case 3: {
                    return VALUE_FILTER_BYTES;
                }
                case 4: {
                    return QUERY_ID;
                }
                case 5: {
                    return REQUESTER;
                }
                case 6: {
                    return HEADER;
                }
                case 7: {
                    return DATA_TYPE_ORDINAL;
                }
                case 8: {
                    return DEVICE_MEASUREMENTS;
                }
                case 9: {
                    return ASCENDING;
                }
                case 10: {
                    return FETCH_SIZE;
                }
                case 11: {
                    return DEDUPLICATED_PATH_NUM;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

