/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.net.InetSocketAddress;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.MetaClusterServer;
import org.apache.iotdb.cluster.server.heartbeat.HeartbeatServer;
import org.apache.thrift.TProcessor;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaHeartbeatServer
extends HeartbeatServer {
    private static Logger logger = LoggerFactory.getLogger(MetaHeartbeatServer.class);
    private MetaClusterServer metaClusterServer;

    private MetaHeartbeatServer() {
    }

    public MetaHeartbeatServer(Node thisNode, MetaClusterServer metaClusterServer) {
        super(thisNode);
        this.metaClusterServer = metaClusterServer;
    }

    @Override
    TProcessor getProcessor() {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TSMetaService.AsyncProcessor((TSMetaService.AsyncIface)this.metaClusterServer);
        }
        return new TSMetaService.Processor((TSMetaService.Iface)this.metaClusterServer);
    }

    @Override
    TServerTransport getHeartbeatServerSocket() throws TTransportException {
        logger.info("[{}] Cluster node will listen {}:{}", new Object[]{this.getServerClientName(), this.config.getInternalIp(), this.config.getInternalMetaPort() + 1});
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TNonblockingServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.config.getInternalMetaPort() + 1), MetaHeartbeatServer.getConnectionTimeoutInMS());
        }
        return new TServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.config.getInternalMetaPort() + 1));
    }

    @Override
    String getClientThreadPrefix() {
        return "MetaHeartbeatClientThread-";
    }

    @Override
    String getServerClientName() {
        return "MetaHeartbeatServerThread-";
    }
}

