/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.query.reader.DataSourceInfo;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSimpleSeriesReader
implements IPointReader {
    private static final Logger logger = LoggerFactory.getLogger(RemoteSimpleSeriesReader.class);
    private DataSourceInfo sourceInfo;
    private long lastTimestamp;
    private BatchData cachedBatch;
    private AtomicReference<ByteBuffer> fetchResult = new AtomicReference();
    private GenericHandler<ByteBuffer> handler;

    public RemoteSimpleSeriesReader(DataSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.handler = new GenericHandler<ByteBuffer>(sourceInfo.getCurrentNode(), this.fetchResult);
        this.lastTimestamp = Long.MIN_VALUE;
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.cachedBatch != null && this.cachedBatch.hasCurrent()) {
            return true;
        }
        this.fetchBatch();
        return this.cachedBatch != null && this.cachedBatch.hasCurrent();
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        if (!this.hasNextTimeValuePair()) {
            throw new NoSuchElementException();
        }
        this.lastTimestamp = this.cachedBatch.currentTime();
        TimeValuePair timeValuePair = new TimeValuePair(this.cachedBatch.currentTime(), TsPrimitiveType.getByType((TSDataType)this.sourceInfo.getDataType(), (Object)this.cachedBatch.currentValue()));
        this.cachedBatch.next();
        return timeValuePair;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        if (!this.hasNextTimeValuePair()) {
            throw new NoSuchElementException();
        }
        return new TimeValuePair(this.cachedBatch.currentTime(), TsPrimitiveType.getByType((TSDataType)this.sourceInfo.getDataType(), (Object)this.cachedBatch.currentValue()));
    }

    public void close() {
    }

    private void fetchBatch() throws IOException {
        if (!this.sourceInfo.checkCurClient()) {
            this.cachedBatch = null;
            return;
        }
        ByteBuffer result = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.fetchResultAsync() : this.fetchResultSync();
        this.cachedBatch = SerializeUtils.deserializeBatchData((ByteBuffer)result);
        if (logger.isDebugEnabled()) {
            logger.debug("Fetched a batch from {}, size:{}", (Object)this.sourceInfo.getCurrentNode(), (Object)(this.cachedBatch == null ? 0 : this.cachedBatch.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer fetchResultAsync() throws IOException {
        AtomicReference<ByteBuffer> atomicReference = this.fetchResult;
        synchronized (atomicReference) {
            this.fetchResult.set(null);
            try {
                this.sourceInfo.getCurAsyncClient(RaftServer.getReadOperationTimeoutMS()).fetchSingleSeries(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId(), this.handler);
                this.fetchResult.wait(RaftServer.getReadOperationTimeoutMS());
            }
            catch (TException e) {
                if (!this.sourceInfo.switchNode(false, this.lastTimestamp)) {
                    return null;
                }
                return this.fetchResultAsync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Query {} interrupted", (Object)this.sourceInfo);
                return null;
            }
        }
        return this.fetchResult.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer fetchResultSync() throws IOException {
        SyncDataClient curSyncClient = null;
        try {
            curSyncClient = this.sourceInfo.getCurSyncClient(RaftServer.getReadOperationTimeoutMS());
            ByteBuffer byteBuffer = curSyncClient.fetchSingleSeries(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId());
            return byteBuffer;
        }
        catch (TException e) {
            curSyncClient.getInputProtocol().getTransport().close();
            if (!this.sourceInfo.switchNode(false, this.lastTimestamp)) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = this.fetchResultSync();
            return byteBuffer;
        }
        finally {
            if (curSyncClient != null) {
                ClientUtils.putBackSyncClient((RaftService.Client)curSyncClient);
            }
        }
    }

    void clearCurDataForTest() {
        this.cachedBatch = null;
    }
}

