/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.groupby;

import java.util.ArrayList;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.query.reader.ClusterTimeGenerator;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class ClusterGroupByVFilterDataSet
extends GroupByWithValueFilterDataSet {
    private MetaGroupMember metaGroupMember;
    private ClusterReaderFactory readerFactory;

    public ClusterGroupByVFilterDataSet(QueryContext context, GroupByTimePlan groupByPlan, MetaGroupMember metaGroupMember) throws StorageEngineException, QueryProcessException {
        this.initQueryDataSetFields(new ArrayList(groupByPlan.getDeduplicatedPaths()), groupByPlan.getDeduplicatedDataTypes(), groupByPlan.isAscending());
        this.initGroupByEngineDataSetFields(context, groupByPlan);
        this.timeStampFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
        this.metaGroupMember = metaGroupMember;
        this.readerFactory = new ClusterReaderFactory(metaGroupMember);
        this.initGroupBy(context, groupByPlan);
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan rawDataQueryPlan) throws StorageEngineException {
        return new ClusterTimeGenerator(context, this.metaGroupMember, rawDataQueryPlan, false);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan dataQueryPlan, TSDataType dataType, QueryContext context, TsFileFilter fileFilter) throws StorageEngineException, QueryProcessException {
        return this.readerFactory.getReaderByTimestamp(path, dataQueryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, dataQueryPlan.isAscending());
    }
}

