/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.client.async.AsyncClientFactory;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.utils.ClusterNode;
import org.apache.thrift.async.TAsyncMethodCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClientPool {
    private static final Logger logger = LoggerFactory.getLogger(AsyncClientPool.class);
    private long waitClientTimeutMS;
    private int maxConnectionForEachNode;
    private Map<ClusterNode, Deque<RaftService.AsyncClient>> clientCaches = new ConcurrentHashMap<ClusterNode, Deque<RaftService.AsyncClient>>();
    private Map<ClusterNode, Integer> nodeClientNumMap = new ConcurrentHashMap<ClusterNode, Integer>();
    private AsyncClientFactory asyncClientFactory;

    public AsyncClientPool(AsyncClientFactory asyncClientFactory) {
        this.asyncClientFactory = asyncClientFactory;
        this.waitClientTimeutMS = ClusterDescriptor.getInstance().getConfig().getWaitClientTimeoutMS();
        this.maxConnectionForEachNode = ClusterDescriptor.getInstance().getConfig().getMaxClientPerNodePerMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftService.AsyncClient getClientForRefresh(Node node) {
        Deque clientStack;
        ClusterNode clusterNode = new ClusterNode(node);
        Deque deque = clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        synchronized (deque) {
            if (clientStack.isEmpty()) {
                return null;
            }
            return (RaftService.AsyncClient)clientStack.pollLast();
        }
    }

    public RaftService.AsyncClient getClient(Node node) throws IOException {
        return this.getClient(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftService.AsyncClient getClient(Node node, boolean activatedOnly) throws IOException {
        RaftService.AsyncClient client;
        Deque clientStack;
        ClusterNode clusterNode = new ClusterNode(node);
        if (activatedOnly && !NodeStatusManager.getINSTANCE().isActivated(node)) {
            return null;
        }
        Deque deque = clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        synchronized (deque) {
            if (clientStack.isEmpty()) {
                int nodeClientNum = this.nodeClientNumMap.getOrDefault((Object)clusterNode, 0);
                if (nodeClientNum >= this.maxConnectionForEachNode) {
                    client = this.waitForClient(clientStack, clusterNode);
                } else {
                    client = this.asyncClientFactory.getAsyncClient(clusterNode, this);
                    this.nodeClientNumMap.compute(clusterNode, (n, oldValue) -> {
                        if (oldValue == null) {
                            return 1;
                        }
                        return oldValue + 1;
                    });
                }
            } else {
                client = (RaftService.AsyncClient)clientStack.pop();
            }
        }
        return client;
    }

    private RaftService.AsyncClient waitForClient(Deque<RaftService.AsyncClient> clientStack, ClusterNode clusterNode) throws IOException {
        long waitStart = System.currentTimeMillis();
        while (clientStack.isEmpty()) {
            try {
                clientStack.wait(this.waitClientTimeutMS);
                if (!clientStack.isEmpty() || System.currentTimeMillis() - waitStart < this.waitClientTimeutMS) continue;
                logger.warn("{} Cannot get an available client after {}ms, create a new one.", (Object)this.asyncClientFactory, (Object)this.waitClientTimeutMS);
                RaftService.AsyncClient asyncClient = this.asyncClientFactory.getAsyncClient(clusterNode, this);
                this.nodeClientNumMap.computeIfPresent(clusterNode, (n, oldValue) -> oldValue + 1);
                return asyncClient;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted when waiting for an available client of {}", (Object)clusterNode);
                return null;
            }
        }
        return clientStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(Node node, RaftService.AsyncClient client) {
        Deque clientStack;
        ClusterNode clusterNode = new ClusterNode(node);
        TAsyncMethodCall<Object> call = null;
        if (client instanceof AsyncDataClient) {
            call = ((AsyncDataClient)client).getCurrMethod();
        } else if (client instanceof AsyncMetaClient) {
            call = ((AsyncMetaClient)client).getCurrMethod();
        }
        if (call != null) {
            logger.warn("A using client {} is put back while running {}", (Object)client.hashCode(), call);
        }
        Deque deque = clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        synchronized (deque) {
            clientStack.push(client);
            clientStack.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onError(Node node) {
        Deque clientStack;
        ClusterNode clusterNode = new ClusterNode(node);
        Deque deque = clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        synchronized (deque) {
            while (!clientStack.isEmpty()) {
                RaftService.AsyncClient client = (RaftService.AsyncClient)clientStack.pop();
                if (client instanceof AsyncDataClient) {
                    ((AsyncDataClient)client).close();
                    continue;
                }
                if (!(client instanceof AsyncMetaClient)) continue;
                ((AsyncMetaClient)client).close();
            }
            this.nodeClientNumMap.put(clusterNode, 0);
            clientStack.notifyAll();
            NodeStatusManager.getINSTANCE().deactivate(node);
        }
    }

    void onComplete(Node node) {
        NodeStatusManager.getINSTANCE().activate(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateClient(Node node) {
        Deque clientStack;
        ClusterNode clusterNode = new ClusterNode(node);
        Deque deque = clientStack = this.clientCaches.computeIfAbsent(clusterNode, n -> new ArrayDeque());
        synchronized (deque) {
            try {
                RaftService.AsyncClient asyncClient = this.asyncClientFactory.getAsyncClient(node, this);
                clientStack.push(asyncClient);
            }
            catch (IOException e) {
                logger.error("Cannot create a new client for {}", (Object)node, (Object)e);
                this.nodeClientNumMap.computeIfPresent(clusterNode, (n, cnt) -> cnt - 1);
            }
            clientStack.notifyAll();
        }
    }

    public Map<ClusterNode, Integer> getNodeClientNumMap() {
        return this.nodeClientNumMap;
    }
}

