/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.upgrade;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.apache.iotdb.tsfile.v2.read.reader.page.PageReaderV2;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOnlineUpgradeTool
extends TsFileRewriteTool {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOnlineUpgradeTool.class);

    public TsFileOnlineUpgradeTool(TsFileResource resourceToBeUpgraded) throws IOException {
        super(resourceToBeUpgraded, true);
    }

    public static void upgradeOneTsFile(TsFileResource resourceToBeUpgraded, List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        try (TsFileOnlineUpgradeTool updater = new TsFileOnlineUpgradeTool(resourceToBeUpgraded);){
            updater.upgradeFile(upgradedResources);
        }
    }

    /*
     * Exception decompiling
     */
    private void upgradeFile(List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String upgradeTsFileName(String oldTsFileName) {
        String[] name = oldTsFileName.split(".tsfile");
        return name[0] + "-0" + ".tsfile";
    }

    @Override
    protected boolean checkIfNeedToDecode(TSDataType dataType, TSEncoding encoding, PageHeader pageHeader) {
        return dataType == TSDataType.BOOLEAN || dataType == TSDataType.TEXT || dataType == TSDataType.INT32 && encoding == TSEncoding.PLAIN || StorageEngine.getTimePartition(pageHeader.getStartTime()) != StorageEngine.getTimePartition(pageHeader.getEndTime());
    }

    @Override
    protected void decodeAndWritePage(MeasurementSchema schema, ByteBuffer pageData, Map<Long, ChunkWriterImpl> partitionChunkWriterMap) throws IOException {
        this.valueDecoder.reset();
        PageReaderV2 pageReader = new PageReaderV2(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        this.rewritePageIntoFiles(batchData, schema, partitionChunkWriterMap);
    }

    @Override
    protected boolean fileCheck() throws IOException {
        String magic = this.reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        String versionNumber = ((TsFileSequenceReaderForV2)this.reader).readVersionNumberV2();
        if (!versionNumber.equals("000002")) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        if (!this.reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        return true;
    }
}

