/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.timegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTimeGenerator
extends TimeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ServerTimeGenerator.class);
    protected QueryContext context;
    protected RawDataQueryPlan queryPlan;
    private Filter timeFilter;

    public ServerTimeGenerator(QueryContext context) {
        this.context = context;
    }

    public ServerTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        this.context = context;
        this.queryPlan = queryPlan;
        try {
            this.serverConstructNode(queryPlan.getExpression());
        }
        catch (IOException | QueryProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    public void serverConstructNode(IExpression expression) throws IOException, StorageEngineException, QueryProcessException {
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        this.timeFilter = this.getPathListAndConstructTimeFilterFromExpression(expression, pathList);
        Pair<List<StorageGroupProcessor>, Map<StorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(pathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, this.context, this.timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        this.operatorNode = this.construct(expression);
    }

    private Filter getPathListAndConstructTimeFilterFromExpression(IExpression expression, List<PartialPath> pathList) {
        if (expression.getType() == ExpressionType.SERIES) {
            pathList.add((PartialPath)((SingleSeriesExpression)expression).getSeriesPath());
            return this.getTimeFilter(((SingleSeriesExpression)expression).getFilter());
        }
        Filter leftTimeFilter = this.getTimeFilter(this.getPathListAndConstructTimeFilterFromExpression(((IBinaryExpression)expression).getLeft(), pathList));
        Filter rightTimeFilter = this.getTimeFilter(this.getPathListAndConstructTimeFilterFromExpression(((IBinaryExpression)expression).getRight(), pathList));
        if (expression instanceof AndFilter) {
            if (leftTimeFilter != null && rightTimeFilter != null) {
                return FilterFactory.and((Filter)leftTimeFilter, (Filter)rightTimeFilter);
            }
            if (leftTimeFilter != null) {
                return leftTimeFilter;
            }
            return rightTimeFilter;
        }
        if (leftTimeFilter != null && rightTimeFilter != null) {
            return FilterFactory.or((Filter)leftTimeFilter, (Filter)rightTimeFilter);
        }
        return null;
    }

    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        QueryDataSource queryDataSource;
        TSDataType dataType;
        Filter valueFilter = expression.getFilter();
        PartialPath path = (PartialPath)expression.getSeriesPath();
        try {
            dataType = IoTDB.metaManager.getSeriesType(path);
            queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, this.context, valueFilter);
            valueFilter = queryDataSource.updateFilterUsingTTL(valueFilter);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Filter timeFilter = this.getTimeFilter(valueFilter);
        return new SeriesRawDataBatchReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, this.context, queryDataSource, timeFilter, valueFilter, null, this.queryPlan.isAscending());
    }

    protected Filter getTimeFilter(Filter filter) {
        if (filter instanceof UnaryFilter && ((UnaryFilter)filter).getFilterType() == FilterType.TIME_FILTER) {
            return filter;
        }
        if (filter instanceof AndFilter) {
            Filter leftTimeFilter = this.getTimeFilter(((AndFilter)filter).getLeft());
            Filter rightTimeFilter = this.getTimeFilter(((AndFilter)filter).getRight());
            if (leftTimeFilter != null && rightTimeFilter != null) {
                return filter;
            }
            if (leftTimeFilter != null) {
                return leftTimeFilter;
            }
            return rightTimeFilter;
        }
        return null;
    }

    protected boolean isAscending() {
        return this.queryPlan.isAscending();
    }

    public Filter getTimeFilter() {
        return this.timeFilter;
    }
}

