/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.IFilterOptimizer;

public class RemoveNotOptimizer
implements IFilterOptimizer {
    @Override
    public FilterOperator optimize(FilterOperator filter) throws LogicalOperatorException {
        return this.removeNot(filter);
    }

    private FilterOperator removeNot(FilterOperator filter) throws LogicalOperatorException {
        if (filter.isLeaf()) {
            return filter;
        }
        int tokenInt = filter.getTokenIntType();
        switch (tokenInt) {
            case 1: 
            case 2: {
                List<FilterOperator> children = filter.getChildren();
                if (children.size() < 2) {
                    throw new LogicalOptimizeException("Filter has some time series don't correspond to any known time series");
                }
                children.set(0, this.removeNot(children.get(0)));
                children.set(1, this.removeNot(children.get(1)));
                return filter;
            }
            case 3: {
                if (filter.getChildren().size() < 1) {
                    throw new LogicalOptimizeException("Filter has some time series don't correspond to any known time series");
                }
                return this.reverseFilter(filter.getChildren().get(0));
            }
        }
        throw new LogicalOptimizeException("removeNot", tokenInt);
    }

    private FilterOperator reverseFilter(FilterOperator filter) throws LogicalOperatorException {
        int tokenInt = filter.getTokenIntType();
        if (filter.isLeaf()) {
            ((FunctionOperator)filter).reverseFunc();
            return filter;
        }
        switch (tokenInt) {
            case 1: 
            case 2: {
                List<FilterOperator> children = filter.getChildren();
                children.set(0, this.reverseFilter(children.get(0)));
                children.set(1, this.reverseFilter(children.get(1)));
                filter.setTokenIntType(SQLConstant.reverseWords.get(tokenInt));
                return filter;
            }
            case 3: {
                return this.removeNot(filter.getChildren().get(0));
            }
        }
        throw new LogicalOptimizeException("reverseFilter", tokenInt);
    }
}

