/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.StatusUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateMultiTimeSeriesPlan
extends PhysicalPlan
implements BatchPlan {
    private List<PartialPath> paths;
    private List<PartialPath> prefixPaths;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> alias = null;
    private List<Map<String, String>> props = null;
    private List<Map<String, String>> tags = null;
    private List<Map<String, String>> attributes = null;
    boolean[] isExecuted;
    private Map<Integer, TSStatus> results = new TreeMap<Integer, TSStatus>();
    private List<Integer> indexes;

    public CreateMultiTimeSeriesPlan() {
        super(false, Operator.OperatorType.CREATE_MULTI_TIMESERIES);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    public List<Map<String, String>> getProps() {
        return this.props;
    }

    public void setProps(List<Map<String, String>> props) {
        this.props = props;
    }

    public List<Map<String, String>> getTags() {
        return this.tags;
    }

    public void setTags(List<Map<String, String>> tags) {
        this.tags = tags;
    }

    public List<Map<String, String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Map<String, String>> attributes) {
        this.attributes = attributes;
    }

    public List<Integer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    @Override
    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    @Override
    public List<PartialPath> getPrefixPaths() {
        if (this.prefixPaths != null) {
            return this.prefixPaths;
        }
        this.prefixPaths = this.paths.stream().map(PartialPath::getDevicePath).collect(Collectors.toList());
        return this.prefixPaths;
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, this.paths.size());
    }

    public void setResults(Map<Integer, TSStatus> results) {
        this.results = results;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.CREATE_MULTI_TIMESERIES.ordinal();
        stream.write(type);
        stream.writeInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(stream, path.getFullPath());
        }
        for (TSDataType dataType : this.dataTypes) {
            stream.write(dataType.ordinal());
        }
        for (TSEncoding encoding : this.encodings) {
            stream.write(encoding.ordinal());
        }
        for (CompressionType compressor : this.compressors) {
            stream.write(compressor.ordinal());
        }
        this.serializeOptional(stream);
        stream.writeLong(this.index);
    }

    private void serializeOptional(DataOutputStream stream) throws IOException {
        if (this.alias != null) {
            stream.write(1);
            this.putStrings(stream, this.alias);
        } else {
            stream.write(0);
        }
        if (this.props != null) {
            stream.write(1);
            ReadWriteIOUtils.write(this.props, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.tags != null) {
            stream.write(1);
            ReadWriteIOUtils.write(this.tags, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
        if (this.attributes != null) {
            stream.write(1);
            ReadWriteIOUtils.write(this.attributes, (DataOutputStream)stream);
        } else {
            stream.write(0);
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.CREATE_MULTI_TIMESERIES.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(buffer, path.getFullPath());
        }
        for (TSDataType dataType : this.dataTypes) {
            buffer.put((byte)dataType.ordinal());
        }
        for (TSEncoding encoding : this.encodings) {
            buffer.put((byte)encoding.ordinal());
        }
        for (CompressionType compressor : this.compressors) {
            buffer.put((byte)compressor.ordinal());
        }
        this.serializeOptional(buffer);
        buffer.putLong(this.index);
    }

    private void serializeOptional(ByteBuffer buffer) {
        if (this.alias != null) {
            buffer.put((byte)1);
            this.putStrings(buffer, this.alias);
        } else {
            buffer.put((byte)0);
        }
        if (this.props != null) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.props, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        if (this.tags != null) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.tags, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
        if (this.attributes != null) {
            buffer.put((byte)1);
            ReadWriteIOUtils.write(this.attributes, (ByteBuffer)buffer);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        int totalSize = buffer.getInt();
        this.paths = new ArrayList<PartialPath>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        this.dataTypes = new ArrayList<TSDataType>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.dataTypes.add(TSDataType.values()[buffer.get()]);
        }
        this.encodings = new ArrayList<TSEncoding>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.encodings.add(TSEncoding.values()[buffer.get()]);
        }
        this.compressors = new ArrayList<CompressionType>(totalSize);
        for (i = 0; i < totalSize; ++i) {
            this.compressors.add(CompressionType.values()[buffer.get()]);
        }
        this.deserializeOptional(buffer, totalSize);
        this.index = buffer.getLong();
    }

    private void deserializeOptional(ByteBuffer buffer, int totalSize) {
        if (buffer.get() == 1) {
            this.alias = this.readStrings(buffer, totalSize);
        }
        if (buffer.get() == 1) {
            this.props = ReadWriteIOUtils.readMaps((ByteBuffer)buffer, (int)totalSize);
        }
        if (buffer.get() == 1) {
            this.tags = ReadWriteIOUtils.readMaps((ByteBuffer)buffer, (int)totalSize);
        }
        if (buffer.get() == 1) {
            this.attributes = ReadWriteIOUtils.readMaps((ByteBuffer)buffer, (int)totalSize);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMultiTimeSeriesPlan that = (CreateMultiTimeSeriesPlan)o;
        return Objects.equals(this.paths, that.paths) && Objects.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.encodings, that.encodings) && Objects.equals(this.compressors, that.compressors);
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.dataTypes, this.encodings, this.compressors);
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        if (this.paths == null || this.paths.isEmpty()) {
            throw new QueryProcessException("sub timeseries are empty");
        }
        if (this.paths.size() != this.dataTypes.size()) {
            throw new QueryProcessException(String.format("Measurements length [%d] does not match  datatype length [%d]", this.paths.size(), this.dataTypes.size()));
        }
        for (PartialPath path : this.paths) {
            if (path != null) continue;
            throw new QueryProcessException("Paths contain null: " + Arrays.toString(this.paths.toArray()));
        }
    }

    @Override
    public void setIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = true;
    }

    @Override
    public boolean isExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        return this.isExecuted[i];
    }

    @Override
    public int getBatchSize() {
        return this.paths.size();
    }

    @Override
    public void unsetIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = false;
        if (this.indexes != null && !this.indexes.isEmpty()) {
            this.results.remove(this.indexes.get(i));
        } else {
            this.results.remove(i);
        }
    }
}

