/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.iotdb.db.mqtt.PayloadFormatter;

public class PayloadFormatManager {
    private static Map<String, PayloadFormatter> map = new HashMap<String, PayloadFormatter>();

    private static void init() {
        ServiceLoader<PayloadFormatter> formats = ServiceLoader.load(PayloadFormatter.class);
        for (PayloadFormatter format : formats) {
            map.put(format.getName(), format);
        }
    }

    public static PayloadFormatter getPayloadFormat(String name) {
        Preconditions.checkArgument((boolean)map.containsKey(name), (Object)("Unknown payload format named: " + name));
        return map.get(name);
    }

    static {
        PayloadFormatManager.init();
    }
}

