/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Metadata
implements Serializable {
    private Map<String, List<String>> deviceIdMap;

    public Metadata(Map<String, List<String>> deviceIdMap) {
        this.deviceIdMap = deviceIdMap;
    }

    public Map<String, List<String>> getDeviceMap() {
        return this.deviceIdMap;
    }

    public static Metadata combineMetadatas(Metadata[] metadatas) {
        HashMap<String, List<String>> deviceIdMap = new HashMap<String, List<String>>();
        if (metadatas == null || metadatas.length == 0) {
            return new Metadata(deviceIdMap);
        }
        for (int i = 0; i < metadatas.length; ++i) {
            Map<String, List<String>> subDeviceIdMap = metadatas[i].deviceIdMap;
            for (Map.Entry<String, List<String>> entry : subDeviceIdMap.entrySet()) {
                List list = deviceIdMap.getOrDefault(entry.getKey(), new ArrayList());
                list.addAll((Collection)entry.getValue());
                if (deviceIdMap.containsKey(entry.getKey())) continue;
                deviceIdMap.put(entry.getKey(), list);
            }
            metadatas[i] = null;
        }
        return new Metadata(deviceIdMap);
    }

    public String toString() {
        return this.deviceIdMap.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)obj;
        return this.deviceIdMapEquals(this.deviceIdMap, metadata.deviceIdMap);
    }

    public int hashCode() {
        return Objects.hash(this.deviceIdMap);
    }

    private boolean deviceIdMapEquals(Map<String, List<String>> map1, Map<String, List<String>> map2) {
        if (!map1.keySet().equals(map2.keySet())) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : map1.entrySet()) {
            List<String> list2;
            List<String> list1 = entry.getValue();
            if (this.listEquals(list1, list2 = map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private boolean listEquals(List list1, List list2) {
        HashSet set1 = new HashSet();
        set1.addAll(list1);
        HashSet set2 = new HashSet();
        set2.addAll(list2);
        return set1.equals(set2);
    }
}

