/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.manage;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.iotdb.db.engine.merge.task.MergeMultiChunkTask;
import org.apache.iotdb.db.engine.merge.task.MergeTask;

public abstract class MergeFuture
extends FutureTask<Void>
implements Comparable<MergeFuture> {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Date createdTime = new Date(System.currentTimeMillis());

    public MergeFuture(Callable callable) {
        super(callable);
    }

    public String getCreatedTime() {
        return this.dateFormat.format(this.createdTime);
    }

    public abstract String getTaskName();

    public abstract String getProgress();

    @Override
    public int compareTo(MergeFuture future) {
        return this.getTaskName().compareTo(future.getTaskName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeFuture future = (MergeFuture)o;
        return Objects.equals(this.getTaskName(), future.getTaskName());
    }

    public int hashCode() {
        return Objects.hash(this.createdTime);
    }

    public static class SubMergeFuture
    extends MergeFuture {
        private MergeMultiChunkTask.MergeChunkHeapTask bindingTask;

        public SubMergeFuture(MergeMultiChunkTask.MergeChunkHeapTask task) {
            super((Callable)task);
            this.bindingTask = task;
        }

        @Override
        public String getTaskName() {
            return this.bindingTask.getTaskName();
        }

        @Override
        public String getProgress() {
            return this.bindingTask.getProgress();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SubMergeFuture that = (SubMergeFuture)o;
            return Objects.equals(this.bindingTask, that.bindingTask);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.bindingTask);
        }
    }

    public static class MainMergeFuture
    extends MergeFuture {
        private MergeTask bindingTask;

        public MainMergeFuture(MergeTask task) {
            super((Callable)task);
            this.bindingTask = task;
        }

        @Override
        public String getTaskName() {
            return this.bindingTask.getTaskName();
        }

        @Override
        public String getProgress() {
            return this.bindingTask.getProgress();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MainMergeFuture that = (MainMergeFuture)o;
            return Objects.equals(this.bindingTask, that.bindingTask);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.bindingTask);
        }
    }
}

