/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.File;
import java.io.IOException;

public class CompactionFileInfo {
    String logicalStorageGroup;
    String virtualStorageGroupId;
    long timePartition;
    String filename;
    boolean sequence;

    private CompactionFileInfo(String logicalStorageGroup, String virtualStorageGroupId, long timePartition, String filename, boolean sequence) {
        this.logicalStorageGroup = logicalStorageGroup;
        this.virtualStorageGroupId = virtualStorageGroupId;
        this.timePartition = timePartition;
        this.filename = filename;
        this.sequence = sequence;
    }

    public static CompactionFileInfo parseCompactionFileInfo(String infoString) throws IOException {
        String[] info = infoString.split(" ");
        try {
            return new CompactionFileInfo(info[0], info[1], Long.parseLong(info[2]), info[3], info[4].equals("sequence"));
        }
        catch (Exception e) {
            throw new IOException("invalid compaction log line: " + infoString);
        }
    }

    public static CompactionFileInfo parseCompactionFileInfoFromPath(String filePath) throws IOException {
        String[] splitFilePath;
        int pathLength;
        String separator = File.separator;
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        if ((pathLength = (splitFilePath = filePath.split(separator)).length) < 4) {
            throw new IOException("invalid compaction file path: " + filePath);
        }
        try {
            return new CompactionFileInfo(splitFilePath[pathLength - 4], splitFilePath[pathLength - 3], Long.parseLong(splitFilePath[pathLength - 2]), splitFilePath[pathLength - 1], splitFilePath[pathLength - 5].equals("sequence"));
        }
        catch (Exception e) {
            throw new IOException("invalid compaction log line: " + filePath);
        }
    }

    public File getFile(String dataDir) {
        return new File(dataDir + File.separator + (this.sequence ? "sequence" : "unsequence") + File.separator + this.logicalStorageGroup + File.separator + this.virtualStorageGroupId + File.separator + this.timePartition + File.separator + this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return String.format("%s %s %d %s %s", this.logicalStorageGroup, this.virtualStorageGroupId, this.timePartition, this.filename, this.sequence ? "sequence" : "unsequence");
    }
}

