/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.concurrent.IoTThreadFactory;
import org.apache.iotdb.db.concurrent.threadpool.WrappedScheduledExecutorService;
import org.apache.iotdb.db.concurrent.threadpool.WrappedSingleThreadExecutorService;
import org.apache.iotdb.db.concurrent.threadpool.WrappedSingleThreadScheduledExecutor;
import org.apache.iotdb.db.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.thrift.server.TThreadPoolServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThreadPoolFactory {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBThreadPoolFactory.class);

    private IoTDBThreadPoolFactory() {
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName) {
        logger.info("new fixed thread pool: {}, thread number: {}", (Object)poolName, (Object)nThreads);
        return new WrappedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new fixed thread pool: {}, thread number: {}", (Object)poolName, (Object)nThreads);
        return new WrappedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new IoTThreadFactory(poolName, handler), poolName);
    }

    public static ExecutorService newSingleThreadExecutor(String poolName) {
        logger.info("new single thread pool: {}", (Object)poolName);
        return new WrappedSingleThreadExecutorService(Executors.newSingleThreadExecutor(new IoTThreadFactory(poolName)), poolName);
    }

    public static ExecutorService newSingleThreadExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new single thread pool: {}", (Object)poolName);
        return new WrappedSingleThreadExecutorService(Executors.newSingleThreadExecutor(new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ExecutorService newCachedThreadPool(String poolName) {
        logger.info("new cached thread pool: {}", (Object)poolName);
        return new WrappedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService newCachedThreadPool(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info("new cached thread pool: {}", (Object)poolName);
        return new WrappedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new IoTThreadFactory(poolName, handler), poolName);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        return new WrappedSingleThreadScheduledExecutor(Executors.newSingleThreadScheduledExecutor(new IoTThreadFactory(poolName)), poolName);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        return new WrappedSingleThreadScheduledExecutor(Executors.newSingleThreadScheduledExecutor(new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName) {
        return new WrappedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName)), poolName);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName, Thread.UncaughtExceptionHandler handler) {
        return new WrappedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new WrappedThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName, Thread.UncaughtExceptionHandler handler) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new WrappedThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName, handler), poolName);
    }
}

