/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkMetadata {
    private String measurementUid;
    private long offsetOfChunkHeader;
    private TSDataType tsDataType;
    private long version;
    private List<TimeRange> deleteIntervalList;
    private boolean modified;
    private IChunkLoader chunkLoader;
    private Statistics statistics;
    private boolean isFromOldTsFile = false;
    private static final int CHUNK_METADATA_FIXED_RAM_SIZE = 84;
    private boolean isSeq = true;
    private boolean isClosed;
    private String filePath;
    private String tsFilePrefixPath;

    private ChunkMetadata() {
    }

    public ChunkMetadata(String measurementUid, TSDataType tsDataType, long fileOffset, Statistics statistics) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.offsetOfChunkHeader = fileOffset;
        this.statistics = statistics;
    }

    public String toString() {
        return String.format("measurementId: %s, datatype: %s, version: %d, Statistics: %s, deleteIntervalList: %s, filePath: %s", new Object[]{this.measurementUid, this.tsDataType, this.version, this.statistics, this.deleteIntervalList, this.filePath});
    }

    public long getNumOfPoints() {
        return this.statistics.getCount();
    }

    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    public TSDataType getDataType() {
        return this.tsDataType;
    }

    public int serializeTo(OutputStream outputStream, boolean serializeStatistic) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, outputStream);
        if (serializeStatistic) {
            byteLen += this.statistics.serialize(outputStream);
        }
        return byteLen;
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer, TimeseriesMetadata timeseriesMetadata) {
        ChunkMetadata chunkMetaData = new ChunkMetadata();
        chunkMetaData.measurementUid = timeseriesMetadata.getMeasurementId();
        chunkMetaData.tsDataType = timeseriesMetadata.getTSDataType();
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.statistics = timeseriesMetadata.getTimeSeriesMetadataType() != 0 ? Statistics.deserialize(buffer, chunkMetaData.tsDataType) : timeseriesMetadata.getStatistics();
        return chunkMetaData;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public void insertIntoSortedDeletions(long startTime, long endTime) {
        ArrayList<TimeRange> resultInterval = new ArrayList<TimeRange>();
        if (this.deleteIntervalList != null) {
            for (TimeRange interval : this.deleteIntervalList) {
                if (interval.getMax() < startTime) {
                    resultInterval.add(interval);
                    continue;
                }
                if (interval.getMin() > endTime) {
                    resultInterval.add(new TimeRange(startTime, endTime));
                    startTime = interval.getMin();
                    endTime = interval.getMax();
                    continue;
                }
                if (interval.getMax() < startTime && interval.getMin() > endTime) continue;
                startTime = Math.min(interval.getMin(), startTime);
                endTime = Math.max(interval.getMax(), endTime);
            }
        }
        resultInterval.add(new TimeRange(startTime, endTime));
        this.deleteIntervalList = resultInterval;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkMetadata that = (ChunkMetadata)o;
        return this.offsetOfChunkHeader == that.offsetOfChunkHeader && this.version == that.version && this.tsFilePrefixPath.equals(that.tsFilePrefixPath);
    }

    public int hashCode() {
        return Objects.hash(this.tsFilePrefixPath, this.version, this.offsetOfChunkHeader);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isFromOldTsFile() {
        return this.isFromOldTsFile;
    }

    public void setFromOldTsFile(boolean isFromOldTsFile) {
        this.isFromOldTsFile = isFromOldTsFile;
    }

    public long calculateRamSize() {
        return 84L + RamUsageEstimator.sizeOf(this.tsFilePrefixPath) + RamUsageEstimator.sizeOf(this.measurementUid) + this.statistics.calculateRamSize();
    }

    public static long calculateRamSize(String measurementId, TSDataType dataType) {
        return 84L + RamUsageEstimator.sizeOf(measurementId) + (long)Statistics.getSizeByType(dataType);
    }

    public void mergeChunkMetadata(ChunkMetadata chunkMetadata) {
        this.statistics.mergeStatistics(chunkMetadata.getStatistics());
    }

    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.tsFilePrefixPath = FilePathUtils.getTsFilePrefixPath(filePath);
    }
}

