/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.record;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Tablet {
    private static final int DEFAULT_SIZE = 1024;
    private static final String NOT_SUPPORT_DATATYPE = "Data type %s is not supported.";
    public String deviceId;
    private List<MeasurementSchema> schemas;
    private Map<String, Integer> measurementIndex;
    public long[] timestamps;
    public Object[] values;
    public int rowSize;
    private int maxRowNumber;

    public Tablet(String deviceId, List<MeasurementSchema> schemas) {
        this(deviceId, schemas, 1024);
    }

    public Tablet(String deviceId, List<MeasurementSchema> schemas, int maxRowNumber) {
        this.deviceId = deviceId;
        this.schemas = schemas;
        this.maxRowNumber = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        for (int i = 0; i < schemas.size(); ++i) {
            this.measurementIndex.put(schemas.get(i).getMeasurementId(), i);
        }
        this.createColumns();
        this.reset();
    }

    public void addTimestamp(int rowIndex, long timestamp) {
        this.timestamps[rowIndex] = timestamp;
    }

    public void addValue(String measurementId, int rowIndex, Object value) {
        int indexOfValue = this.measurementIndex.get(measurementId);
        MeasurementSchema measurementSchema = this.schemas.get(indexOfValue);
        switch (measurementSchema.getType()) {
            case TEXT: {
                Binary[] sensor = (Binary[])this.values[indexOfValue];
                sensor[rowIndex] = (Binary)value;
                break;
            }
            case FLOAT: {
                float[] sensor = (float[])this.values[indexOfValue];
                sensor[rowIndex] = ((Float)value).floatValue();
                break;
            }
            case INT32: {
                int[] sensor = (int[])this.values[indexOfValue];
                sensor[rowIndex] = (Integer)value;
                break;
            }
            case INT64: {
                long[] sensor = (long[])this.values[indexOfValue];
                sensor[rowIndex] = (Long)value;
                break;
            }
            case DOUBLE: {
                double[] sensor = (double[])this.values[indexOfValue];
                sensor[rowIndex] = (Double)value;
                break;
            }
            case BOOLEAN: {
                boolean[] sensor = (boolean[])this.values[indexOfValue];
                sensor[rowIndex] = (Boolean)value;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{measurementSchema.getType()}));
            }
        }
    }

    public List<MeasurementSchema> getSchemas() {
        return this.schemas;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void reset() {
        this.rowSize = 0;
    }

    private void createColumns() {
        this.timestamps = new long[this.maxRowNumber];
        this.values = new Object[this.schemas.size()];
        block8: for (int i = 0; i < this.schemas.size(); ++i) {
            TSDataType dataType = this.schemas.get(i).getType();
            switch (dataType) {
                case INT32: {
                    this.values[i] = new int[this.maxRowNumber];
                    continue block8;
                }
                case INT64: {
                    this.values[i] = new long[this.maxRowNumber];
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = new float[this.maxRowNumber];
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = new double[this.maxRowNumber];
                    continue block8;
                }
                case BOOLEAN: {
                    this.values[i] = new boolean[this.maxRowNumber];
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = new Binary[this.maxRowNumber];
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{dataType}));
                }
            }
        }
    }

    public int getTimeBytesSize() {
        return this.rowSize * 8;
    }

    public int getValueBytesSize() {
        int valueOccupation = 0;
        block8: for (int i = 0; i < this.schemas.size(); ++i) {
            switch (this.schemas.get(i).getType()) {
                case BOOLEAN: {
                    valueOccupation += this.rowSize;
                    continue block8;
                }
                case INT32: {
                    valueOccupation += this.rowSize * 4;
                    continue block8;
                }
                case INT64: {
                    valueOccupation += this.rowSize * 8;
                    continue block8;
                }
                case FLOAT: {
                    valueOccupation += this.rowSize * 4;
                    continue block8;
                }
                case DOUBLE: {
                    valueOccupation += this.rowSize * 8;
                    continue block8;
                }
                case TEXT: {
                    valueOccupation += this.rowSize * 4;
                    Binary[] binaries = (Binary[])this.values[i];
                    for (int rowIndex = 0; rowIndex < this.rowSize; ++rowIndex) {
                        valueOccupation += binaries[rowIndex].getLength();
                    }
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{this.schemas.get(i).getType()}));
                }
            }
        }
        return valueOccupation;
    }
}

