/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MeasurementMNode
extends MNode {
    private static final long serialVersionUID = -1199657856921206435L;
    private MeasurementSchema schema;
    private String alias;
    private long offset = -1L;
    private TimeValuePair cachedLastValuePair = null;

    public MeasurementMNode(MNode parent, String measurementName, String alias, TSDataType dataType, TSEncoding encoding, CompressionType type, Map<String, String> props) {
        super(parent, measurementName);
        this.schema = new MeasurementSchema(measurementName, dataType, encoding, type, props);
        this.alias = alias;
    }

    public MeasurementMNode(MNode parent, String measurementName, MeasurementSchema schema, String alias) {
        super(parent, measurementName);
        this.schema = schema;
        this.alias = alias;
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }

    public TimeValuePair getCachedLast() {
        return this.cachedLastValuePair;
    }

    public synchronized void updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (timeValuePair == null || timeValuePair.getValue() == null) {
            return;
        }
        if (this.cachedLastValuePair == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.cachedLastValuePair = new TimeValuePair(timeValuePair.getTimestamp(), timeValuePair.getValue());
            }
        } else if (timeValuePair.getTimestamp() > this.cachedLastValuePair.getTimestamp() || timeValuePair.getTimestamp() == this.cachedLastValuePair.getTimestamp() && highPriorityUpdate) {
            this.cachedLastValuePair.setTimestamp(timeValuePair.getTimestamp());
            this.cachedLastValuePair.setValue(timeValuePair.getValue());
        }
    }

    @Override
    public String getFullPath() {
        return this.concatFullPath();
    }

    public void resetCache() {
        this.cachedLastValuePair = null;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSchema(MeasurementSchema schema) {
        this.schema = schema;
    }

    @Override
    public void serializeTo(MLogWriter logWriter) throws IOException {
        this.serializeChildren(logWriter);
        logWriter.serializeMeasurementMNode(this);
    }

    public static MeasurementMNode deserializeFrom(String[] nodeInfo) {
        String name = nodeInfo[1];
        String alias = nodeInfo[2].equals("") ? null : nodeInfo[2];
        HashMap<String, String> props = new HashMap<String, String>();
        if (!nodeInfo[6].equals("")) {
            for (String propInfo : nodeInfo[6].split(";")) {
                props.put(propInfo.split(":")[0], propInfo.split(":")[1]);
            }
        }
        MeasurementSchema schema = new MeasurementSchema(name, Byte.parseByte(nodeInfo[3]), Byte.parseByte(nodeInfo[4]), Byte.parseByte(nodeInfo[5]), props);
        MeasurementMNode node = new MeasurementMNode(null, name, schema, alias);
        node.setOffset(Long.parseLong(nodeInfo[7]));
        return node;
    }

    public static MeasurementMNode deserializeFrom(MeasurementMNodePlan plan) {
        MeasurementMNode node = new MeasurementMNode(null, plan.getName(), plan.getSchema(), plan.getAlias());
        node.setOffset(plan.getOffset());
        return node;
    }
}

