/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.rescon.CachedStringPool;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FileTimeIndex
implements ITimeIndex {
    protected static final Map<String, String> cachedDevicePool = CachedStringPool.getInstance().getCachedPool();
    protected long startTime;
    protected long endTime;
    protected Set<String> devices;

    public FileTimeIndex() {
        this.devices = new ConcurrentSet();
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
    }

    public FileTimeIndex(Set<String> devices, long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.devices = devices;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.devices.size(), (OutputStream)outputStream);
        ConcurrentSet stringMemoryReducedSet = new ConcurrentSet();
        for (String device : this.devices) {
            stringMemoryReducedSet.add(cachedDevicePool.computeIfAbsent(device, k -> k));
            ReadWriteIOUtils.write((String)device, (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)outputStream);
        this.devices = stringMemoryReducedSet;
    }

    @Override
    public FileTimeIndex deserialize(InputStream inputStream) throws IOException {
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        HashSet<String> deviceSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            String path = ReadWriteIOUtils.readString((InputStream)inputStream);
            String cachedPath = cachedDevicePool.computeIfAbsent(path, k -> k);
            deviceSet.add(cachedPath);
        }
        return new FileTimeIndex(deviceSet, ReadWriteIOUtils.readLong((InputStream)inputStream), ReadWriteIOUtils.readLong((InputStream)inputStream));
    }

    @Override
    public FileTimeIndex deserialize(ByteBuffer buffer) {
        int size = buffer.getInt();
        HashSet<String> deviceSet = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            String path = SerializeUtils.deserializeString(buffer);
            String cachedPath = cachedDevicePool.computeIfAbsent(path, k -> k);
            deviceSet.add(cachedPath);
        }
        return new FileTimeIndex(deviceSet, buffer.getLong(), buffer.getLong());
    }

    @Override
    public void close() {
    }

    @Override
    public Set<String> getDevices() {
        return this.devices;
    }

    @Override
    public boolean endTimeEmpty() {
        return this.endTime == Long.MIN_VALUE;
    }

    @Override
    public boolean stillLives(long timeLowerBound) {
        if (timeLowerBound == Long.MAX_VALUE) {
            return true;
        }
        return this.endTime >= timeLowerBound;
    }

    @Override
    public long calculateRamSize() {
        return RamUsageEstimator.sizeOf(this.devices) + RamUsageEstimator.sizeOf((Object)this.startTime) + RamUsageEstimator.sizeOf((Object)this.endTime);
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        try {
            if (this.devices != null && !this.devices.isEmpty()) {
                return StorageEngine.getTimePartition(this.startTime);
            }
            String[] filePathSplits = FilePathUtils.splitTsFilePath((String)tsFilePath);
            return Long.parseLong(filePathSplits[filePathSplits.length - 2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private long getTimePartitionWithCheck() {
        long endPartitionId;
        long startPartitionId = StorageEngine.getTimePartition(this.startTime);
        if (startPartitionId == (endPartitionId = StorageEngine.getTimePartition(this.endTime))) {
            return startPartitionId;
        }
        return -1L;
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        long partitionId = this.getTimePartitionWithCheck();
        if (partitionId == -1L) {
            throw new PartitionViolationException(tsFilePath);
        }
        return partitionId;
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        long partitionId = this.getTimePartitionWithCheck();
        return partitionId == -1L;
    }

    @Override
    public void updateStartTime(String deviceId, long time) {
        this.devices.add(deviceId);
        if (this.startTime > time) {
            this.startTime = time;
        }
    }

    @Override
    public void updateEndTime(String deviceId, long time) {
        this.devices.add(deviceId);
        if (this.endTime < time) {
            this.endTime = time;
        }
    }

    @Override
    public void putStartTime(String deviceId, long time) {
        this.devices.add(deviceId);
        this.startTime = time;
    }

    @Override
    public void putEndTime(String deviceId, long time) {
        this.devices.add(deviceId);
        this.endTime = time;
    }

    @Override
    public long getStartTime(String deviceId) {
        return this.startTime;
    }

    @Override
    public long getEndTime(String deviceId) {
        return this.endTime;
    }
}

