/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.merge.recover.MergeLogAnalyzer;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverMergeTask
extends MergeTask {
    private static final Logger logger = LoggerFactory.getLogger(RecoverMergeTask.class);
    private MergeLogAnalyzer analyzer;
    private TsFileManagement tsFileManagement;

    public RecoverMergeTask(TsFileManagement tsfileManagement, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName) {
        super(tsfileManagement.getTsFileList(true), tsfileManagement.getTsFileList(false), storageGroupSysDir, callback, taskName, fullMerge, storageGroupName);
        this.tsFileManagement = tsfileManagement;
    }

    public void recoverMerge() throws IOException, MetadataException {
        File logFile = new File(this.storageGroupSysDir, "merge.log");
        if (!logFile.exists()) {
            logger.info("{} no merge.log, merge recovery ends", (Object)this.taskName);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.analyzer = new MergeLogAnalyzer(this.resource, this.taskName, logFile, this.storageGroupName);
        MergeLogAnalyzer.Status status = this.analyzer.analyze();
        switch (status) {
            case NONE: {
                logFile.delete();
                break;
            }
            case All_SOURCE_FILES_EXIST: {
                this.handleWhenAllSourceFilesExist();
                break;
            }
            case SOME_SOURCE_FILES_LOST: {
                this.handleWhenSomeSourceFilesLost();
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.taskName + " found unrecognized status " + (Object)((Object)status));
            }
        }
        if (logFile.exists()) {
            logFile.delete();
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} merge recovery ends after {}ms", (Object)this.taskName, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void handleWhenAllSourceFilesExist() throws IOException {
        this.cleanUp(false);
        this.tsFileManagement.removeMergingModification();
    }

    private void handleWhenSomeSourceFilesLost() throws IOException {
        ArrayList<TsFileResource> targetResouces = new ArrayList<TsFileResource>();
        for (TsFileResource sourceSeqResource : this.resource.getSeqFiles()) {
            File targetFile = TsFileResource.modifyTsFileNameUnseqMergCnt(sourceSeqResource.getTsFile());
            TsFileResource targetTsFileResouce = new TsFileResource(targetFile);
            if (!targetFile.exists()) {
                File tmpTargetFile = new File(sourceSeqResource.getTsFilePath() + ".merge");
                FSFactoryProducer.getFSFactory().moveFile(tmpTargetFile, targetFile);
                try (TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getAbsolutePath());){
                    FileLoaderUtils.updateTsFileResource(reader, targetTsFileResouce);
                }
                targetTsFileResouce.serialize();
                targetResouces.add(targetTsFileResouce);
            }
            this.tsFileManagement.updateMergeModification(targetTsFileResouce);
            sourceSeqResource.remove();
            File mergeFile = new File(sourceSeqResource.getTsFilePath() + ".merge");
            if (!mergeFile.exists()) continue;
            mergeFile.delete();
        }
        this.tsFileManagement.replace(this.resource.getSeqFiles(), this.resource.getUnseqFiles(), targetResouces, true);
        for (TsFileResource unseqResource : this.resource.getUnseqFiles()) {
            unseqResource.remove();
        }
        this.tsFileManagement.removeMergingModification();
    }
}

