/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.groupby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteGroupByExecutor
implements GroupByExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RemoteGroupByExecutor.class);
    private long executorId;
    private MetaGroupMember metaGroupMember;
    private Node source;
    private Node header;
    private List<AggregateResult> results = new ArrayList<AggregateResult>();

    public RemoteGroupByExecutor(long executorId, MetaGroupMember metaGroupMember, Node source, Node header) {
        this.executorId = executorId;
        this.metaGroupMember = metaGroupMember;
        this.source = source;
        this.header = header;
    }

    public void addAggregateResult(AggregateResult aggrResult) {
        this.results.add(aggrResult);
    }

    private void resetAggregateResults() {
        for (AggregateResult result : this.results) {
            result.reset();
        }
    }

    public List<AggregateResult> calcResult(long curStartTime, long curEndTime) throws IOException {
        List aggrBuffers;
        block14: {
            try {
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(this.source, RaftServer.getReadOperationTimeoutMS());
                    aggrBuffers = SyncClientAdaptor.getGroupByResult(client, this.header, this.executorId, curStartTime, curEndTime);
                    break block14;
                }
                try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(this.source, RaftServer.getReadOperationTimeoutMS());){
                    try {
                        aggrBuffers = syncDataClient.getGroupByResult(this.header, this.executorId, curStartTime, curEndTime);
                    }
                    catch (TException e) {
                        syncDataClient.getInputProtocol().getTransport().close();
                        throw e;
                    }
                }
            }
            catch (TException e) {
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        this.resetAggregateResults();
        if (aggrBuffers != null) {
            for (int i = 0; i < aggrBuffers.size(); ++i) {
                AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)((ByteBuffer)aggrBuffers.get(i)));
                this.results.get(i).merge(result);
            }
        }
        logger.debug("Fetched group by result from {} of [{}, {}]: {}", new Object[]{this.source, curStartTime, curEndTime, this.results});
        return this.results;
    }

    public Pair<Long, Object> peekNextNotNullValue(long nextStartTime, long nextEndTime) throws IOException {
        ByteBuffer aggrBuffer;
        block14: {
            try {
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(this.source, RaftServer.getReadOperationTimeoutMS());
                    aggrBuffer = SyncClientAdaptor.peekNextNotNullValue(client, this.header, this.executorId, nextStartTime, nextEndTime);
                    break block14;
                }
                try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(this.source, RaftServer.getReadOperationTimeoutMS());){
                    try {
                        aggrBuffer = syncDataClient.peekNextNotNullValue(this.header, this.executorId, nextStartTime, nextEndTime);
                    }
                    catch (TException e) {
                        syncDataClient.getInputProtocol().getTransport().close();
                        throw e;
                    }
                }
            }
            catch (TException e) {
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        Pair result = null;
        if (aggrBuffer != null) {
            long time = aggrBuffer.getLong();
            Object o = SerializeUtils.deserializeObject((ByteBuffer)aggrBuffer);
            if (o != null) {
                result = new Pair((Object)time, o);
            }
        }
        logger.debug("Fetched peekNextNotNullValue from {} of [{}, {}]: {}", new Object[]{this.source, nextStartTime, nextEndTime, result});
        return result;
    }
}

