/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.dataset;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.service.IoTDB;

public class ClusterAlignByDeviceDataSet
extends AlignByDeviceDataSet {
    public ClusterAlignByDeviceDataSet(AlignByDevicePlan alignByDevicePlan, QueryContext context, IQueryRouter queryRouter) {
        super(alignByDevicePlan, context, queryRouter);
    }

    protected Set<String> getDeviceMeasurements(PartialPath device) throws IOException {
        try {
            List<PartialPath> matchedPaths = ((CMManager)IoTDB.metaManager).getMatchedPaths(device);
            HashSet<String> deviceMeasurements = new HashSet<String>();
            for (PartialPath matchedPath : matchedPaths) {
                deviceMeasurements.add(matchedPath.getFullPath().substring(matchedPath.getFullPath().lastIndexOf(46) + 1));
            }
            return deviceMeasurements;
        }
        catch (MetadataException e) {
            throw new IOException(e);
        }
    }
}

