/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.EmptyIntervalException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.query.reader.ClusterTimeGenerator;
import org.apache.iotdb.cluster.query.reader.mult.AbstractMultPointReader;
import org.apache.iotdb.cluster.query.reader.mult.AssignPathManagedMergeReader;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDataQueryExecutor
extends RawDataQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ClusterDataQueryExecutor.class);
    private MetaGroupMember metaGroupMember;
    private ClusterReaderFactory readerFactory;
    private QueryDataSet.EndPoint endPoint = null;
    private boolean hasLocalReader = false;

    ClusterDataQueryExecutor(RawDataQueryPlan plan, MetaGroupMember metaGroupMember) {
        super(plan);
        this.metaGroupMember = metaGroupMember;
        this.readerFactory = new ClusterReaderFactory(metaGroupMember);
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context) throws StorageEngineException {
        QueryDataSet dataSet = this.needRedirect(context, false);
        if (dataSet != null) {
            return dataSet;
        }
        try {
            List<ManagedSeriesReader> readersOfSelectedSeries = this.initMultSeriesReader(context);
            return new RawQueryDataSetWithoutValueFilter(context.getQueryId(), this.queryPlan, readersOfSelectedSeries);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageEngineException(e.getMessage());
        }
        catch (IOException | EmptyIntervalException | QueryProcessException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    private List<ManagedSeriesReader> initMultSeriesReader(QueryContext context) throws StorageEngineException, IOException, EmptyIntervalException, QueryProcessException {
        Filter timeFilter = null;
        if (this.queryPlan.getExpression() != null) {
            timeFilter = ((GlobalTimeExpression)this.queryPlan.getExpression()).getFilter();
        }
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        ArrayList readersOfSelectedSeries = Lists.newArrayList();
        List<AbstractMultPointReader> multPointReaders = this.readerFactory.getMultSeriesReader(this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeviceToMeasurements(), this.queryPlan.getDeduplicatedDataTypes(), timeFilter, null, context, this.queryPlan.isAscending());
        for (int i = 0; i < this.queryPlan.getDeduplicatedPaths().size(); ++i) {
            PartialPath partialPath = (PartialPath)this.queryPlan.getDeduplicatedPaths().get(i);
            TSDataType dataType = (TSDataType)this.queryPlan.getDeduplicatedDataTypes().get(i);
            AssignPathManagedMergeReader assignPathManagedMergeReader = new AssignPathManagedMergeReader(partialPath.getFullPath(), dataType, this.queryPlan.isAscending());
            for (AbstractMultPointReader multPointReader : multPointReaders) {
                if (!multPointReader.getAllPaths().contains(partialPath.getFullPath())) continue;
                assignPathManagedMergeReader.addReader(multPointReader, 0L);
            }
            readersOfSelectedSeries.add(assignPathManagedMergeReader);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized {} readers for {}", (Object)readersOfSelectedSeries.size(), (Object)this.queryPlan);
        }
        return readersOfSelectedSeries;
    }

    protected List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context) throws StorageEngineException {
        Filter timeFilter = null;
        if (this.queryPlan.getExpression() != null) {
            timeFilter = ((GlobalTimeExpression)this.queryPlan.getExpression()).getFilter();
        }
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        ArrayList<ManagedSeriesReader> readersOfSelectedSeries = new ArrayList<ManagedSeriesReader>();
        this.hasLocalReader = false;
        for (int i = 0; i < this.queryPlan.getDeduplicatedPaths().size(); ++i) {
            ManagedSeriesReader reader;
            PartialPath path = (PartialPath)this.queryPlan.getDeduplicatedPaths().get(i);
            TSDataType dataType = (TSDataType)this.queryPlan.getDeduplicatedDataTypes().get(i);
            try {
                reader = this.readerFactory.getSeriesReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, timeFilter, null, context, this.queryPlan.isAscending());
            }
            catch (EmptyIntervalException e) {
                logger.info(e.getMessage());
                return Collections.emptyList();
            }
            readersOfSelectedSeries.add(reader);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized {} readers for {}", (Object)readersOfSelectedSeries.size(), (Object)this.queryPlan);
        }
        return readersOfSelectedSeries;
    }

    protected IReaderByTimestamp getReaderByTimestamp(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return this.readerFactory.getReaderByTimestamp(path, deviceMeasurements, dataType, context, this.queryPlan.isAscending());
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan rawDataQueryPlan) throws StorageEngineException {
        return new ClusterTimeGenerator(context, this.metaGroupMember, rawDataQueryPlan, false);
    }

    protected QueryDataSet needRedirect(QueryContext context, boolean hasValueFilter) throws StorageEngineException {
        if (this.queryPlan.isEnableRedirect()) {
            if (hasValueFilter) {
                ClusterTimeGenerator clusterTimeGenerator = new ClusterTimeGenerator(context, this.metaGroupMember, this.queryPlan, true);
                if (clusterTimeGenerator.isHasLocalReader()) {
                    this.hasLocalReader = true;
                    this.endPoint = null;
                }
                this.checkReaderHasLocalData(context, true);
            } else {
                this.checkReaderHasLocalData(context, false);
            }
            logger.debug("redirect queryId {}, {}, {}, {}", new Object[]{context.getQueryId(), this.hasLocalReader, hasValueFilter, this.endPoint});
            if (!this.hasLocalReader) {
                RawQueryDataSetWithoutValueFilter dataSet = new RawQueryDataSetWithoutValueFilter(context.getQueryId());
                dataSet.setEndPoint(this.endPoint);
                return dataSet;
            }
        }
        return null;
    }

    private void checkReaderHasLocalData(QueryContext context, boolean hasValueFilter) throws StorageEngineException {
        Filter timeFilter = null;
        if (!hasValueFilter && this.queryPlan.getExpression() != null) {
            timeFilter = ((GlobalTimeExpression)this.queryPlan.getExpression()).getFilter();
        }
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        block4: for (int i = 0; i < this.queryPlan.getDeduplicatedPaths().size(); ++i) {
            PartialPath path = (PartialPath)this.queryPlan.getDeduplicatedPaths().get(i);
            TSDataType dataType = (TSDataType)this.queryPlan.getDeduplicatedDataTypes().get(i);
            try {
                List<PartitionGroup> partitionGroups = null;
                partitionGroups = hasValueFilter ? this.metaGroupMember.routeFilter(null, path) : this.metaGroupMember.routeFilter(timeFilter, path);
                for (PartitionGroup partitionGroup : partitionGroups) {
                    if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
                        DataGroupMember dataGroupMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), String.format("Query: %s, time filter: %s, queryId: %d", path, null, context.getQueryId()));
                        if (hasValueFilter) {
                            IReaderByTimestamp readerByTimestamp = this.readerFactory.getReaderByTimestamp(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, dataGroupMember, this.queryPlan.isAscending());
                            if (readerByTimestamp == null) continue;
                            this.hasLocalReader = true;
                            this.endPoint = null;
                            continue;
                        }
                        IPointReader pointReader = this.readerFactory.getSeriesPointReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, timeFilter, null, context, dataGroupMember, this.queryPlan.isAscending());
                        if (pointReader.hasNextTimeValuePair()) {
                            this.hasLocalReader = true;
                            this.endPoint = null;
                            pointReader.close();
                            continue block4;
                        }
                        pointReader.close();
                        continue;
                    }
                    if (this.endPoint != null) continue;
                    this.endPoint = new QueryDataSet.EndPoint(partitionGroup.getHeader().getClientIp(), partitionGroup.getHeader().getClientPort());
                }
                continue;
            }
            catch (Exception e) {
                throw new StorageEngineException((Throwable)e);
            }
        }
    }
}

