/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDFPlan;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;

public class UDTFPlan
extends RawDataQueryPlan
implements UDFPlan {
    protected final ZoneId zoneId;
    protected Map<String, UDTFExecutor> columnName2Executor = new HashMap<String, UDTFExecutor>();
    protected Map<Integer, UDTFExecutor> originalOutputColumnIndex2Executor = new HashMap<Integer, UDTFExecutor>();
    protected List<String> datasetOutputColumnIndex2UdfColumnName = new ArrayList<String>();
    protected List<String> datasetOutputColumnIndex2RawQueryColumnName = new ArrayList<String>();
    protected Map<String, Integer> pathNameToReaderIndex;

    public UDTFPlan(ZoneId zoneId) {
        this.zoneId = zoneId;
        this.setOperatorType(Operator.OperatorType.UDTF);
    }

    @Override
    public void constructUdfExecutors(List<UDFContext> udfContexts) {
        for (int i = 0; i < udfContexts.size(); ++i) {
            UDFContext context = udfContexts.get(i);
            if (context == null) continue;
            String columnName = context.getColumnName();
            if (!this.columnName2Executor.containsKey(columnName)) {
                UDTFExecutor executor = new UDTFExecutor(context, this.zoneId);
                this.columnName2Executor.put(columnName, executor);
            }
            this.originalOutputColumnIndex2Executor.put(i, this.columnName2Executor.get(columnName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeUdfExecutors(long queryId, float collectorMemoryBudgetInMB) throws QueryProcessException {
        Collection<UDTFExecutor> executors = this.columnName2Executor.values();
        collectorMemoryBudgetInMB /= (float)executors.size();
        UDFRegistrationService.getInstance().acquireRegistrationLock();
        UDFClassLoaderManager.getInstance().initializeUDFQuery(queryId);
        try {
            for (UDTFExecutor executor : executors) {
                executor.beforeStart(queryId, collectorMemoryBudgetInMB);
            }
        }
        finally {
            UDFRegistrationService.getInstance().releaseRegistrationLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeUDFExecutors(long queryId) {
        try {
            for (UDTFExecutor executor : this.columnName2Executor.values()) {
                executor.beforeDestroy();
            }
        }
        finally {
            UDFClassLoaderManager.getInstance().finalizeUDFQuery(queryId);
        }
    }

    public UDTFExecutor getExecutorByOriginalOutputColumnIndex(int originalOutputColumn) {
        return this.originalOutputColumnIndex2Executor.get(originalOutputColumn);
    }

    public UDTFExecutor getExecutorByDataSetOutputColumnIndex(int datasetOutputIndex) {
        return this.columnName2Executor.get(this.datasetOutputColumnIndex2UdfColumnName.get(datasetOutputIndex));
    }

    public String getRawQueryColumnNameByDatasetOutputColumnIndex(int datasetOutputIndex) {
        return this.datasetOutputColumnIndex2RawQueryColumnName.get(datasetOutputIndex);
    }

    public boolean isUdfColumn(int datasetOutputIndex) {
        return this.datasetOutputColumnIndex2UdfColumnName.get(datasetOutputIndex) != null;
    }

    public int getReaderIndex(String pathName) {
        return this.pathNameToReaderIndex.get(pathName);
    }

    public void addUdfOutputColumn(String udfDatasetOutputColumn) {
        this.datasetOutputColumnIndex2UdfColumnName.add(udfDatasetOutputColumn);
        this.datasetOutputColumnIndex2RawQueryColumnName.add(null);
    }

    public void addRawQueryOutputColumn(String rawQueryOutputColumn) {
        this.datasetOutputColumnIndex2UdfColumnName.add(null);
        this.datasetOutputColumnIndex2RawQueryColumnName.add(rawQueryOutputColumn);
    }

    public void setPathNameToReaderIndex(Map<String, Integer> pathNameToReaderIndex) {
        this.pathNameToReaderIndex = pathNameToReaderIndex;
    }

    @Override
    public String getColumnForDisplay(String columnForReader, int pathIndex) {
        if (this.paths.get(pathIndex) == null) {
            return this.getExecutorByOriginalOutputColumnIndex(pathIndex).getContext().getColumnName();
        }
        return columnForReader;
    }

    @Override
    public List<PartialPath> getAuthPaths() {
        HashSet<PartialPath> authPathsSet = new HashSet<PartialPath>();
        for (PartialPath rawQueryPath : this.getPaths()) {
            if (rawQueryPath == null) continue;
            authPathsSet.add(rawQueryPath);
        }
        for (UDTFExecutor executor : this.columnName2Executor.values()) {
            authPathsSet.addAll(executor.getContext().getPaths());
        }
        return new ArrayList<PartialPath>(authPathsSet);
    }
}

