/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.service.rpc.thrift.TSStatus;

public class InsertRowsOfOneDevicePlan
extends InsertPlan
implements BatchPlan {
    boolean[] isExecuted;
    private InsertRowPlan[] rowPlans;
    private int[] rowPlanIndexList;
    private Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();
    private List<PartialPath> paths;

    public InsertRowsOfOneDevicePlan() {
        super(Operator.OperatorType.BATCH_INSERT_ONE_DEVICE);
    }

    public InsertRowsOfOneDevicePlan(PartialPath deviceId, Long[] insertTimes, List<List<String>> measurements, ByteBuffer[] insertValues) throws QueryProcessException {
        this();
        this.deviceId = deviceId;
        this.rowPlans = new InsertRowPlan[insertTimes.length];
        this.rowPlanIndexList = new int[insertTimes.length];
        for (int i = 0; i < insertTimes.length; ++i) {
            this.rowPlans[i] = new InsertRowPlan(deviceId, (long)insertTimes[i], measurements.get(i).toArray(new String[0]), insertValues[i]);
            if (this.rowPlans[i].getMeasurements().length == 0) {
                throw new QueryProcessException("The measurements are null, deviceId:" + deviceId + ", time:" + insertTimes[i]);
            }
            if (this.rowPlans[i].getValues().length == 0) {
                throw new QueryProcessException("The size of values in InsertRowsOfOneDevicePlan is 0, deviceId:" + deviceId + ", time:" + insertTimes[i]);
            }
            this.rowPlanIndexList[i] = i;
        }
    }

    public InsertRowsOfOneDevicePlan(PartialPath deviceId, InsertRowPlan[] rowPlans, int[] rowPlanIndexList) {
        this();
        this.deviceId = deviceId;
        this.rowPlans = rowPlans;
        this.rowPlanIndexList = rowPlanIndexList;
    }

    @Override
    public void checkIntegrity() {
    }

    @Override
    public List<PartialPath> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        for (InsertRowPlan plan : this.rowPlans) {
            pathSet.addAll(plan.getPaths());
        }
        this.paths = new ArrayList<PartialPath>(pathSet);
        return this.paths;
    }

    @Override
    public long getMinTime() {
        long minTime = Long.MAX_VALUE;
        for (InsertRowPlan plan : this.rowPlans) {
            if (minTime <= plan.getTime()) continue;
            minTime = plan.getTime();
        }
        return minTime;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCH_INSERT_ONE_DEVICE.ordinal();
        stream.writeByte((byte)type);
        this.putString(stream, this.deviceId.getFullPath());
        stream.writeInt(this.rowPlans.length);
        for (InsertRowPlan plan : this.rowPlans) {
            stream.writeLong(plan.getTime());
            plan.serializeMeasurementsAndValues(stream);
        }
        int[] nArray = this.rowPlanIndexList;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            stream.writeInt(index);
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCH_INSERT_ONE_DEVICE.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.deviceId.getFullPath());
        buffer.putInt(this.rowPlans.length);
        for (InsertRowPlan plan : this.rowPlans) {
            buffer.putLong(plan.getTime());
            plan.serializeMeasurementsAndValues(buffer);
        }
        int[] nArray = this.rowPlanIndexList;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            buffer.putInt(index);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int i;
        this.deviceId = new PartialPath(this.readString(buffer));
        this.rowPlans = new InsertRowPlan[buffer.getInt()];
        for (i = 0; i < this.rowPlans.length; ++i) {
            this.rowPlans[i] = new InsertRowPlan();
            this.rowPlans[i].setDeviceId(this.deviceId);
            this.rowPlans[i].setTime(buffer.getLong());
            this.rowPlans[i].deserializeMeasurementsAndValues(buffer);
        }
        this.rowPlanIndexList = new int[this.rowPlans.length];
        for (i = 0; i < this.rowPlans.length; ++i) {
            this.rowPlanIndexList[i] = buffer.getInt();
        }
    }

    @Override
    public void setIndex(long index) {
        super.setIndex(index);
        for (InsertRowPlan plan : this.rowPlans) {
            plan.setIndex(index);
        }
    }

    public String toString() {
        return "deviceId: " + this.deviceId + ", times: " + this.rowPlans.length;
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        ArrayList<InsertRowPlan> plans = new ArrayList<InsertRowPlan>();
        for (InsertRowPlan plan : this.rowPlans) {
            if (!plan.hasFailedValues()) continue;
            plans.add((InsertRowPlan)plan.getPlanFromFailed());
        }
        this.rowPlans = plans.toArray(new InsertRowPlan[0]);
        return this;
    }

    public InsertRowPlan[] getRowPlans() {
        return this.rowPlans;
    }

    @Override
    public void setIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = true;
    }

    @Override
    public boolean isExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        return this.isExecuted[i];
    }

    @Override
    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    @Override
    public List<PartialPath> getPrefixPaths() {
        return Collections.singletonList(this.deviceId);
    }

    @Override
    public int getBatchSize() {
        return this.rowPlans.length;
    }

    public int[] getRowPlanIndexList() {
        return this.rowPlanIndexList;
    }

    @Override
    public void unsetIsExecuted(int i) {
        if (this.isExecuted == null) {
            this.isExecuted = new boolean[this.getBatchSize()];
        }
        this.isExecuted[i] = false;
        if (this.rowPlanIndexList != null && this.rowPlanIndexList.length > 0) {
            this.results.remove(this.rowPlanIndexList[i]);
        } else {
            this.results.remove(i);
        }
    }

    public boolean equals(Object o) {
        return o instanceof InsertRowsOfOneDevicePlan && Arrays.equals(((InsertRowsOfOneDevicePlan)o).rowPlanIndexList, this.rowPlanIndexList) && Arrays.equals(((InsertRowsOfOneDevicePlan)o).rowPlans, this.rowPlans) && ((InsertRowsOfOneDevicePlan)o).results.equals(this.results) && ((InsertRowsOfOneDevicePlan)o).getDeviceId().equals(this.getDeviceId());
    }

    public int hashCode() {
        int result = this.rowPlans != null ? Arrays.hashCode(this.rowPlans) : 0;
        result = 31 * result + (this.rowPlanIndexList != null ? Arrays.hashCode(this.rowPlanIndexList) : 0);
        result = 31 * result + (this.results != null ? this.results.hashCode() : 0);
        return result;
    }
}

