/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateTemplatePlan
extends PhysicalPlan {
    String name;
    List<String> schemaNames;
    List<List<String>> measurements;
    List<List<TSDataType>> dataTypes;
    List<List<TSEncoding>> encodings;
    List<CompressionType> compressors;

    public List<String> getSchemaNames() {
        return this.schemaNames;
    }

    public void setSchemaNames(List<String> schemaNames) {
        this.schemaNames = schemaNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<List<String>> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<List<String>> measurements) {
        this.measurements = measurements;
    }

    public List<List<TSDataType>> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<List<TSDataType>> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public List<List<TSEncoding>> getEncodings() {
        return this.encodings;
    }

    public void setEncodings(List<List<TSEncoding>> encodings) {
        this.encodings = encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    public CreateTemplatePlan() {
        super(false, Operator.OperatorType.CREATE_TEMPLATE);
    }

    public CreateTemplatePlan(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) {
        super(false, Operator.OperatorType.CREATE_TEMPLATE);
        this.name = name;
        this.schemaNames = schemaNames;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.schemaNames.size(), (ByteBuffer)buffer);
        for (String string : this.schemaNames) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)buffer);
        }
        ReadWriteIOUtils.write((int)this.measurements.size(), (ByteBuffer)buffer);
        for (List list : this.measurements) {
            ReadWriteIOUtils.write((int)list.size(), (ByteBuffer)buffer);
            for (String measurement : list) {
                ReadWriteIOUtils.write((String)measurement, (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.dataTypes.size(), (ByteBuffer)buffer);
        for (List list : this.dataTypes) {
            ReadWriteIOUtils.write((int)list.size(), (ByteBuffer)buffer);
            for (TSDataType dataType : list) {
                ReadWriteIOUtils.write((int)dataType.ordinal(), (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.encodings.size(), (ByteBuffer)buffer);
        for (List list : this.encodings) {
            ReadWriteIOUtils.write((int)list.size(), (ByteBuffer)buffer);
            for (TSEncoding encoding : list) {
                ReadWriteIOUtils.write((int)encoding.ordinal(), (ByteBuffer)buffer);
            }
        }
        ReadWriteIOUtils.write((int)this.compressors.size(), (ByteBuffer)buffer);
        for (CompressionType compressionType : this.compressors) {
            ReadWriteIOUtils.write((int)compressionType.ordinal(), (ByteBuffer)buffer);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int j;
        int listSize;
        int i;
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.schemaNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.schemaNames.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new ArrayList<List<String>>(size);
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<String> measurementsList = new ArrayList<String>(listSize);
            for (j = 0; j < listSize; ++j) {
                measurementsList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
            this.measurements.add(measurementsList);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.dataTypes = new ArrayList<List<TSDataType>>(size);
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<TSDataType> dataTypesList = new ArrayList<TSDataType>(listSize);
            for (j = 0; j < listSize; ++j) {
                dataTypesList.add(TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)]);
            }
            this.dataTypes.add(dataTypesList);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.encodings = new ArrayList<List<TSEncoding>>(size);
        for (i = 0; i < size; ++i) {
            listSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<TSEncoding> encodingsList = new ArrayList<TSEncoding>(listSize);
            for (j = 0; j < listSize; ++j) {
                encodingsList.add(TSEncoding.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)]);
            }
            this.encodings.add(encodingsList);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.compressors = new ArrayList<CompressionType>(size);
        for (i = 0; i < size; ++i) {
            this.compressors.add(CompressionType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)]);
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.schemaNames.size(), (OutputStream)stream);
        for (String string : this.schemaNames) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.measurements.size(), (OutputStream)stream);
        for (List list : this.measurements) {
            ReadWriteIOUtils.write((int)list.size(), (OutputStream)stream);
            for (String measurement : list) {
                ReadWriteIOUtils.write((String)measurement, (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.dataTypes.size(), (OutputStream)stream);
        for (List list : this.dataTypes) {
            ReadWriteIOUtils.write((int)list.size(), (OutputStream)stream);
            for (TSDataType dataType : list) {
                ReadWriteIOUtils.write((int)dataType.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.encodings.size(), (OutputStream)stream);
        for (List list : this.encodings) {
            ReadWriteIOUtils.write((int)list.size(), (OutputStream)stream);
            for (TSEncoding encoding : list) {
                ReadWriteIOUtils.write((int)encoding.ordinal(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.compressors.size(), (OutputStream)stream);
        for (CompressionType compressionType : this.compressors) {
            ReadWriteIOUtils.write((int)compressionType.ordinal(), (OutputStream)stream);
        }
        stream.writeLong(this.index);
    }

    @Override
    public List<PartialPath> getPaths() {
        return null;
    }
}

