/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexConstructor;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileIOWriter {
    protected static final byte[] MAGIC_STRING_BYTES;
    public static final byte VERSION_NUMBER_BYTE;
    protected static final TSFileConfig config;
    private static final Logger logger;
    private static final Logger resourceLogger;
    protected TsFileOutput out;
    protected boolean canWrite = true;
    protected File file;
    private ChunkMetadata currentChunkMetadata;
    protected List<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
    protected List<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
    private long markedPosition;
    private String currentChunkGroupDeviceId;
    Map<String, List<TimeseriesMetadata>> deviceTimeseriesMetadataMap;
    private long minPlanIndex;
    private long maxPlanIndex;

    protected TsFileIOWriter() {
    }

    public TsFileIOWriter(File file) throws IOException {
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), false);
        this.file = file;
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} writer is opened.", (Object)file.getName());
        }
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output) throws IOException {
        this.out = output;
        this.startFile();
    }

    public void writeBytesToStream(PublicBAOS bytes) throws IOException {
        bytes.writeTo(this.out.wrapAsStream());
    }

    protected void startFile() throws IOException {
        this.out.write(MAGIC_STRING_BYTES);
        this.out.write(VERSION_NUMBER_BYTE);
    }

    public void startChunkGroup(String deviceId) throws IOException {
        this.currentChunkGroupDeviceId = deviceId;
        if (logger.isDebugEnabled()) {
            logger.debug("start chunk group:{}, file position {}", (Object)deviceId, (Object)this.out.getPosition());
        }
        this.chunkMetadataList = new ArrayList<ChunkMetadata>();
        ChunkGroupHeader chunkGroupHeader = new ChunkGroupHeader(this.currentChunkGroupDeviceId);
        chunkGroupHeader.serializeTo(this.out.wrapAsStream());
    }

    public void endChunkGroup() throws IOException {
        if (this.currentChunkGroupDeviceId == null || this.chunkMetadataList.isEmpty()) {
            return;
        }
        this.chunkGroupMetadataList.add(new ChunkGroupMetadata(this.currentChunkGroupDeviceId, this.chunkMetadataList));
        this.currentChunkGroupDeviceId = null;
        this.chunkMetadataList = null;
        this.out.flush();
    }

    public boolean isWritingChunkGroup() {
        return this.currentChunkGroupDeviceId != null;
    }

    public void startFlushChunk(MeasurementSchema measurementSchema, CompressionType compressionCodecName, TSDataType tsDataType, TSEncoding encodingType, Statistics<?> statistics, int dataSize, int numOfPages) throws IOException {
        this.currentChunkMetadata = new ChunkMetadata(measurementSchema.getMeasurementId(), tsDataType, this.out.getPosition(), statistics);
        ChunkHeader header = new ChunkHeader(measurementSchema.getMeasurementId(), dataSize, tsDataType, compressionCodecName, encodingType, numOfPages);
        header.serializeTo(this.out.wrapAsStream());
    }

    public void writeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetadata = new ChunkMetadata(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunkMetadata.getStatistics());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endCurrentChunk();
        if (logger.isDebugEnabled()) {
            logger.debug("end flushing a chunk:{}, totalvalue:{}", (Object)chunkHeader.getMeasurementID(), (Object)chunkMetadata.getNumOfPoints());
        }
    }

    public void endCurrentChunk() {
        this.chunkMetadataList.add(this.currentChunkMetadata);
        this.currentChunkMetadata = null;
    }

    public void endFile() throws IOException {
        long metaOffset = this.out.getPosition();
        ReadWriteIOUtils.write((byte)2, this.out.wrapAsStream());
        TreeMap<Path, List<ChunkMetadata>> chunkMetadataListMap = new TreeMap<Path, List<ChunkMetadata>>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                Path series = new Path(chunkGroupMetadata.getDevice(), chunkMetadata.getMeasurementUid());
                chunkMetadataListMap.computeIfAbsent(series, k -> new ArrayList()).add(chunkMetadata);
            }
        }
        MetadataIndexNode metadataIndex = this.flushMetadataIndex(chunkMetadataListMap);
        TsFileMetadata tsFileMetaData = new TsFileMetadata();
        tsFileMetaData.setMetadataIndex(metadataIndex);
        tsFileMetaData.setMetaOffset(metaOffset);
        long footerIndex = this.out.getPosition();
        if (logger.isDebugEnabled()) {
            logger.debug("start to flush the footer,file pos:{}", (Object)footerIndex);
        }
        int size = tsFileMetaData.serializeTo(this.out.wrapAsStream());
        if (logger.isDebugEnabled()) {
            logger.debug("finish flushing the footer {}, file pos:{}", (Object)tsFileMetaData, (Object)this.out.getPosition());
        }
        size += tsFileMetaData.serializeBloomFilter(this.out.wrapAsStream(), chunkMetadataListMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("finish flushing the bloom filter file pos:{}", (Object)this.out.getPosition());
        }
        ReadWriteIOUtils.write(size, this.out.wrapAsStream());
        this.out.write(MAGIC_STRING_BYTES);
        this.out.close();
        if (resourceLogger.isDebugEnabled() && this.file != null) {
            resourceLogger.debug("{} writer is closed.", (Object)this.file.getName());
        }
        this.canWrite = false;
    }

    private MetadataIndexNode flushMetadataIndex(Map<Path, List<ChunkMetadata>> chunkMetadataListMap) throws IOException {
        this.deviceTimeseriesMetadataMap = new LinkedHashMap<String, List<TimeseriesMetadata>>();
        for (Map.Entry<Path, List<ChunkMetadata>> entry : chunkMetadataListMap.entrySet()) {
            Path path = entry.getKey();
            String device = path.getDevice();
            PublicBAOS publicBAOS = new PublicBAOS();
            TSDataType dataType = entry.getValue().get(entry.getValue().size() - 1).getDataType();
            Statistics seriesStatistics = Statistics.getStatsByType(dataType);
            int chunkMetadataListLength = 0;
            boolean serializeStatistic = entry.getValue().size() > 1;
            for (ChunkMetadata chunkMetadata : entry.getValue()) {
                if (!chunkMetadata.getDataType().equals((Object)dataType)) continue;
                chunkMetadataListLength += chunkMetadata.serializeTo(publicBAOS, serializeStatistic);
                seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
            }
            TimeseriesMetadata timeseriesMetadata = new TimeseriesMetadata(serializeStatistic ? (byte)1 : 0, chunkMetadataListLength, path.getMeasurement(), dataType, seriesStatistics, publicBAOS);
            this.deviceTimeseriesMetadataMap.computeIfAbsent(device, k -> new ArrayList()).add(timeseriesMetadata);
        }
        return MetadataIndexConstructor.constructMetadataIndex(this.deviceTimeseriesMetadataMap, this.out);
    }

    public long getPos() throws IOException {
        return this.out.getPosition();
    }

    public Map<String, List<ChunkMetadata>> getDeviceChunkMetadataMap() {
        HashMap<String, List<ChunkMetadata>> deviceChunkMetadataMap = new HashMap<String, List<ChunkMetadata>>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            deviceChunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), k -> new ArrayList()).addAll(chunkGroupMetadata.getChunkMetadataList());
        }
        return deviceChunkMetadataMap;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void mark() throws IOException {
        this.markedPosition = this.getPos();
    }

    public void reset() throws IOException {
        this.out.truncate(this.markedPosition);
    }

    public void close() throws IOException {
        this.canWrite = false;
        this.out.close();
    }

    public void writeSeparatorMaskForTest() throws IOException {
        this.out.write(new byte[]{2});
    }

    public void writeChunkGroupMarkerForTest() throws IOException {
        this.out.write(new byte[]{0});
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void filterChunks(Map<Path, List<Long>> chunkStartTimes) {
        HashMap<Path, Integer> startTimeIdxes = new HashMap<Path, Integer>();
        chunkStartTimes.forEach((p, t) -> startTimeIdxes.put((Path)p, 0));
        Iterator<ChunkGroupMetadata> chunkGroupMetaDataIterator = this.chunkGroupMetadataList.iterator();
        while (chunkGroupMetaDataIterator.hasNext()) {
            ChunkGroupMetadata chunkGroupMetaData = chunkGroupMetaDataIterator.next();
            String deviceId = chunkGroupMetaData.getDevice();
            int chunkNum = chunkGroupMetaData.getChunkMetadataList().size();
            Iterator<ChunkMetadata> chunkMetaDataIterator = chunkGroupMetaData.getChunkMetadataList().iterator();
            while (chunkMetaDataIterator.hasNext()) {
                List<Long> pathChunkStartTimes;
                boolean chunkValid;
                ChunkMetadata chunkMetaData = chunkMetaDataIterator.next();
                Path path = new Path(deviceId, chunkMetaData.getMeasurementUid());
                int startTimeIdx = (Integer)startTimeIdxes.get(path);
                boolean bl = chunkValid = startTimeIdx < (pathChunkStartTimes = chunkStartTimes.get(path)).size() && pathChunkStartTimes.get(startTimeIdx).longValue() == chunkMetaData.getStartTime();
                if (!chunkValid) {
                    chunkMetaDataIterator.remove();
                    --chunkNum;
                    continue;
                }
                startTimeIdxes.put(path, startTimeIdx + 1);
            }
            if (chunkNum != 0) continue;
            chunkGroupMetaDataIterator.remove();
        }
    }

    public void writePlanIndices() throws IOException {
        ReadWriteIOUtils.write((byte)4, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.minPlanIndex, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.maxPlanIndex, this.out.wrapAsStream());
        this.out.flush();
    }

    public TsFileOutput getIOWriterOut() {
        return this.out;
    }

    public Map<String, List<TimeseriesMetadata>> getDeviceTimeseriesMetadataMap() {
        return this.deviceTimeseriesMetadataMap;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    static {
        config = TSFileDescriptor.getInstance().getConfig();
        logger = LoggerFactory.getLogger(TsFileIOWriter.class);
        resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
        MAGIC_STRING_BYTES = BytesUtils.stringToBytes("TsFile");
        VERSION_NUMBER_BYTE = (byte)3;
    }
}

