/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Schema
implements Serializable {
    private Map<Path, MeasurementSchema> registeredTimeseries;
    private Map<String, Map<String, MeasurementSchema>> deviceTemplates;

    public Schema() {
        this.registeredTimeseries = new LinkedHashMap<Path, MeasurementSchema>();
    }

    public Schema(Map<Path, MeasurementSchema> knownSchema) {
        this.registeredTimeseries = knownSchema;
    }

    public void registerTimeseries(Path path, MeasurementSchema descriptor) {
        this.registeredTimeseries.put(path, descriptor);
    }

    public void registerDeviceTemplate(String templateName, Map<String, MeasurementSchema> template) {
        if (this.deviceTemplates == null) {
            this.deviceTemplates = new HashMap<String, Map<String, MeasurementSchema>>();
        }
        this.deviceTemplates.put(templateName, template);
    }

    public void extendTemplate(String templateName, MeasurementSchema descriptor) {
        if (this.deviceTemplates == null) {
            this.deviceTemplates = new HashMap<String, Map<String, MeasurementSchema>>();
        }
        Map template = this.deviceTemplates.getOrDefault(templateName, new HashMap());
        template.put(descriptor.getMeasurementId(), descriptor);
        this.deviceTemplates.put(templateName, template);
    }

    public void registerDevice(String deviceId, String templateName) {
        if (!this.deviceTemplates.containsKey(templateName)) {
            return;
        }
        Map<String, MeasurementSchema> template = this.deviceTemplates.get(templateName);
        for (Map.Entry<String, MeasurementSchema> entry : template.entrySet()) {
            Path path = new Path(deviceId, entry.getKey());
            this.registerTimeseries(path, entry.getValue());
        }
    }

    public MeasurementSchema getSeriesSchema(Path path) {
        return this.registeredTimeseries.get(path);
    }

    public TSDataType getTimeseriesDataType(Path path) {
        if (!this.registeredTimeseries.containsKey(path)) {
            return null;
        }
        return this.registeredTimeseries.get(path).getType();
    }

    public Map<String, Map<String, MeasurementSchema>> getDeviceTemplates() {
        return this.deviceTemplates;
    }

    public boolean containsTimeseries(Path path) {
        return this.registeredTimeseries.containsKey(path);
    }

    public Map<Path, MeasurementSchema> getRegisteredTimeseriesMap() {
        return this.registeredTimeseries;
    }
}

