/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class InsertTabletPlan
extends InsertPlan {
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    private long[] times;
    private ByteBuffer timeBuffer;
    private Object[] columns;
    private ByteBuffer valueBuffer;
    private int rowCount = 0;
    boolean isExecuting = false;
    private List<PartialPath> paths;
    private int start;
    private int end;
    private List<Integer> range;
    private List<Object> failedColumns;

    public InsertTabletPlan() {
        super(Operator.OperatorType.BATCHINSERT);
    }

    public InsertTabletPlan(PartialPath deviceId, List<String> measurements) {
        super(Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.measurements = measurements.toArray(new String[0]);
        this.canBeSplit = true;
    }

    public InsertTabletPlan(PartialPath deviceId, String[] measurements) {
        super(Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.canBeSplit = true;
    }

    public InsertTabletPlan(PartialPath deviceId, String[] measurements, List<Integer> dataTypes) {
        super(Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.setDataTypes(dataTypes);
        this.canBeSplit = true;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.isExecuting = true;
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.isExecuting = true;
        this.end = end;
    }

    public List<Integer> getRange() {
        return this.range;
    }

    public void setRange(List<Integer> range) {
        this.range = range;
    }

    @Override
    public List<PartialPath> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.deviceId.concatNode(m);
            ret.add(fullPath);
        }
        this.paths = ret;
        return ret;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        stream.writeByte((byte)type);
        this.subSerialize(stream);
    }

    public void subSerialize(DataOutputStream stream) throws IOException {
        this.putString(stream, this.deviceId.getFullPath());
        this.writeMeasurements(stream);
        this.writeDataTypes(stream);
        this.writeTimes(stream);
        this.writeValues(stream);
    }

    private void writeMeasurements(DataOutputStream stream) throws IOException {
        stream.writeInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(stream, m);
        }
    }

    private void writeDataTypes(DataOutputStream stream) throws IOException {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.measurements[i] == null) continue;
            TSDataType dataType = this.dataTypes[i];
            stream.write(dataType.serialize());
        }
    }

    private void writeTimes(DataOutputStream stream) throws IOException {
        if (this.isExecuting) {
            stream.writeInt(this.end - this.start);
        } else {
            stream.writeInt(this.rowCount);
        }
        if (this.timeBuffer == null) {
            if (this.isExecuting) {
                for (int i = this.start; i < this.end; ++i) {
                    stream.writeLong(this.times[i]);
                }
            } else {
                for (long time : this.times) {
                    stream.writeLong(time);
                }
            }
        } else {
            stream.write(this.timeBuffer.array());
            this.timeBuffer = null;
        }
    }

    private void writeValues(DataOutputStream stream) throws IOException {
        if (this.valueBuffer == null) {
            this.serializeValues(stream);
        } else {
            stream.write(this.valueBuffer.array());
            this.valueBuffer = null;
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        buffer.put((byte)type);
        this.subSerialize(buffer);
    }

    public void subSerialize(ByteBuffer buffer) {
        this.putString(buffer, this.deviceId.getFullPath());
        this.writeMeasurements(buffer);
        this.writeDataTypes(buffer);
        this.writeTimes(buffer);
        this.writeValues(buffer);
    }

    private void writeMeasurements(ByteBuffer buffer) {
        buffer.putInt(this.measurements.length - (this.failedMeasurements == null ? 0 : this.failedMeasurements.size()));
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(buffer, m);
        }
    }

    private void writeDataTypes(ByteBuffer buffer) {
        int dataTypesLength = this.dataTypes.length;
        for (int i = 0; i < dataTypesLength; ++i) {
            TSDataType dataType = this.dataTypes[i];
            if (this.measurements[i] == null) continue;
            dataType.serializeTo(buffer);
        }
    }

    private void writeTimes(ByteBuffer buffer) {
        if (this.isExecuting) {
            buffer.putInt(this.end - this.start);
        } else {
            buffer.putInt(this.rowCount);
        }
        if (this.timeBuffer == null) {
            if (this.isExecuting) {
                for (int i = this.start; i < this.end; ++i) {
                    buffer.putLong(this.times[i]);
                }
            } else {
                for (long time : this.times) {
                    buffer.putLong(time);
                }
            }
        } else {
            buffer.put(this.timeBuffer.array());
            this.timeBuffer = null;
        }
    }

    private void writeValues(ByteBuffer buffer) {
        if (this.valueBuffer == null) {
            this.serializeValues(buffer);
        } else {
            buffer.put(this.valueBuffer.array());
            this.valueBuffer = null;
        }
        buffer.putLong(this.index);
    }

    private void serializeValues(DataOutputStream outputStream) throws IOException {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], outputStream, this.start, this.end);
        }
    }

    private void serializeValues(ByteBuffer buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, this.start, this.end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, ByteBuffer buffer, int start, int end) {
        int curStart = this.isExecuting ? start : 0;
        int curEnd = this.isExecuting ? end : this.rowCount;
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.put(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    buffer.putInt(binaryValues[j].getLength());
                    buffer.put(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream outputStream, int start, int end) throws IOException {
        int curStart = this.isExecuting ? start : 0;
        int curEnd = this.isExecuting ? end : this.rowCount;
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeByte(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = curStart; j < curEnd; ++j) {
                    outputStream.writeInt(binaryValues[j].getLength());
                    outputStream.write(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    public void setTimeBuffer(ByteBuffer timeBuffer) {
        this.timeBuffer = timeBuffer;
        this.timeBuffer.position(0);
    }

    public void setValueBuffer(ByteBuffer valueBuffer) {
        this.valueBuffer = valueBuffer;
        this.timeBuffer.position(0);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int rows;
        int i;
        this.deviceId = new PartialPath(this.readString(buffer));
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        this.dataTypes = new TSDataType[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((byte)buffer.get());
        }
        this.rowCount = rows = buffer.getInt();
        this.times = new long[rows];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, rows);
        this.columns = QueryDataSetUtils.readValuesFromBuffer(buffer, this.dataTypes, measurementSize, rows);
        this.index = buffer.getLong();
    }

    public void setDataTypes(List<Integer> dataTypes) {
        this.dataTypes = new TSDataType[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = TSDataType.values()[dataTypes.get(i)];
        }
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public void setColumn(int index, Object column) {
        this.columns[index] = column;
    }

    @Override
    public long getMinTime() {
        return this.times.length != 0 ? this.times[0] : Long.MIN_VALUE;
    }

    public long getMaxTime() {
        return this.times.length != 0 ? this.times[this.times.length - 1] : Long.MAX_VALUE;
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex) {
        TsPrimitiveType.TsInt value;
        if (measurementIndex >= this.columns.length) {
            return null;
        }
        switch (this.dataTypes[measurementIndex]) {
            case INT32: {
                int[] intValues = (int[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsInt(intValues[this.rowCount - 1]);
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsLong(longValues[this.rowCount - 1]);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsFloat(floatValues[this.rowCount - 1]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsDouble(doubleValues[this.rowCount - 1]);
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBoolean(boolValues[this.rowCount - 1]);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBinary(binaryValues[this.rowCount - 1]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[measurementIndex]));
            }
        }
        return new TimeValuePair(this.times[this.rowCount - 1], (TsPrimitiveType)value);
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int size) {
        this.rowCount = size;
    }

    public String toString() {
        return "InsertTabletPlan {deviceId:" + this.deviceId + ", timesRange[" + this.times[0] + "," + this.times[this.times.length - 1] + "]" + '}';
    }

    @Override
    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        super.markFailedMeasurementInsertion(index, e);
        if (this.failedColumns == null) {
            this.failedColumns = new ArrayList<Object>();
        }
        this.failedColumns.add(this.columns[index]);
        this.columns[index] = null;
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        this.columns = this.failedColumns.toArray(new Object[0]);
        this.failedColumns = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertTabletPlan that = (InsertTabletPlan)o;
        return this.rowCount == that.rowCount && Arrays.equals(this.times, that.times) && Objects.equals(this.timeBuffer, that.timeBuffer) && Objects.equals(this.valueBuffer, that.valueBuffer) && Objects.equals(this.paths, that.paths) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        int result = Objects.hash(this.timeBuffer, this.valueBuffer, this.rowCount, this.paths, this.range);
        result = 31 * result + Arrays.hashCode(this.times);
        return result;
    }

    @Override
    public void recoverFromFailure() {
        if (this.failedMeasurements == null) {
            return;
        }
        for (int i = 0; i < this.failedMeasurements.size(); ++i) {
            int index = (Integer)this.failedIndices.get(i);
            this.columns[index] = this.failedColumns.get(i);
        }
        super.recoverFromFailure();
        this.failedColumns = null;
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        super.checkIntegrity();
        if (this.columns == null || this.columns.length == 0) {
            throw new QueryProcessException("Values are null");
        }
        if (this.measurements.length != this.columns.length) {
            throw new QueryProcessException(String.format("Measurements length [%d] does not match columns length [%d]", this.measurements.length, this.columns.length));
        }
        for (Object value : this.columns) {
            if (value != null) continue;
            throw new QueryProcessException("Columns contain null: " + Arrays.toString(this.columns));
        }
    }
}

