/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.no;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public class NoCompactionTsFileManagement
extends TsFileManagement {
    private final Map<Long, TreeSet<TsFileResource>> sequenceFileTreeSetMap = new TreeMap<Long, TreeSet<TsFileResource>>();
    private final Map<Long, List<TsFileResource>> unSequenceFileListMap = new TreeMap<Long, List<TsFileResource>>();

    public NoCompactionTsFileManagement(String storageGroupName, String virtualStorageGroupId, String storageGroupDir) {
        super(storageGroupName, virtualStorageGroupId, storageGroupDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<TsFileResource> getTsFileList(boolean sequence) {
        this.readLock();
        try {
            ArrayList result = new ArrayList();
            if (sequence) {
                for (TreeSet treeSet : this.sequenceFileTreeSetMap.values()) {
                    result.addAll(treeSet);
                }
            } else {
                for (List list : this.unSequenceFileListMap.values()) {
                    result.addAll(list);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TsFileResource> getTsFileListByTimePartition(boolean sequence, long timePartition) {
        this.readLock();
        try {
            if (sequence) {
                ArrayList<TsFileResource> arrayList = new ArrayList<TsFileResource>((Collection)this.sequenceFileTreeSetMap.getOrDefault(timePartition, this.newSequenceTsFileResources(0L)));
                return arrayList;
            }
            ArrayList<TsFileResource> arrayList = new ArrayList<TsFileResource>(this.unSequenceFileListMap.getOrDefault(timePartition, Collections.emptyList()));
            return arrayList;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        this.readLock();
        try {
            Iterator<TsFileResource> iterator = this.getTsFileList(sequence).iterator();
            return iterator;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock();
        try {
            if (sequence) {
                TreeSet<TsFileResource> sequenceFileTreeSet = this.sequenceFileTreeSetMap.get(tsFileResource.getTimePartition());
                sequenceFileTreeSet.remove(tsFileResource);
            } else {
                List<TsFileResource> unSequenceFileList = this.unSequenceFileListMap.get(tsFileResource.getTimePartition());
                unSequenceFileList.remove(tsFileResource);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock();
        try {
            if (tsFileResourceList.size() > 0) {
                tsFileResourceList.sort((o1, o2) -> (int)(o1.getTimePartition() - o2.getTimePartition()));
                if (sequence) {
                    long currTimePartition = tsFileResourceList.get(0).getTimePartition();
                    int startIndex = 0;
                    for (int i = 1; i < tsFileResourceList.size(); ++i) {
                        TsFileResource tsFileResource = tsFileResourceList.get(i);
                        if (tsFileResource.getTimePartition() == currTimePartition) continue;
                        this.sequenceFileTreeSetMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, i));
                        currTimePartition = tsFileResource.getTimePartition();
                        startIndex = i;
                    }
                    this.sequenceFileTreeSetMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, tsFileResourceList.size()));
                } else {
                    long currTimePartition = tsFileResourceList.get(0).getTimePartition();
                    int startIndex = 0;
                    for (int i = 1; i < tsFileResourceList.size(); ++i) {
                        TsFileResource tsFileResource = tsFileResourceList.get(i);
                        if (tsFileResource.getTimePartition() == currTimePartition) continue;
                        this.unSequenceFileListMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, i));
                        currTimePartition = tsFileResource.getTimePartition();
                        startIndex = i;
                    }
                    this.unSequenceFileListMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, tsFileResourceList.size()));
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock();
        try {
            long timePartitionId = tsFileResource.getTimePartition();
            if (sequence) {
                this.sequenceFileTreeSetMap.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).add(tsFileResource);
            } else {
                this.unSequenceFileListMap.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).add(tsFileResource);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock();
        try {
            for (TsFileResource tsFileResource : tsFileResourceList) {
                this.add(tsFileResource, sequence);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                boolean bl = this.sequenceFileTreeSetMap.getOrDefault(tsFileResource.getTimePartition(), this.newSequenceTsFileResources(0L)).contains(tsFileResource);
                return bl;
            }
            boolean bl = ((List)this.unSequenceFileListMap.getOrDefault(tsFileResource.getTimePartition(), new ArrayList())).contains(tsFileResource);
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void clear() {
        this.writeLock();
        try {
            this.sequenceFileTreeSetMap.clear();
            this.unSequenceFileListMap.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                for (Set set : this.sequenceFileTreeSetMap.values()) {
                    if (set.isEmpty()) continue;
                    boolean bl = false;
                    return bl;
                }
            } else {
                for (List list : this.unSequenceFileListMap.values()) {
                    if (list.isEmpty()) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean sequence) {
        this.readLock();
        try {
            int result = 0;
            if (sequence) {
                for (Set set : this.sequenceFileTreeSetMap.values()) {
                    result += set.size();
                }
            } else {
                for (List list : this.unSequenceFileListMap.values()) {
                    result += list.size();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void recover() {
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
    }

    @Override
    protected void merge(long timePartition) {
    }

    private TreeSet<TsFileResource> newSequenceTsFileResources(Long k) {
        return new TreeSet<TsFileResource>((o1, o2) -> NoCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()));
    }

    private List<TsFileResource> newUnSequenceTsFileResources(Long k) {
        return new ArrayList<TsFileResource>();
    }
}

