/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.fill;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.cluster.query.aggregate.ClusterAggregator;
import org.apache.iotdb.cluster.query.fill.ClusterPreviousFill;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.tsfile.read.TimeValuePair;

public class ClusterLinearFill
extends LinearFill {
    private MetaGroupMember metaGroupMember;
    private ClusterAggregator aggregator;
    private static final List<String> AGGREGATION_NAMES = Arrays.asList("min_time", "first_value");

    ClusterLinearFill(LinearFill fill, MetaGroupMember metaGroupMember) {
        super(fill.getDataType(), fill.getQueryTime(), fill.getBeforeRange(), fill.getAfterRange());
        this.metaGroupMember = metaGroupMember;
        this.aggregator = new ClusterAggregator(metaGroupMember);
    }

    protected TimeValuePair calculatePrecedingPoint() throws QueryProcessException, StorageEngineException {
        ClusterPreviousFill clusterPreviousFill = new ClusterPreviousFill(this.dataType, this.queryTime, this.beforeRange, this.metaGroupMember);
        clusterPreviousFill.configureFill(this.seriesPath, this.dataType, this.queryTime, this.deviceMeasurements, this.context);
        return clusterPreviousFill.getFillResult();
    }

    protected TimeValuePair calculateSucceedingPoint() throws StorageEngineException {
        List<AggregateResult> aggregateResult = this.aggregator.getAggregateResult(this.seriesPath, this.deviceMeasurements, AGGREGATION_NAMES, this.dataType, this.afterFilter, this.context, true);
        AggregateResult minTimeResult = aggregateResult.get(0);
        AggregateResult firstValueResult = aggregateResult.get(1);
        return this.convertToResult(minTimeResult, firstValueResult);
    }
}

