/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaPuller {
    private static final Logger logger = LoggerFactory.getLogger(MetaPuller.class);
    private MetaGroupMember metaGroupMember;

    private MetaPuller() {
    }

    public void init(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public static MetaPuller getInstance() {
        return MetaPullerHolder.INSTANCE;
    }

    List<MeasurementSchema> pullMeasurementSchemas(List<PartialPath> prefixPaths) throws MetadataException {
        logger.debug("{}: Pulling timeseries schemas of {}", (Object)this.metaGroupMember.getName(), prefixPaths);
        HashMap<PartitionGroup, List> partitionGroupPathMap = new HashMap<PartitionGroup, List>();
        for (PartialPath prefixPath : prefixPaths) {
            PartitionGroup partitionGroup = ClusterUtils.partitionByPathTimeWithSync(prefixPath, this.metaGroupMember);
            partitionGroupPathMap.computeIfAbsent(partitionGroup, g -> new ArrayList()).add(prefixPath);
        }
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulling schemas of {} and other {} paths from {} groups", new Object[]{this.metaGroupMember.getName(), prefixPaths.get(0), prefixPaths.size() - 1, partitionGroupPathMap.size()});
        }
        for (Map.Entry partitionGroupListEntry : partitionGroupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)partitionGroupListEntry.getKey();
            List paths = (List)partitionGroupListEntry.getValue();
            this.pullMeasurementSchemas(partitionGroup, paths, schemas);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: pulled {} schemas for {} and other {} paths", new Object[]{this.metaGroupMember.getName(), schemas.size(), prefixPaths.get(0), prefixPaths.size() - 1});
        }
        return schemas;
    }

    private void pullMeasurementSchemas(PartitionGroup partitionGroup, List<PartialPath> prefixPaths, List<MeasurementSchema> results) {
        Node node;
        if (partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            try {
                this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), "Pull timeseries of " + prefixPaths).syncLeader(null);
            }
            catch (CheckConsistencyException e) {
                logger.warn("Failed to check consistency.", (Throwable)e);
            }
            int preSize = results.size();
            for (PartialPath prefixPath : prefixPaths) {
                IoTDB.metaManager.collectSeries(prefixPath, results);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from local", new Object[]{this.metaGroupMember.getName(), results.size() - preSize, prefixPaths.get(0), prefixPaths.size() - 1});
            }
            return;
        }
        PullSchemaRequest pullSchemaRequest = new PullSchemaRequest();
        pullSchemaRequest.setHeader(partitionGroup.getHeader());
        pullSchemaRequest.setPrefixPaths(prefixPaths.stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        Iterator iterator = partitionGroup.iterator();
        while (iterator.hasNext() && !this.pullMeasurementSchemas(node = (Node)iterator.next(), pullSchemaRequest, results)) {
        }
    }

    private boolean pullMeasurementSchemas(Node node, PullSchemaRequest request, List<MeasurementSchema> results) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Pulling timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node});
        }
        List<MeasurementSchema> schemas = null;
        try {
            schemas = this.pullMeasurementSchemas(node, request);
        }
        catch (IOException | TException e) {
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("{}: Cannot pull timeseries schemas of {} and other {} paths from {}", new Object[]{this.metaGroupMember.getName(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, e});
        }
        if (schemas != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Pulled {} timeseries schemas of {} and other {} paths from {} of {}", new Object[]{this.metaGroupMember.getName(), schemas.size(), request.getPrefixPaths().get(0), request.getPrefixPaths().size() - 1, node, request.getHeader()});
            }
            results.addAll(schemas);
            return true;
        }
        return false;
    }

    private List<MeasurementSchema> pullMeasurementSchemas(Node node, PullSchemaRequest request) throws TException, InterruptedException, IOException {
        List<MeasurementSchema> schemas;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            schemas = SyncClientAdaptor.pullMeasurementSchema(client, request);
        } else {
            try (SyncDataClient syncDataClient = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
                try {
                    PullSchemaResp pullSchemaResp = syncDataClient.pullMeasurementSchema(request);
                    ByteBuffer buffer = pullSchemaResp.schemaBytes;
                    int size = buffer.getInt();
                    schemas = new ArrayList<MeasurementSchema>(size);
                    for (int i = 0; i < size; ++i) {
                        schemas.add(MeasurementSchema.deserializeFrom((ByteBuffer)buffer));
                    }
                }
                catch (TException e) {
                    syncDataClient.getInputProtocol().getTransport().close();
                    throw e;
                }
            }
        }
        return schemas;
    }

    private static class MetaPullerHolder {
        private static final MetaPuller INSTANCE = new MetaPuller();

        private MetaPullerHolder() {
        }
    }
}

