/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.applier;

import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.applier.BaseApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaLogApplier
extends BaseApplier {
    private static final Logger logger = LoggerFactory.getLogger(MetaLogApplier.class);
    private MetaGroupMember member;

    public MetaLogApplier(MetaGroupMember member) {
        super(member);
        this.member = member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Log log) {
        try {
            logger.debug("MetaMember [{}] starts applying Log {}", (Object)this.metaGroupMember.getName(), (Object)log);
            if (log instanceof AddNodeLog) {
                AddNodeLog addNodeLog = (AddNodeLog)log;
                Node newNode = addNodeLog.getNewNode();
                this.member.applyAddNode(newNode);
            } else if (log instanceof PhysicalPlanLog) {
                this.applyPhysicalPlan(((PhysicalPlanLog)log).getPlan(), null);
            } else if (log instanceof RemoveNodeLog) {
                RemoveNodeLog removeNodeLog = (RemoveNodeLog)log;
                this.member.applyRemoveNode(removeNodeLog.getRemovedNode());
            } else {
                logger.error("Unsupported log: {} {}", (Object)log.getClass().getName(), (Object)log);
            }
        }
        catch (StorageEngineException | StorageGroupNotSetException | QueryProcessException e) {
            logger.debug("Exception occurred when executing {}", (Object)log, (Object)e);
            log.setException((Exception)e);
        }
        finally {
            log.setApplied(true);
        }
    }
}

