/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.applier;

import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.applier.BaseApplier;
import org.apache.iotdb.cluster.log.logtypes.CloseFileLog;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLogApplier
extends BaseApplier {
    private static final Logger logger = LoggerFactory.getLogger(DataLogApplier.class);
    protected DataGroupMember dataGroupMember;

    public DataLogApplier(MetaGroupMember metaGroupMember, DataGroupMember dataGroupMember) {
        super(metaGroupMember);
        this.dataGroupMember = dataGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Log log) {
        logger.debug("DataMember [{}] start applying Log {}", (Object)this.dataGroupMember.getName(), (Object)log);
        try {
            if (log instanceof PhysicalPlanLog) {
                PhysicalPlanLog physicalPlanLog = (PhysicalPlanLog)log;
                PhysicalPlan plan = physicalPlanLog.getPlan();
                this.applyPhysicalPlan(plan);
            } else if (log instanceof CloseFileLog) {
                CloseFileLog closeFileLog = (CloseFileLog)log;
                StorageEngine.getInstance().closeStorageGroupProcessor(new PartialPath(closeFileLog.getStorageGroupName()), closeFileLog.getPartitionId(), closeFileLog.isSeq(), false);
            } else {
                logger.error("Unsupported log: {}", (Object)log);
            }
        }
        catch (Exception e) {
            Throwable rootCause = IOUtils.getRootCause(e);
            if (!(rootCause instanceof PathNotExistException)) {
                logger.debug("Exception occurred when applying {}", (Object)log, (Object)e);
            }
            log.setException(e);
        }
        finally {
            log.setApplied(true);
        }
    }

    public void applyPhysicalPlan(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (plan instanceof InsertMultiTabletPlan) {
            this.applyInsert((InsertMultiTabletPlan)plan);
        } else if (plan instanceof InsertRowsPlan) {
            this.applyInsert((InsertRowsPlan)plan);
        } else if (plan instanceof InsertPlan) {
            this.applyInsert((InsertPlan)plan);
        } else {
            this.applyPhysicalPlan(plan, this.dataGroupMember);
        }
    }

    private void applyInsert(InsertMultiTabletPlan plan) throws StorageGroupNotSetException, QueryProcessException, StorageEngineException {
        boolean hasSync = false;
        for (InsertTabletPlan insertTabletPlan : plan.getInsertTabletPlanList()) {
            try {
                IoTDB.metaManager.getStorageGroupPath(insertTabletPlan.getDeviceId());
            }
            catch (StorageGroupNotSetException e) {
                try {
                    if (!hasSync) {
                        this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
                        hasSync = true;
                        continue;
                    }
                    throw new StorageEngineException(e.getMessage());
                }
                catch (CheckConsistencyException ce) {
                    throw new QueryProcessException(ce.getMessage());
                }
            }
        }
        this.applyPhysicalPlan((PhysicalPlan)plan, this.dataGroupMember);
    }

    private void applyInsert(InsertRowsPlan plan) throws StorageGroupNotSetException, QueryProcessException, StorageEngineException {
        boolean hasSync = false;
        for (InsertRowPlan insertRowPlan : plan.getInsertRowPlanList()) {
            try {
                IoTDB.metaManager.getStorageGroupPath(insertRowPlan.getDeviceId());
            }
            catch (StorageGroupNotSetException e) {
                try {
                    if (!hasSync) {
                        this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
                        hasSync = true;
                        continue;
                    }
                    throw new StorageEngineException(e.getMessage());
                }
                catch (CheckConsistencyException ce) {
                    throw new QueryProcessException(ce.getMessage());
                }
            }
        }
        this.applyPhysicalPlan((PhysicalPlan)plan, this.dataGroupMember);
    }

    private void applyInsert(InsertPlan plan) throws StorageGroupNotSetException, QueryProcessException, StorageEngineException {
        PartialPath sg;
        long time = plan.getMinTime();
        try {
            sg = IoTDB.metaManager.getStorageGroupPath(plan.getDeviceId());
        }
        catch (StorageGroupNotSetException e) {
            try {
                this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
            }
            catch (CheckConsistencyException ce) {
                throw new QueryProcessException(ce.getMessage());
            }
            sg = IoTDB.metaManager.getStorageGroupPath(plan.getDeviceId());
        }
        int slotId = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(sg.getFullPath(), time, 10000);
        this.dataGroupMember.getSlotManager().waitSlotForWrite(slotId);
        this.applyPhysicalPlan((PhysicalPlan)plan, this.dataGroupMember);
    }
}

