/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.IFilterOptimizer;

public class DnfFilterOptimizer
implements IFilterOptimizer {
    @Override
    public FilterOperator optimize(FilterOperator filter) throws LogicalOptimizeException {
        return this.getDnf(filter);
    }

    private void dealWithLeftAndRightAndChildren(List<FilterOperator> leftAndChildren, List<FilterOperator> rightAndChildren, List<FilterOperator> newChildrenList) throws LogicalOptimizeException {
        for (FilterOperator leftAndChild : leftAndChildren) {
            for (FilterOperator rightAndChild : rightAndChildren) {
                FilterOperator r = this.mergeToConjunction(leftAndChild.copy(), rightAndChild.copy());
                newChildrenList.add(r);
            }
        }
    }

    private FilterOperator getDnf(FilterOperator filter) throws LogicalOptimizeException {
        if (filter.isLeaf()) {
            return filter;
        }
        List<FilterOperator> childOperators = filter.getChildren();
        if (childOperators.size() != 2) {
            throw new LogicalOptimizeException("node :" + filter.getTokenName() + " has " + childOperators.size() + " children");
        }
        FilterOperator left = this.getDnf(childOperators.get(0));
        FilterOperator right = this.getDnf(childOperators.get(1));
        ArrayList<FilterOperator> newChildrenList = new ArrayList<FilterOperator>();
        switch (filter.getTokenIntType()) {
            case 2: {
                this.addChildOpInOr(left, newChildrenList);
                this.addChildOpInOr(right, newChildrenList);
                break;
            }
            case 1: {
                if (left.getTokenIntType() != 2 && right.getTokenIntType() != 2) {
                    this.addChildOpInAnd(left, newChildrenList);
                    this.addChildOpInAnd(right, newChildrenList);
                    break;
                }
                this.dealWithLeftAndRightAndChildren(this.getAndChild(left), this.getAndChild(right), newChildrenList);
                filter.setTokenIntType(2);
                break;
            }
            default: {
                throw new LogicalOptimizeException("get DNF failed, this tokenType is:" + filter.getTokenIntType());
            }
        }
        filter.setChildren(newChildrenList);
        return filter;
    }

    private FilterOperator mergeToConjunction(FilterOperator operator1, FilterOperator operator2) throws LogicalOptimizeException {
        ArrayList<FilterOperator> retChildrenList = new ArrayList<FilterOperator>();
        this.addChildOpInAnd(operator1, retChildrenList);
        this.addChildOpInAnd(operator2, retChildrenList);
        FilterOperator ret = new FilterOperator(1, false);
        ret.setChildren(retChildrenList);
        return ret;
    }

    private List<FilterOperator> getAndChild(FilterOperator child) {
        if (child.getTokenIntType() == 2) {
            return child.getChildren();
        }
        ArrayList<FilterOperator> ret = new ArrayList<FilterOperator>();
        ret.add(child);
        return ret;
    }

    private void addChildOpInAnd(FilterOperator operator, List<FilterOperator> newChildrenList) throws LogicalOptimizeException {
        if (operator.isLeaf()) {
            newChildrenList.add(operator);
        } else if (operator.getTokenIntType() == 1) {
            newChildrenList.addAll(operator.getChildren());
        } else {
            throw new LogicalOptimizeException("add all children of an OR operator to newChildrenList in AND");
        }
    }

    private void addChildOpInOr(FilterOperator operator, List<FilterOperator> newChildrenList) {
        if (operator.isLeaf() || operator.getTokenIntType() == 1) {
            newChildrenList.add(operator);
        } else {
            newChildrenList.addAll(operator.getChildren());
        }
    }
}

