/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.last;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.utils.ClusterQueryUtils;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLastQueryExecutor
extends LastQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ClusterLastQueryExecutor.class);
    private MetaGroupMember metaGroupMember;
    private static ExecutorService lastQueryPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public ClusterLastQueryExecutor(LastQueryPlan lastQueryPlan, MetaGroupMember metaGroupMember) {
        super(lastQueryPlan);
        this.metaGroupMember = metaGroupMember;
    }

    public List<Pair<Boolean, TimeValuePair>> calculateLastPairForSeries(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan) throws QueryProcessException, IOException {
        return this.calculateLastPairsForSeries(seriesPaths, dataTypes, context, expression, lastQueryPlan);
    }

    private List<Pair<Boolean, TimeValuePair>> calculateLastPairsForSeries(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan) throws IOException, QueryProcessException {
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new IOException(e);
        }
        ArrayList<Pair<Boolean, TimeValuePair>> results = new ArrayList<Pair<Boolean, TimeValuePair>>(seriesPaths.size());
        for (int i = 0; i < seriesPaths.size(); ++i) {
            results.add(new Pair((Object)true, (Object)new TimeValuePair(Long.MIN_VALUE, null)));
        }
        List<PartitionGroup> globalGroups = this.metaGroupMember.getPartitionTable().getGlobalGroups();
        ArrayList<Future<List<Pair<Boolean, TimeValuePair>>>> groupFutures = new ArrayList<Future<List<Pair<Boolean, TimeValuePair>>>>(globalGroups.size());
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        for (PartitionGroup partitionGroup : globalGroups) {
            GroupLastTask task = new GroupLastTask(partitionGroup, seriesPaths, dataTypes, context, expression, lastQueryPlan, dataTypeOrdinals);
            groupFutures.add(lastQueryPool.submit(task));
        }
        for (Future future : groupFutures) {
            try {
                List timeValuePairs = (List)future.get();
                for (int i = 0; i < timeValuePairs.size(); ++i) {
                    if (timeValuePairs.get(i) == null || ((Pair)timeValuePairs.get((int)i)).right == null || ((TimeValuePair)((Pair)timeValuePairs.get((int)i)).right).getTimestamp() <= ((TimeValuePair)((Pair)results.get((int)i)).right).getTimestamp()) continue;
                    ((Pair)results.get((int)i)).right = ((Pair)timeValuePairs.get((int)i)).right;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Query last of {} interrupted", seriesPaths);
            }
            catch (ExecutionException e) {
                throw new QueryProcessException((Throwable)e, TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
            }
        }
        return results;
    }

    class GroupLastTask
    implements Callable<List<Pair<Boolean, TimeValuePair>>> {
        private PartitionGroup group;
        private List<PartialPath> seriesPaths;
        private List<TSDataType> dataTypes;
        private List<Integer> dataTypeOrdinals;
        private QueryContext queryContext;
        private RawDataQueryPlan queryPlan;
        private IExpression expression;

        GroupLastTask(PartitionGroup group, List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan, List<Integer> dataTypeOrdinals) {
            this.group = group;
            this.seriesPaths = seriesPaths;
            this.dataTypes = dataTypes;
            this.queryContext = context;
            this.queryPlan = lastQueryPlan;
            this.expression = expression;
            this.dataTypeOrdinals = dataTypeOrdinals;
        }

        @Override
        public List<Pair<Boolean, TimeValuePair>> call() throws Exception {
            return this.calculateSeriesLast(this.group, this.seriesPaths, this.queryContext);
        }

        private List<Pair<Boolean, TimeValuePair>> calculateSeriesLast(PartitionGroup group, List<PartialPath> seriesPaths, QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
            if (group.contains(ClusterLastQueryExecutor.this.metaGroupMember.getThisNode())) {
                ClusterQueryUtils.checkPathExistence(seriesPaths);
                return this.calculateSeriesLastLocally(group, seriesPaths, context);
            }
            return this.calculateSeriesLastRemotely(group, seriesPaths, context);
        }

        private List<Pair<Boolean, TimeValuePair>> calculateSeriesLastLocally(PartitionGroup group, List<PartialPath> seriesPaths, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
            DataGroupMember localDataMember = ClusterLastQueryExecutor.this.metaGroupMember.getLocalDataMember(group.getHeader());
            try {
                localDataMember.syncLeaderWithConsistencyCheck(false);
            }
            catch (CheckConsistencyException e) {
                throw new QueryProcessException(e.getMessage());
            }
            return LastQueryExecutor.calculateLastPairForSeriesLocally(seriesPaths, this.dataTypes, (QueryContext)context, (IExpression)this.expression, (Map)this.queryPlan.getDeviceToMeasurements());
        }

        private List<Pair<Boolean, TimeValuePair>> calculateSeriesLastRemotely(PartitionGroup group, List<PartialPath> seriesPaths, QueryContext context) {
            for (Node node : group) {
                try {
                    ByteBuffer buffer = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.lastAsync(node, context) : this.lastSync(node, context);
                    if (buffer == null) continue;
                    ArrayList<TimeValuePair> timeValuePairs = new ArrayList<TimeValuePair>();
                    for (int i = 0; i < seriesPaths.size(); ++i) {
                        timeValuePairs.add(SerializeUtils.deserializeTVPair((ByteBuffer)buffer));
                    }
                    ArrayList<Pair<Boolean, TimeValuePair>> results = new ArrayList<Pair<Boolean, TimeValuePair>>();
                    for (int i = 0; i < seriesPaths.size(); ++i) {
                        TimeValuePair pair = (TimeValuePair)timeValuePairs.get(i);
                        results.add((Pair<Boolean, TimeValuePair>)new Pair((Object)true, (Object)pair));
                    }
                    return results;
                }
                catch (TException e) {
                    logger.warn("Query last of {} from {} errored", new Object[]{group, seriesPaths, e});
                    return Collections.emptyList();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Query last of {} from {} interrupted", new Object[]{group, seriesPaths, e});
                    return Collections.emptyList();
                }
            }
            return Collections.emptyList();
        }

        private ByteBuffer lastAsync(Node node, QueryContext context) throws TException, InterruptedException {
            AsyncDataClient asyncDataClient;
            try {
                asyncDataClient = ClusterLastQueryExecutor.this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            }
            catch (IOException e) {
                logger.warn("can not get client for node= {}", (Object)node);
                return null;
            }
            Filter timeFilter = this.expression == null ? null : ((GlobalTimeExpression)this.expression).getFilter();
            ByteBuffer buffer = SyncClientAdaptor.last(asyncDataClient, this.seriesPaths, this.dataTypeOrdinals, timeFilter, context, this.queryPlan.getDeviceToMeasurements(), this.group.getHeader());
            return buffer;
        }

        private ByteBuffer lastSync(Node node, QueryContext context) throws TException {
            SyncDataClient client = ClusterLastQueryExecutor.this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
            try {
                Filter timeFilter;
                LastQueryRequest lastQueryRequest = new LastQueryRequest(PartialPath.toStringList(this.seriesPaths), this.dataTypeOrdinals, context.getQueryId(), this.queryPlan.getDeviceToMeasurements(), this.group.getHeader(), client.getNode());
                Filter filter = timeFilter = this.expression == null ? null : ((GlobalTimeExpression)this.expression).getFilter();
                if (timeFilter != null) {
                    lastQueryRequest.setFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
                }
                ByteBuffer byteBuffer = client.last(lastQueryRequest);
                if (client != null) {
                    client.close();
                }
                return byteBuffer;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("can not get client for node= {}", (Object)node);
                    return null;
                }
            }
        }
    }
}

