/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.query.fill.ClusterLinearFill;
import org.apache.iotdb.cluster.query.fill.ClusterPreviousFill;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class ClusterFillExecutor
extends FillQueryExecutor {
    private MetaGroupMember metaGroupMember;
    private ClusterReaderFactory clusterReaderFactory;

    public ClusterFillExecutor(FillQueryPlan plan, MetaGroupMember metaGroupMember) {
        super(plan);
        this.metaGroupMember = metaGroupMember;
        this.clusterReaderFactory = new ClusterReaderFactory(metaGroupMember);
    }

    protected IFill configureFill(IFill fill, PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) throws QueryProcessException, StorageEngineException {
        if (fill instanceof LinearFill) {
            ClusterLinearFill clusterFill = new ClusterLinearFill((LinearFill)fill, this.metaGroupMember);
            clusterFill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
            return clusterFill;
        }
        if (fill instanceof PreviousFill) {
            ClusterPreviousFill clusterFill = new ClusterPreviousFill((PreviousFill)fill, this.metaGroupMember);
            clusterFill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
            return clusterFill;
        }
        fill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
        return fill;
    }

    protected List<TimeValuePair> getTimeValuePairs(QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
        ArrayList<TimeValuePair> ret = new ArrayList<TimeValuePair>(this.selectedSeries.size());
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            PartialPath path = (PartialPath)this.selectedSeries.get(i);
            TSDataType dataType = (TSDataType)this.dataTypes.get(i);
            IReaderByTimestamp reader = this.clusterReaderFactory.getReaderByTimestamp(path, this.plan.getAllMeasurementsInDevice(path.getDevice()), (TSDataType)this.dataTypes.get(i), context, this.plan.isAscending());
            Object[] results = reader.getValuesInTimestamps(new long[]{this.queryTime}, 1);
            if (results != null && results[0] != null) {
                ret.add(new TimeValuePair(this.queryTime, TsPrimitiveType.getByType((TSDataType)dataType, (Object)results[0])));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }
}

