/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.log.snapshot.SnapshotInstaller;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedSnapshot<T extends Snapshot>
extends Snapshot {
    private static final Logger logger = LoggerFactory.getLogger(PartitionedSnapshot.class);
    private Map<Integer, T> slotSnapshots;
    private SnapshotFactory<T> factory;

    public PartitionedSnapshot(SnapshotFactory<T> factory) {
        this(new HashMap(), factory);
    }

    private PartitionedSnapshot(Map<Integer, T> slotSnapshots, SnapshotFactory<T> factory) {
        this.slotSnapshots = slotSnapshots;
        this.factory = factory;
    }

    public void putSnapshot(int slot, T snapshot) {
        this.slotSnapshots.put(slot, snapshot);
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        logger.info("Start to serialize a snapshot of {} sub-snapshots", (Object)this.slotSnapshots.size());
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            dataOutputStream.writeInt(this.slotSnapshots.size());
            for (Map.Entry<Integer, T> entry : this.slotSnapshots.entrySet()) {
                dataOutputStream.writeInt(entry.getKey());
                dataOutputStream.write(((Snapshot)entry.getValue()).serialize().array());
            }
            dataOutputStream.writeLong(this.getLastLogIndex());
            dataOutputStream.writeLong(this.getLastLogTerm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            int slot = buffer.getInt();
            T snapshot = this.factory.create();
            ((Snapshot)snapshot).deserialize(buffer);
            this.slotSnapshots.put(slot, snapshot);
        }
        this.setLastLogIndex(buffer.getLong());
        this.setLastLogTerm(buffer.getLong());
    }

    public T getSnapshot(int slot) {
        return (T)((Snapshot)this.slotSnapshots.get(slot));
    }

    public String toString() {
        return "PartitionedSnapshot{slotSnapshots=" + this.slotSnapshots.size() + ", lastLogIndex=" + this.lastLogIndex + ", lastLogTerm=" + this.lastLogTerm + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionedSnapshot snapshot = (PartitionedSnapshot)o;
        return Objects.equals(this.slotSnapshots, snapshot.slotSnapshots);
    }

    public SnapshotInstaller getDefaultInstaller(RaftMember member) {
        return new Installer((DataGroupMember)member);
    }

    public int hashCode() {
        return Objects.hash(this.slotSnapshots);
    }

    @Override
    public void truncateBefore(long minIndex) {
        for (Snapshot value : this.slotSnapshots.values()) {
            value.truncateBefore(minIndex);
        }
    }

    public class Installer
    implements SnapshotInstaller<PartitionedSnapshot> {
        private DataGroupMember dataGroupMember;
        private String name;

        public Installer(DataGroupMember dataGroupMember) {
            this.dataGroupMember = dataGroupMember;
            this.name = dataGroupMember.getName();
        }

        @Override
        public void install(PartitionedSnapshot snapshot, int slot) throws SnapshotInstallationException {
            this.installPartitionedSnapshot(snapshot);
        }

        @Override
        public void install(Map<Integer, PartitionedSnapshot> snapshotMap) {
            throw new IllegalStateException("Method unimplemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void installPartitionedSnapshot(PartitionedSnapshot<T> snapshot) throws SnapshotInstallationException {
            logger.info("{}: start to install a snapshot of {}-{}", new Object[]{this.dataGroupMember.getName(), snapshot.lastLogIndex, snapshot.lastLogTerm});
            Object object = this.dataGroupMember.getSnapshotApplyLock();
            synchronized (object) {
                List<Integer> slots = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getNodeSlots(this.dataGroupMember.getHeader());
                for (Integer slot : slots) {
                    Object subSnapshot = snapshot.getSnapshot(slot);
                    if (subSnapshot == null) continue;
                    this.installSnapshot(subSnapshot, slot);
                }
                RaftLogManager raftLogManager = this.dataGroupMember.getLogManager();
                synchronized (raftLogManager) {
                    this.dataGroupMember.getLogManager().applySnapshot(snapshot);
                }
            }
        }

        void installSnapshot(T snapshot, int slot) throws SnapshotInstallationException {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: applying snapshot {}", (Object)this.name, snapshot);
            }
            try {
                this.dataGroupMember.getMetaGroupMember().syncLeaderWithConsistencyCheck(true);
            }
            catch (CheckConsistencyException e) {
                throw new SnapshotInstallationException(e);
            }
            SnapshotInstaller<? extends Snapshot> defaultInstaller = ((Snapshot)snapshot).getDefaultInstaller(this.dataGroupMember);
            defaultInstaller.install((Snapshot)snapshot, slot);
        }
    }
}

