/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.common.cache.Accountable;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class Chunk
implements Accountable {
    private ChunkHeader chunkHeader;
    private Statistics chunkStatistic;
    private ByteBuffer chunkData;
    private boolean isFromOldFile = false;
    private List<TimeRange> deleteIntervalList;
    private long ramSize;

    public Chunk(ChunkHeader header, ByteBuffer buffer, List<TimeRange> deleteIntervalList, Statistics chunkStatistic) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.deleteIntervalList = deleteIntervalList;
        this.chunkStatistic = chunkStatistic;
    }

    public ChunkHeader getHeader() {
        return this.chunkHeader;
    }

    public ByteBuffer getData() {
        return this.chunkData;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public void mergeChunk(Chunk chunk) throws IOException {
        PublicBAOS a;
        byte[] b;
        int dataSize = 0;
        int offset1 = -1;
        if (chunk.chunkHeader.getChunkType() == 5) {
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            offset1 = chunk.chunkData.position();
            chunk.chunkData.flip();
            dataSize += chunk.chunkData.array().length + chunk.chunkStatistic.getSerializedSize();
        } else {
            dataSize += chunk.chunkData.array().length;
        }
        int offset2 = -1;
        if (this.chunkHeader.getChunkType() == 5) {
            this.chunkHeader.setChunkType((byte)1);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            offset2 = this.chunkData.position();
            this.chunkData.flip();
            dataSize += this.chunkData.array().length + this.chunkStatistic.getSerializedSize();
        } else {
            dataSize += this.chunkData.array().length;
        }
        this.chunkHeader.setDataSize(dataSize);
        ByteBuffer newChunkData = ByteBuffer.allocate(dataSize);
        if (offset2 == -1) {
            newChunkData.put(this.chunkData.array());
        } else {
            b = this.chunkData.array();
            newChunkData.put(b, 0, offset2);
            a = new PublicBAOS();
            this.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset2, b.length - offset2);
        }
        if (offset1 == -1) {
            newChunkData.put(chunk.chunkData.array());
        } else {
            b = chunk.chunkData.array();
            newChunkData.put(b, 0, offset1);
            a = new PublicBAOS();
            chunk.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset1, b.length - offset1);
        }
        this.chunkData = newChunkData;
    }

    @Override
    public void setRamSize(long size) {
        this.ramSize = size;
    }

    @Override
    public long getRamSize() {
        return this.ramSize;
    }

    public Statistics getChunkStatistic() {
        return this.chunkStatistic;
    }

    public boolean isFromOldFile() {
        return this.isFromOldFile;
    }

    public void setFromOldFile(boolean isFromOldFile) {
        this.isFromOldFile = isFromOldFile;
    }
}

