/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metrics.server.SqlArgument;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.SetDeviceTemplatePlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.dataset.DirectAlignByTimeDataSet;
import org.apache.iotdb.db.query.dataset.DirectNonAlignDataSet;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    private static final Logger QUERY_FREQUENCY_LOGGER = LoggerFactory.getLogger((String)"QUERY_FREQUENCY");
    private static final Logger DETAILED_FAILURE_QUERY_TRACE_LOGGER = LoggerFactory.getLogger((String)"DETAILED_FAILURE_QUERY_TRACE");
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"IoTDB_AUDIT_LOGGER");
    private static final String INFO_NOT_LOGIN = "{}: Not login. ";
    private static final String INFO_PARSING_SQL_ERROR = "Error occurred while parsing SQL to physical plan: ";
    private static final String INFO_CHECK_METADATA_ERROR = "Check metadata error: ";
    private static final String INFO_QUERY_PROCESS_ERROR = "Error occurred in query process: ";
    private static final String INFO_NOT_ALLOWED_IN_BATCH_ERROR = "The query statement is not allowed in batch: ";
    private static final String INFO_INTERRUPT_ERROR = "Current Thread interrupted when dealing with request {}";
    private static final int MAX_SIZE = IoTDBDescriptor.getInstance().getConfig().getQueryCacheSizeInMetric();
    private static final int DELETE_SIZE = 20;
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private static final long MS_TO_MONTH = 2592000000L;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final boolean enableMetric = this.config.isEnableMetricService();
    private static final List<SqlArgument> sqlArgumentList = new ArrayList<SqlArgument>(MAX_SIZE);
    protected Planner processor;
    protected IPlanExecutor executor;
    private final SessionManager sessionManager = SessionManager.getInstance();
    private final QueryTimeManager queryTimeManager = QueryTimeManager.getInstance();
    public static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    private static final AtomicInteger queryCount = new AtomicInteger(0);

    public TSServiceImpl() throws QueryProcessException {
        this.processor = new Planner();
        this.executor = new PlanExecutor();
        ScheduledExecutorService timedQuerySqlCountThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor("timedQuerySqlCountThread");
        timedQuerySqlCountThread.scheduleAtFixedRate(() -> {
            if (queryCount.get() != 0) {
                QUERY_FREQUENCY_LOGGER.info("Query count in current 1 minute {} ", (Object)queryCount.getAndSet(0));
            }
        }, this.config.getFrequencyIntervalInMinute(), this.config.getFrequencyIntervalInMinute(), TimeUnit.MINUTES);
    }

    public static List<SqlArgument> getSqlArgumentList() {
        return sqlArgumentList;
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TSStatus tsStatus;
        boolean status;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        String loginMessage = null;
        try {
            status = authorizer.login(req.getUsername(), req.getPassword());
        }
        catch (AuthException e) {
            LOGGER.info("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        long sessionId = -1L;
        if (status) {
            boolean compatible = this.checkCompatibility(req.getClient_protocol());
            if (!compatible) {
                TSStatus tsStatus2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INCOMPATIBLE_VERSION, (String)("The version is incompatible, please upgrade to " + IoTDBConstant.VERSION));
                TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus2, CURRENT_RPC_VERSION);
                resp.setSessionId(sessionId);
                return resp;
            }
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully");
            sessionId = this.sessionManager.requestSessionId(req.getUsername(), req.getZoneId());
            AUDIT_LOGGER.info("User {} opens Session-{}", (Object)req.getUsername(), (Object)sessionId);
            LOGGER.info("{}: Login status: {}. User : {}", new Object[]{"IoTDB", tsStatus.message, req.getUsername()});
        } else {
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR, (String)(loginMessage != null ? loginMessage : "Authentication failed."));
            AUDIT_LOGGER.info("User {} opens Session failed with an incorrect password", (Object)req.getUsername());
        }
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, CURRENT_RPC_VERSION);
        return resp.setSessionId(sessionId);
    }

    private boolean checkCompatibility(TSProtocolVersion version) {
        return version.equals((Object)CURRENT_RPC_VERSION);
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        long sessionId = req.getSessionId();
        AUDIT_LOGGER.info("Session-{} is closing", (Object)sessionId);
        this.sessionManager.removeCurrSessionId();
        return new TSStatus(!this.sessionManager.releaseSessionResource(this, sessionId) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("{}: receive close operation from Session {}", (Object)"IoTDB", (Object)this.sessionManager.getCurrSessionId());
        }
        try {
            if (req.isSetStatementId()) {
                if (req.isSetQueryId()) {
                    this.sessionManager.closeDataset(this, req.statementId, req.queryId);
                } else {
                    this.sessionManager.closeStatement(this, req.sessionId, req.statementId);
                }
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)"statement id not set by client.");
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "executing closeOperation", TSStatusCode.CLOSE_OPERATION_ERROR);
        }
    }

    public void releaseQueryResource(long queryId) throws StorageEngineException {
        this.sessionManager.releaseQueryResource(queryId);
    }

    public void releaseQueryResourceNoExceptions(long queryId) {
        if (queryId != -1L) {
            try {
                this.releaseQueryResource(queryId);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred while releasing query resource: ", (Throwable)e);
            }
        }
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSStatus status;
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        if (!this.checkLogin(req.getSessionId())) {
            return resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR));
        }
        try {
            switch (req.getType()) {
                case "METADATA_IN_JSON": {
                    resp.setMetadataInJson(this.getMetadataInString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(this.getSeriesTypeByPath(new PartialPath(req.getColumnPath())).toString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(new PartialPath(req.getColumnPath())).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)req.getType());
                    break;
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), (Throwable)e);
            status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            status = this.onNPEOrUnexpectedException(e, "executing fetchMetadata", TSStatusCode.INTERNAL_SERVER_ERROR);
        }
        return resp.setStatus(status);
    }

    private String getMetadataInString() {
        return IoTDB.metaManager.getMetadataInString();
    }

    protected List<PartialPath> getPaths(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPath(path);
    }

    private boolean executeInsertRowsPlan(InsertRowsPlan insertRowsPlan, List<TSStatus> result) {
        long t1 = System.currentTimeMillis();
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ROWS_PLAN_IN_BATCH, t1);
        int startIndex = result.size();
        if (startIndex > 0) {
            --startIndex;
        }
        for (int i = 0; i < insertRowsPlan.getRowCount(); ++i) {
            result.add(RpcUtils.SUCCESS_STATUS);
        }
        if (tsStatus.subStatus != null) {
            for (Map.Entry<Integer, TSStatus> entry : insertRowsPlan.getResults().entrySet()) {
                result.set(startIndex + entry.getKey(), entry.getValue());
            }
        }
        return tsStatus.getCode() == RpcUtils.SUCCESS_STATUS.getCode();
    }

    private boolean executeMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan, List<TSStatus> result) {
        long t1 = System.currentTimeMillis();
        TSStatus tsStatus = this.executeNonQueryPlan(multiPlan);
        Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_MULTI_TIMESERIES_PLAN_IN_BATCH, t1);
        int startIndex = result.size();
        if (startIndex > 0) {
            --startIndex;
        }
        for (int k = 0; k < multiPlan.getPaths().size(); ++k) {
            result.add(RpcUtils.SUCCESS_STATUS);
        }
        if (tsStatus.subStatus != null) {
            for (Map.Entry<Integer, TSStatus> entry : multiPlan.getResults().entrySet()) {
                result.set(startIndex + entry.getKey(), entry.getValue());
            }
        }
        return tsStatus.getCode() == RpcUtils.SUCCESS_STATUS.getCode();
    }

    private void initMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan) {
        if (multiPlan.getPaths() == null) {
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> tsEncodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> tsCompressionTypes = new ArrayList<CompressionType>();
            ArrayList<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
            ArrayList<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
            ArrayList<String> aliasList = new ArrayList<String>();
            multiPlan.setPaths(paths);
            multiPlan.setDataTypes(tsDataTypes);
            multiPlan.setEncodings(tsEncodings);
            multiPlan.setCompressors(tsCompressionTypes);
            multiPlan.setTags(tagsList);
            multiPlan.setAttributes(attributesList);
            multiPlan.setAlias(aliasList);
        }
    }

    private void setMultiTimeSeriesPlan(CreateMultiTimeSeriesPlan multiPlan, CreateTimeSeriesPlan createTimeSeriesPlan) {
        PartialPath path = createTimeSeriesPlan.getPath();
        TSDataType type = createTimeSeriesPlan.getDataType();
        TSEncoding encoding = createTimeSeriesPlan.getEncoding();
        CompressionType compressor = createTimeSeriesPlan.getCompressor();
        Map<String, String> tags = createTimeSeriesPlan.getTags();
        Map<String, String> attributes = createTimeSeriesPlan.getAttributes();
        String alias = createTimeSeriesPlan.getAlias();
        multiPlan.getPaths().add(path);
        multiPlan.getDataTypes().add(type);
        multiPlan.getEncodings().add(encoding);
        multiPlan.getCompressors().add(compressor);
        multiPlan.getTags().add(tags);
        multiPlan.getAttributes().add(attributes);
        multiPlan.getAlias().add(alias);
    }

    private boolean executeBatchList(List executeList, List<TSStatus> result) {
        boolean isAllSuccessful = true;
        for (int j = 0; j < executeList.size(); ++j) {
            Object planObject = executeList.get(j);
            if (InsertRowsPlan.class.isInstance(planObject)) {
                if (this.executeInsertRowsPlan((InsertRowsPlan)planObject, result)) continue;
                isAllSuccessful = false;
                continue;
            }
            if (!CreateMultiTimeSeriesPlan.class.isInstance(planObject) || this.executeMultiTimeSeriesPlan((CreateMultiTimeSeriesPlan)planObject, result)) continue;
            isAllSuccessful = false;
        }
        return isAllSuccessful;
    }

    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> result = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        int index = 0;
        ArrayList<PhysicalPlan> executeList = new ArrayList<PhysicalPlan>();
        Operator.OperatorType lastOperatorType = null;
        for (int i = 0; i < req.getStatements().size(); ++i) {
            String statement = (String)req.getStatements().get(i);
            try {
                PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionManager.getZoneId(req.sessionId), 10000);
                if (physicalPlan.isQuery()) {
                    throw new QueryInBatchStatementException(statement);
                }
                if (physicalPlan.getOperatorType().equals((Object)Operator.OperatorType.INSERT)) {
                    InsertRowsPlan insertRowsPlan;
                    if (Operator.OperatorType.INSERT == lastOperatorType) {
                        insertRowsPlan = (InsertRowsPlan)executeList.get(executeList.size() - 1);
                    } else {
                        insertRowsPlan = new InsertRowsPlan();
                        executeList.add(insertRowsPlan);
                        index = 0;
                    }
                    TSStatus status = this.checkAuthority(physicalPlan, req.getSessionId());
                    if (status != null) {
                        insertRowsPlan.getResults().put(index, status);
                        isAllSuccessful = false;
                    }
                    lastOperatorType = Operator.OperatorType.INSERT;
                    insertRowsPlan.addOneInsertRowPlan((InsertRowPlan)physicalPlan, index);
                    ++index;
                    if (i != req.getStatements().size() - 1 || this.executeBatchList(executeList, result)) continue;
                    isAllSuccessful = false;
                    continue;
                }
                if (physicalPlan.getOperatorType().equals((Object)Operator.OperatorType.CREATE_TIMESERIES)) {
                    CreateMultiTimeSeriesPlan multiPlan;
                    if (Operator.OperatorType.CREATE_TIMESERIES == lastOperatorType) {
                        multiPlan = (CreateMultiTimeSeriesPlan)executeList.get(executeList.size() - 1);
                    } else {
                        multiPlan = new CreateMultiTimeSeriesPlan();
                        executeList.add(multiPlan);
                    }
                    TSStatus status = this.checkAuthority(physicalPlan, req.getSessionId());
                    if (status != null) {
                        multiPlan.getResults().put(i, status);
                        isAllSuccessful = false;
                    }
                    lastOperatorType = Operator.OperatorType.CREATE_TIMESERIES;
                    this.initMultiTimeSeriesPlan(multiPlan);
                    CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)physicalPlan;
                    this.setMultiTimeSeriesPlan(multiPlan, createTimeSeriesPlan);
                    if (i != req.getStatements().size() - 1 || this.executeBatchList(executeList, result)) continue;
                    isAllSuccessful = false;
                    continue;
                }
                lastOperatorType = physicalPlan.getOperatorType();
                if (executeList.size() > 0) {
                    if (!this.executeBatchList(executeList, result)) {
                        isAllSuccessful = false;
                    }
                    executeList.clear();
                }
                long t2 = System.currentTimeMillis();
                TSExecuteStatementResp resp = this.executeUpdateStatement(physicalPlan, req.getSessionId());
                Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
                result.add(resp.status);
                if (resp.getStatus().code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                isAllSuccessful = false;
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                TSStatus status = this.tryCatchQueryException(e);
                if (status != null) {
                    result.add(status);
                    isAllSuccessful = false;
                    continue;
                }
                result.add(this.onNPEOrUnexpectedException(e, "executing " + statement, TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(result);
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        String statement = req.getStatement();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionManager.getZoneId(req.getSessionId()), req.fetchSize);
            return physicalPlan.isQuery() ? this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, this.sessionManager.getUsername(req.getSessionId()), req.isEnableRedirectQuery()) : this.executeUpdateStatement(physicalPlan, req.getSessionId());
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing \"" + statement + "\""));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing \"" + statement + "\""));
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionManager.getZoneId(req.sessionId), req.fetchSize);
            return physicalPlan.isQuery() ? this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, req.timeout, this.sessionManager.getUsername(req.getSessionId()), req.isEnableRedirectQuery()) : RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing executeQueryStatement"));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing executeQueryStatement"));
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            PhysicalPlan physicalPlan = this.processor.rawDataQueryReqToPhysicalPlan(req, this.sessionManager.getZoneId(req.sessionId));
            return physicalPlan.isQuery() ? this.internalExecuteQueryStatement("", req.statementId, physicalPlan, req.fetchSize, this.config.getQueryTimeoutThreshold(), this.sessionManager.getUsername(req.sessionId), req.isEnableRedirectQuery()) : RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing executeRawDataQuery"));
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing executeRawDataQuery"));
        }
    }

    /*
     * Exception decompiling
     */
    private TSExecuteStatementResp internalExecuteQueryStatement(String statement, long statementId, PhysicalPlan plan, int fetchSize, long timeout, String username, boolean enableRedirect) throws QueryProcessException, SQLException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, TException, AuthException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TSExecuteStatementResp getListDataSetHeaders(QueryDataSet dataSet) {
        return StaticResps.getNoTimeExecuteResp(dataSet.getPaths().stream().map(Path::getFullPath).collect(Collectors.toList()), dataSet.getDataTypes().stream().map(Enum::toString).collect(Collectors.toList()));
    }

    private TSExecuteStatementResp getQueryColumnHeaders(PhysicalPlan physicalPlan, String username) throws AuthException, TException, QueryProcessException, MetadataException {
        ArrayList<String> respColumns = new ArrayList<String>();
        ArrayList<String> columnsTypes = new ArrayList<String>();
        if (!this.checkAuthorization(physicalPlan.getAuthPaths(), physicalPlan, username)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + (Object)((Object)physicalPlan.getOperatorType()))));
        }
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        QueryPlan plan = (QueryPlan)physicalPlan;
        if (plan instanceof AlignByDevicePlan) {
            this.getAlignByDeviceQueryHeaders((AlignByDevicePlan)plan, respColumns, columnsTypes);
        } else {
            if (plan instanceof LastQueryPlan) {
                return StaticResps.LAST_RESP.deepCopy();
            }
            if (plan instanceof AggregationPlan && ((AggregationPlan)plan).getLevel() >= 0) {
                Map<String, AggregateResult> finalPaths = ((AggregationPlan)plan).getAggPathByLevel();
                for (Map.Entry<String, AggregateResult> entry : finalPaths.entrySet()) {
                    respColumns.add(entry.getKey());
                    columnsTypes.add(entry.getValue().getResultDataType().toString());
                }
            } else {
                this.getWideQueryHeaders(plan, respColumns, columnsTypes);
                resp.setColumnNameIndexMap(plan.getPathToIndex());
            }
        }
        resp.setColumns(respColumns);
        resp.setDataTypeList(columnsTypes);
        return resp;
    }

    /*
     * WARNING - void declaration
     */
    private void getWideQueryHeaders(QueryPlan plan, List<String> respColumns, List<String> columnTypes) throws TException, MetadataException {
        List<PartialPath> paths = plan.getPaths();
        List<Object> seriesTypes = new ArrayList();
        switch (plan.getOperatorType()) {
            case QUERY: 
            case FILL: {
                for (PartialPath partialPath : paths) {
                    String column = partialPath.isTsAliasExists() ? partialPath.getTsAlias() : (partialPath.isMeasurementAliasExists() ? partialPath.getFullPathWithAlias() : partialPath.getFullPath());
                    respColumns.add(column);
                    seriesTypes.add(this.getSeriesTypeByPath(partialPath));
                }
                break;
            }
            case AGGREGATION: 
            case GROUPBYTIME: 
            case GROUP_BY_FILL: {
                void var7_11;
                List<String> aggregations = plan.getAggregations();
                if (aggregations.size() != paths.size()) {
                    void var7_9;
                    boolean bl = true;
                    while (var7_9 < paths.size()) {
                        aggregations.add(aggregations.get(0));
                        ++var7_9;
                    }
                }
                boolean bl = false;
                while (var7_11 < paths.size()) {
                    PartialPath path = paths.get((int)var7_11);
                    String column = path.isTsAliasExists() ? path.getTsAlias() : (path.isMeasurementAliasExists() ? aggregations.get((int)var7_11) + "(" + paths.get((int)var7_11).getFullPathWithAlias() + ")" : aggregations.get((int)var7_11) + "(" + paths.get((int)var7_11).getFullPath() + ")");
                    respColumns.add(column);
                    ++var7_11;
                }
                seriesTypes = this.getSeriesTypesByPaths(paths, aggregations);
                break;
            }
            case UDTF: {
                seriesTypes = new ArrayList();
                UDTFPlan uDTFPlan = (UDTFPlan)plan;
                for (int i = 0; i < paths.size(); ++i) {
                    respColumns.add(paths.get(i) != null ? paths.get(i).getFullPath() : uDTFPlan.getExecutorByOriginalOutputColumnIndex(i).getContext().getColumnName());
                    seriesTypes.add(paths.get(i) != null ? uDTFPlan.getDataTypes().get(i) : uDTFPlan.getExecutorByOriginalOutputColumnIndex(i).getConfigurations().getOutputDataType());
                }
                break;
            }
            default: {
                throw new TException("unsupported query type: " + (Object)((Object)plan.getOperatorType()));
            }
        }
        for (TSDataType tSDataType : seriesTypes) {
            columnTypes.add(tSDataType.toString());
        }
    }

    private void getAlignByDeviceQueryHeaders(AlignByDevicePlan plan, List<String> respColumns, List<String> columnTypes) {
        respColumns.add("Device");
        columnTypes.add(TSDataType.TEXT.toString());
        ArrayList<TSDataType> deduplicatedColumnsType = new ArrayList<TSDataType>();
        deduplicatedColumnsType.add(TSDataType.TEXT);
        LinkedHashSet<String> deduplicatedMeasurements = new LinkedHashSet<String>();
        Map<String, TSDataType> measurementDataTypeMap = plan.getColumnDataTypeMap();
        List<String> measurements = plan.getMeasurements();
        Map<String, String> measurementAliasMap = plan.getMeasurementAliasMap();
        Map<String, AlignByDevicePlan.MeasurementType> measurementTypeMap = plan.getMeasurementTypeMap();
        for (String measurement : measurements) {
            TSDataType type = TSDataType.TEXT;
            switch (measurementTypeMap.get(measurement)) {
                case Exist: {
                    type = measurementDataTypeMap.get(measurement);
                    break;
                }
                case NonExist: 
                case Constant: {
                    type = TSDataType.TEXT;
                }
            }
            respColumns.add(measurementAliasMap.getOrDefault(measurement, measurement));
            columnTypes.add(type.toString());
            if (deduplicatedMeasurements.contains(measurement)) continue;
            deduplicatedMeasurements.add(measurement);
            deduplicatedColumnsType.add(type);
        }
        plan.setMeasurements(new ArrayList<String>(deduplicatedMeasurements));
        plan.setDataTypes(deduplicatedColumnsType);
        plan.setPaths(null);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (!this.sessionManager.hasDataset(req.queryId)) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Has not executed query"));
            }
            this.queryTimeManager.registerQuery(req.queryId, System.currentTimeMillis(), req.statement, req.timeout);
            QueryDataSet queryDataSet = this.sessionManager.getDataset(req.queryId);
            if (req.isAlign) {
                boolean hasResultSet;
                TSQueryDataSet result = this.fillRpcReturnData(req.fetchSize, queryDataSet, this.sessionManager.getUsername(req.sessionId));
                boolean bl = hasResultSet = result.bufferForTime().limit() != 0;
                if (!hasResultSet) {
                    this.releaseQueryResourceNoExceptions(req.queryId);
                }
                TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                resp.setHasResultSet(hasResultSet);
                resp.setQueryDataSet(result);
                resp.setIsAlign(true);
                this.queryTimeManager.unRegisterQuery(req.queryId);
                return resp;
            }
            TSQueryNonAlignDataSet nonAlignResult = this.fillRpcNonAlignReturnData(req.fetchSize, queryDataSet, this.sessionManager.getUsername(req.sessionId));
            boolean hasResultSet = false;
            for (ByteBuffer timeBuffer : nonAlignResult.getTimeList()) {
                if (timeBuffer.limit() == 0) continue;
                hasResultSet = true;
                break;
            }
            if (!hasResultSet) {
                this.sessionManager.removeDataset(req.queryId);
            }
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            resp.setHasResultSet(hasResultSet);
            resp.setNonAlignQueryDataSet(nonAlignResult);
            resp.setIsAlign(false);
            this.queryTimeManager.unRegisterQuery(req.queryId);
            return resp;
        }
        catch (InterruptedException e) {
            LOGGER.error(INFO_INTERRUPT_ERROR, (Object)req, (Object)e);
            Thread.currentThread().interrupt();
            return RpcUtils.getTSFetchResultsResp((TSStatus)this.onNPEOrUnexpectedException(e, "executing fetchResults", TSStatusCode.INTERNAL_SERVER_ERROR));
        }
        catch (Exception e) {
            this.releaseQueryResourceNoExceptions(req.queryId);
            return RpcUtils.getTSFetchResultsResp((TSStatus)this.onNPEOrUnexpectedException(e, "executing fetchResults", TSStatusCode.INTERNAL_SERVER_ERROR));
        }
    }

    private TSQueryDataSet fillRpcReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, InterruptedException, QueryProcessException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return queryDataSet instanceof DirectAlignByTimeDataSet ? ((DirectAlignByTimeDataSet)queryDataSet).fillBuffer(fetchSize, encoder) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
    }

    private TSQueryNonAlignDataSet fillRpcNonAlignReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, QueryProcessException, InterruptedException {
        WatermarkEncoder encoder = this.getWatermarkEncoder(userName);
        return ((DirectNonAlignDataSet)queryDataSet).fillBuffer(fetchSize, encoder);
    }

    private WatermarkEncoder getWatermarkEncoder(String userName) throws TException, AuthException {
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        GroupedLSBWatermarkEncoder encoder = null;
        if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                encoder = new GroupedLSBWatermarkEncoder(this.config);
            } else {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
            }
        }
        return encoder;
    }

    private QueryDataSet createQueryDataSet(long queryId, PhysicalPlan physicalPlan, int fetchSize) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException, MetadataException, SQLException, TException, InterruptedException {
        QueryContext context = this.genQueryContext(queryId, physicalPlan.isDebug());
        QueryDataSet queryDataSet = this.executor.processQuery(physicalPlan, context);
        queryDataSet.setFetchSize(fetchSize);
        this.sessionManager.setDataset(queryId, queryDataSet);
        return queryDataSet;
    }

    protected QueryContext genQueryContext(long queryId, boolean debug) {
        return new QueryContext(queryId, debug);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        try {
            return this.executeUpdateStatement(req.getStatement(), req.getSessionId());
        }
        catch (Exception e) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.onQueryException(e, "executing update statement"));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(PhysicalPlan plan, long sessionId) {
        TSStatus status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        status = this.executeNonQueryPlan(plan);
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
        long queryId = this.sessionManager.requestQueryId(false);
        return resp.setQueryId(queryId);
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (!(plan instanceof SetSystemModePlan) && !(plan instanceof FlushPlan) && IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, does not support non-query operation");
        }
        return this.executor.processNonQuery(plan);
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement, long sessionId) throws QueryProcessException {
        PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionManager.getZoneId(sessionId), 10000);
        return physicalPlan.isQuery() ? RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is a query statement.") : this.executeUpdateStatement(physicalPlan, sessionId);
    }

    private boolean checkLogin(long sessionId) {
        boolean isLoggedIn;
        boolean bl = isLoggedIn = this.sessionManager.getUsername(sessionId) != null;
        if (!isLoggedIn) {
            LOGGER.info(INFO_NOT_LOGIN, (Object)"IoTDB");
        }
        return isLoggedIn;
    }

    private boolean checkAuthorization(List<PartialPath> paths, PhysicalPlan plan, String username) throws AuthException {
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(username, paths, plan.getOperatorType(), targetUser);
    }

    protected void handleClientExit() {
        Long sessionId = this.sessionManager.getCurrSessionId();
        if (sessionId != null) {
            TSCloseSessionReq req = new TSCloseSessionReq(sessionId.longValue());
            this.closeSession(req);
        }
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = this.sessionManager.getZoneId(sessionId);
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(this.onNPEOrUnexpectedException(e, "generating time zone", TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            this.sessionManager.setTimezone(req.sessionId, req.timeZone);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "setting time zone", TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        return properties;
    }

    public TSStatus insertRecords(TSInsertRecordsReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{this.sessionManager.getCurrSessionId(), req.deviceIds.get(0), req.getTimestamps().get(0)});
        }
        boolean allCheckSuccess = true;
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            try {
                InsertRowPlan plan = new InsertRowPlan(new PartialPath((String)req.getDeviceIds().get(i)), (long)((Long)req.getTimestamps().get(i)), ((List)req.getMeasurementsList().get(i)).toArray(new String[0]), (ByteBuffer)req.valuesList.get(i));
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    insertRowsPlan.getResults().put(i, status);
                    allCheckSuccess = false;
                }
                insertRowsPlan.addOneInsertRowPlan(plan, i);
                continue;
            }
            catch (Exception e) {
                allCheckSuccess = false;
                insertRowsPlan.getResults().put(i, this.onNPEOrUnexpectedException(e, "inserting records", TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        return this.judgeFinalTsStatus(allCheckSuccess, tsStatus, insertRowsPlan.getResults(), req.deviceIds.size());
    }

    private TSStatus judgeFinalTsStatus(boolean allCheckSuccess, TSStatus executeTsStatus, Map<Integer, TSStatus> checkTsStatus, int totalRowCount) {
        if (allCheckSuccess) {
            return executeTsStatus;
        }
        if (executeTsStatus.subStatus == null) {
            Object[] tmpSubTsStatus = new TSStatus[totalRowCount];
            Arrays.fill(tmpSubTsStatus, RpcUtils.SUCCESS_STATUS);
            executeTsStatus.subStatus = Arrays.asList(tmpSubTsStatus);
        }
        for (Map.Entry<Integer, TSStatus> entry : checkTsStatus.entrySet()) {
            executeTsStatus.subStatus.set(entry.getKey(), entry.getValue());
        }
        return RpcUtils.getStatus((List)executeTsStatus.subStatus);
    }

    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{this.sessionManager.getCurrSessionId(), req.deviceId, req.getTimestamps().get(0)});
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        try {
            InsertRowsOfOneDevicePlan plan = new InsertRowsOfOneDevicePlan(new PartialPath(req.getDeviceId()), req.getTimestamps().toArray(new Long[0]), req.getMeasurementsList(), req.getValuesList().toArray(new ByteBuffer[0]));
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            statusList.add(status != null ? status : this.executeNonQueryPlan(plan));
        }
        catch (Exception e) {
            statusList.add(this.onNPEOrUnexpectedException(e, "inserting records of one device", TSStatusCode.INTERNAL_SERVER_ERROR));
        }
        TSStatus resp = RpcUtils.getStatus(statusList);
        for (TSStatus status : resp.subStatus) {
            if (status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            return resp;
        }
        resp.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        return resp;
    }

    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{this.sessionManager.getCurrSessionId(), req.deviceIds.get(0), req.getTimestamps().get(0)});
        }
        boolean allCheckSuccess = true;
        InsertRowsPlan insertRowsPlan = new InsertRowsPlan();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            InsertRowPlan plan = new InsertRowPlan();
            try {
                plan.setDeviceId(new PartialPath((String)req.getDeviceIds().get(i)));
                plan.setTime((Long)req.getTimestamps().get(i));
                this.addMeasurementAndValue(plan, (List)req.getMeasurementsList().get(i), (List)req.getValuesList().get(i));
                plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
                plan.setNeedInferType(true);
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    insertRowsPlan.getResults().put(i, status);
                    allCheckSuccess = false;
                }
                insertRowsPlan.addOneInsertRowPlan(plan, i);
                continue;
            }
            catch (Exception e) {
                insertRowsPlan.getResults().put(i, this.onNPEOrUnexpectedException(e, "inserting string records", TSStatusCode.INTERNAL_SERVER_ERROR));
                allCheckSuccess = false;
            }
        }
        TSStatus tsStatus = this.executeNonQueryPlan(insertRowsPlan);
        return this.judgeFinalTsStatus(allCheckSuccess, tsStatus, insertRowsPlan.getResults(), req.deviceIds.size());
    }

    private void addMeasurementAndValue(InsertRowPlan insertRowPlan, List<String> measurements, List<String> values) {
        ArrayList<String> newMeasurements = new ArrayList<String>(measurements.size());
        ArrayList<String> newValues = new ArrayList<String>(values.size());
        for (int i = 0; i < measurements.size(); ++i) {
            String value = values.get(i);
            if (value.isEmpty()) continue;
            newMeasurements.add(measurements.get(i));
            newValues.add(value);
        }
        insertRowPlan.setValues(newValues.toArray(new Object[0]));
        insertRowPlan.setMeasurements(newMeasurements.toArray(new String[0]));
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus insertRecord(TSInsertRecordReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{this.sessionManager.getCurrSessionId(), req.getDeviceId(), req.getTimestamp()});
            InsertRowPlan plan = new InsertRowPlan(new PartialPath(req.getDeviceId()), req.getTimestamp(), req.getMeasurements().toArray(new String[0]), req.values);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "inserting a record", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{this.sessionManager.getCurrSessionId(), req.getDeviceId(), req.getTimestamp()});
            InsertRowPlan plan = new InsertRowPlan();
            plan.setDeviceId(new PartialPath(req.getDeviceId()));
            plan.setTime(req.getTimestamp());
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
            plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
            plan.setValues(req.getValues().toArray(new Object[0]));
            plan.setNeedInferType(true);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "inserting a string record", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            DeletePlan plan = new DeletePlan();
            plan.setDeleteStartTime(req.getStartTime());
            plan.setDeleteEndTime(req.getEndTime());
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            for (String path : req.getPaths()) {
                paths.add(new PartialPath(path));
            }
            plan.addPaths(paths);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            return status != null ? new TSStatus(status) : new TSStatus(this.executeNonQueryPlan(plan));
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "deleting data", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSStatus;
            }
            InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(req.deviceId), req.measurements);
            insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer(req.timestamps, req.size));
            insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer(req.values, req.types, req.measurements.size(), req.size));
            insertTabletPlan.setRowCount(req.size);
            insertTabletPlan.setDataTypes(req.types);
            TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
            TSStatus tSStatus = status != null ? status : this.executeNonQueryPlan(insertTabletPlan);
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = this.onNPEOrUnexpectedException(e, "inserting tablet", TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSStatus;
            }
            TSStatus tSStatus = this.insertTabletsInternal(req);
            return tSStatus;
        }
        catch (NullPointerException e) {
            LOGGER.error("{}: error occurs when insertTablets", (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        catch (Exception e) {
            TSStatus tSStatus = this.onNPEOrUnexpectedException(e, "inserting tablets", TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    private InsertTabletPlan constructInsertTabletPlan(TSInsertTabletsReq req, int i) throws IllegalPathException {
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath((String)req.deviceIds.get(i)), (List)req.measurementsList.get(i));
        insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer((ByteBuffer)req.timestampsList.get(i), (Integer)req.sizeList.get(i)));
        insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer((ByteBuffer)req.valuesList.get(i), (List)req.typesList.get(i), ((List)req.measurementsList.get(i)).size(), (int)((Integer)req.sizeList.get(i))));
        insertTabletPlan.setRowCount((Integer)req.sizeList.get(i));
        insertTabletPlan.setDataTypes((List)req.typesList.get(i));
        return insertTabletPlan;
    }

    public TSStatus insertTabletsInternal(TSInsertTabletsReq req) throws IllegalPathException {
        ArrayList<InsertTabletPlan> insertTabletPlanList = new ArrayList<InsertTabletPlan>();
        InsertMultiTabletPlan insertMultiTabletPlan = new InsertMultiTabletPlan();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            InsertTabletPlan insertTabletPlan = this.constructInsertTabletPlan(req, i);
            TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
            if (status != null) {
                insertMultiTabletPlan.getResults().put(i, status);
            }
            insertTabletPlanList.add(insertTabletPlan);
        }
        insertMultiTabletPlan.setInsertTabletPlanList(insertTabletPlanList);
        return this.executeNonQueryPlan(insertMultiTabletPlan);
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            if (!this.checkLogin(sessionId)) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            SetStorageGroupPlan plan = new SetStorageGroupPlan(new PartialPath(storageGroup));
            TSStatus status = this.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "setting storage group", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            if (!this.checkLogin(sessionId)) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            ArrayList<PartialPath> storageGroupList = new ArrayList<PartialPath>();
            for (String storageGroup : storageGroups) {
                storageGroupList.add(new PartialPath(storageGroup));
            }
            DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
            TSStatus status = this.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "deleting storage group", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            CreateTimeSeriesPlan plan;
            TSStatus status;
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (AUDIT_LOGGER.isDebugEnabled()) {
                AUDIT_LOGGER.debug("Session-{} create timeseries {}", (Object)this.sessionManager.getCurrSessionId(), (Object)req.getPath());
            }
            return (status = this.checkAuthority(plan = new CreateTimeSeriesPlan(new PartialPath(req.path), TSDataType.values()[req.dataType], TSEncoding.values()[req.encoding], CompressionType.values()[req.compressor], req.props, req.tags, req.attributes, req.measurementAlias), req.getSessionId())) != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "creating timeseries", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (AUDIT_LOGGER.isDebugEnabled()) {
                AUDIT_LOGGER.debug("Session-{} create {} timeseries, the first is {}", new Object[]{this.sessionManager.getCurrSessionId(), req.getPaths().size(), req.getPaths().get(0)});
            }
            CreateMultiTimeSeriesPlan multiPlan = new CreateMultiTimeSeriesPlan();
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>(req.paths.size());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(req.paths.size());
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>(req.paths.size());
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>(req.paths.size());
            ArrayList<String> alias = null;
            if (req.measurementAliasList != null) {
                alias = new ArrayList<String>(req.paths.size());
            }
            ArrayList<Map<String, String>> props = null;
            if (req.propsList != null) {
                props = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> tags = null;
            if (req.tagsList != null) {
                tags = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> attributes = null;
            if (req.attributesList != null) {
                attributes = new ArrayList<Map<String, String>>(req.paths.size());
            }
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
            for (int i = 0; i < req.paths.size(); ++i) {
                plan.setPath(new PartialPath((String)req.paths.get(i)));
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    multiPlan.getResults().put(i, status);
                }
                paths.add(new PartialPath((String)req.paths.get(i)));
                dataTypes.add(TSDataType.values()[(Integer)req.dataTypes.get(i)]);
                encodings.add(TSEncoding.values()[(Integer)req.encodings.get(i)]);
                compressors.add(CompressionType.values()[(Integer)req.compressors.get(i)]);
                if (alias != null) {
                    alias.add((String)req.measurementAliasList.get(i));
                }
                if (props != null) {
                    props.add((Map)req.propsList.get(i));
                }
                if (tags != null) {
                    tags.add((Map)req.tagsList.get(i));
                }
                if (attributes == null) continue;
                attributes.add((Map)req.attributesList.get(i));
            }
            multiPlan.setPaths(paths);
            multiPlan.setDataTypes(dataTypes);
            multiPlan.setEncodings(encodings);
            multiPlan.setCompressors(compressors);
            multiPlan.setAlias(alias);
            multiPlan.setProps(props);
            multiPlan.setTags(tags);
            multiPlan.setAttributes(attributes);
            multiPlan.setIndexes(new ArrayList<Integer>());
            return this.executeNonQueryPlan(multiPlan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "creating multi timeseries", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> paths) {
        try {
            if (!this.checkLogin(sessionId)) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (String path : paths) {
                pathList.add(new PartialPath(path));
            }
            DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
            TSStatus status = this.checkAuthority(plan, sessionId);
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "deleting timeseries", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public long requestStatementId(long sessionId) {
        return this.sessionManager.requestStatementId(sessionId);
    }

    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) throws TException {
        try {
            Object list3;
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (AUDIT_LOGGER.isDebugEnabled()) {
                AUDIT_LOGGER.debug("Session-{} create device template {}.{}.{}.{}.{}.{}", new Object[]{this.sessionManager.getCurrSessionId(), req.getName(), req.getSchemaNames(), req.getMeasurements(), req.getDataTypes(), req.getEncodings(), req.getCompressors()});
            }
            ArrayList<List<TSDataType>> dataTypes = new ArrayList<List<TSDataType>>();
            for (Object list2 : req.getDataTypes()) {
                ArrayList<TSDataType> dataTypesList = new ArrayList<TSDataType>();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    int dataType = (Integer)iterator.next();
                    dataTypesList.add(TSDataType.values()[dataType]);
                }
                dataTypes.add(dataTypesList);
            }
            ArrayList<List<TSEncoding>> encodings = new ArrayList<List<TSEncoding>>();
            for (Object list3 : req.getEncodings()) {
                ArrayList<TSEncoding> encodingsList = new ArrayList<TSEncoding>();
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    int encoding = (Integer)iterator.next();
                    encodingsList.add(TSEncoding.values()[encoding]);
                }
                encodings.add(encodingsList);
            }
            ArrayList<CompressionType> compressionTypes = new ArrayList<CompressionType>();
            list3 = req.getCompressors().iterator();
            while (list3.hasNext()) {
                int compressType = (Integer)list3.next();
                compressionTypes.add(CompressionType.values()[compressType]);
            }
            CreateTemplatePlan plan = new CreateTemplatePlan(req.getName(), req.getSchemaNames(), req.getMeasurements(), dataTypes, encodings, compressionTypes);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            return status != null ? status : this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "creating aligned timeseries", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        SetDeviceTemplatePlan plan;
        TSStatus status;
        if (!this.checkLogin(req.getSessionId())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("Session-{} set device template {}.{}", new Object[]{this.sessionManager.getCurrSessionId(), req.getTemplateName(), req.getPrefixPath()});
        }
        return (status = this.checkAuthority(plan = new SetDeviceTemplatePlan(req.templateName, req.prefixPath), req.getSessionId())) != null ? status : this.executeNonQueryPlan(plan);
    }

    private TSStatus checkAuthority(PhysicalPlan plan, long sessionId) {
        List<PartialPath> paths = plan.getPaths();
        try {
            if (!this.checkAuthorization(paths, plan, this.sessionManager.getUsername(sessionId))) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + (Object)((Object)plan.getOperatorType())));
            }
        }
        catch (AuthException e) {
            LOGGER.warn("meet error while checking authorization.", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNINITIALIZED_AUTH_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            return this.onNPEOrUnexpectedException(e, "checking authority", TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
        return null;
    }

    protected TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        boolean isSuccessful;
        try {
            plan.checkIntegrity();
            isSuccessful = this.executeNonQuery(plan);
        }
        catch (Exception e) {
            return this.onNonQueryException(e, "executing non query plan");
        }
        return isSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
    }

    protected List<TSDataType> getSeriesTypesByPaths(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        return SchemaUtils.getSeriesTypesByPaths(paths, aggregations);
    }

    protected TSDataType getSeriesTypeByPath(PartialPath path) throws MetadataException {
        return SchemaUtils.getSeriesTypeByPath(path);
    }

    private TSStatus onQueryException(Exception e, String operation) {
        TSStatus status = this.tryCatchQueryException(e);
        return status != null ? status : this.onNPEOrUnexpectedException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    private TSStatus tryCatchQueryException(Exception e) {
        if (e instanceof QueryTimeoutRuntimeException) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.TIME_OUT, (String)this.getRootCause(e));
        }
        if (e instanceof ParseCancellationException) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(INFO_PARSING_SQL_ERROR, (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(INFO_PARSING_SQL_ERROR + this.getRootCause(e)));
        }
        if (e instanceof SQLParserException) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(INFO_CHECK_METADATA_ERROR, (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)(INFO_CHECK_METADATA_ERROR + this.getRootCause(e)));
        }
        if (e instanceof QueryProcessException) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(INFO_QUERY_PROCESS_ERROR, (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)(INFO_QUERY_PROCESS_ERROR + this.getRootCause(e)));
        }
        if (e instanceof QueryInBatchStatementException) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(INFO_NOT_ALLOWED_IN_BATCH_ERROR, (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)(INFO_NOT_ALLOWED_IN_BATCH_ERROR + this.getRootCause(e)));
        }
        if (e instanceof IoTDBException && !(e instanceof StorageGroupNotReadyException)) {
            DETAILED_FAILURE_QUERY_TRACE_LOGGER.warn(INFO_QUERY_PROCESS_ERROR, (Throwable)e);
            return RpcUtils.getStatus((int)((IoTDBException)e).getErrorCode(), (String)this.getRootCause(e));
        }
        return null;
    }

    private TSStatus onNonQueryException(Exception e, String operation) {
        TSStatus status = this.tryCatchNonQueryException(e);
        return status != null ? status : this.onNPEOrUnexpectedException(e, operation, TSStatusCode.INTERNAL_SERVER_ERROR);
    }

    private TSStatus tryCatchNonQueryException(Exception e) {
        String message = "Exception occurred while processing non-query. ";
        if (e instanceof BatchProcessException) {
            LOGGER.warn(message, (Throwable)e);
            return RpcUtils.getStatus(Arrays.asList(((BatchProcessException)e).getFailingStatus()));
        }
        if (e instanceof IoTDBException && !(e instanceof StorageGroupNotReadyException)) {
            if (((IoTDBException)e).isUserException()) {
                LOGGER.warn(message + e.getMessage());
            } else {
                LOGGER.warn(message, (Throwable)e);
            }
            return RpcUtils.getStatus((int)((IoTDBException)e).getErrorCode(), (String)this.getRootCause(e));
        }
        return null;
    }

    private TSStatus onNPEOrUnexpectedException(Exception e, String operation, TSStatusCode statusCode) {
        String message = String.format("[%s] Exception occurred while %s. ", statusCode.name(), operation);
        if (e instanceof NullPointerException) {
            LOGGER.error(message, (Throwable)e);
        } else if (e instanceof UnSupportedDataTypeException) {
            LOGGER.warn(e.getMessage());
        } else {
            LOGGER.warn(message, (Throwable)e);
        }
        return RpcUtils.getStatus((TSStatusCode)statusCode, (String)(message + e.getMessage()));
    }

    private String getRootCause(Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e.getMessage();
    }
}

