/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.db.query.udf.service.TemporaryQueryDataFileService;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager;
    private static final Logger logger = LoggerFactory.getLogger(QueryResourceManager.class);
    private IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap;

    private QueryResourceManager() {
        this.filePathsManager = new QueryFileManager();
        this.externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignQueryId(boolean isDataQuery) {
        long queryId = this.queryIdAtom.incrementAndGet();
        if (isDataQuery) {
            this.filePathsManager.addQueryId(queryId);
        }
        return queryId;
    }

    public void registerTempExternalSortFile(long queryId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(queryId, x -> new ArrayList()).add(deserializer);
    }

    public QueryDataSource getQueryDataSource(PartialPath selectedPath, QueryContext context, Filter filter) throws StorageEngineException, QueryProcessException {
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)selectedPath, filter);
        QueryDataSource queryDataSource = StorageEngine.getInstance().query(singleSeriesExpression, context, this.filePathsManager);
        if (this.CONFIG.isEnablePerformanceTracing()) {
            TracingManager.getInstance().getTracingInfo(context.getQueryId()).addTsFileSet(queryDataSource.getSeqResources(), queryDataSource.getUnseqResources());
        }
        return queryDataSource;
    }

    public void endQuery(long queryId) throws StorageEngineException {
        try {
            if (this.CONFIG.isEnablePerformanceTracing() && TracingManager.getInstance().getTracingInfo(queryId) != null) {
                TracingManager.getInstance().writeTracingInfo(queryId);
                TracingManager.getInstance().writeEndTime(queryId);
            }
        }
        catch (IOException e) {
            logger.error("Error while writing performance info to {}, {}", (Object)(this.CONFIG.getTracingDir() + File.separator + "tracing.txt"), (Object)e.getMessage());
        }
        if (this.externalSortFileMap.get(queryId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(queryId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e);
                }
            }
            this.externalSortFileMap.remove(queryId);
        }
        this.filePathsManager.removeUsedFilesForQuery(queryId);
        TemporaryQueryDataFileService.getInstance().deregister(queryId);
        QueryTimeManager.getInstance().unRegisterQuery(queryId);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

