/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;

public abstract class SFWOperator
extends RootOperator {
    private SelectOperator selectOperator;
    private FromOperator fromOperator;
    private FilterOperator filterOperator;
    private boolean hasAggregation = false;
    private boolean hasUdf = false;
    private boolean lastQuery = false;

    public SFWOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.SFW;
    }

    public FromOperator getFromOperator() {
        return this.fromOperator;
    }

    public void setFromOperator(FromOperator from) {
        this.fromOperator = from;
    }

    public SelectOperator getSelectOperator() {
        return this.selectOperator;
    }

    public void setSelectOperator(SelectOperator sel) {
        this.selectOperator = sel;
        if (sel.hasAggregation()) {
            this.hasAggregation = true;
        }
        if (sel.isUdfQuery()) {
            this.hasUdf = true;
        }
        if (sel.isLastQuery()) {
            this.lastQuery = true;
        }
    }

    public FilterOperator getFilterOperator() {
        return this.filterOperator;
    }

    public void setFilterOperator(FilterOperator filter) {
        this.filterOperator = filter;
    }

    public List<PartialPath> getSelectedPaths() {
        return this.selectOperator != null ? this.selectOperator.getSuffixPaths() : null;
    }

    public boolean hasAggregation() {
        return this.hasAggregation;
    }

    public boolean hasUdf() {
        return this.hasUdf;
    }

    public boolean isLastQuery() {
        return this.lastQuery;
    }
}

