/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="partition", description="Print the hosts information of specific storage group and time range")
public class Partition
extends NodeToolCmd {
    @Option(title="path", required=true, name={"-path", "--path"}, description="Specify a path for accurate hosts information")
    private String path = null;
    @Option(title="start time", name={"-st", "--starttime"}, description="Specify a start time for partition")
    private long startTime = System.currentTimeMillis();
    @Option(title="end time", name={"-et", "--endtime"}, description="Specify a end time for partition")
    private long endTime = System.currentTimeMillis();
    @Option(title="metadata", name={"-m", "--metadata"}, description="Query metadata")
    private boolean metadata = false;

    @Override
    public void execute(ClusterMonitorMBean proxy) {
        if (this.endTime < this.startTime) {
            this.endTime = this.startTime;
        }
        if (this.metadata) {
            this.queryMetaPartition(proxy);
        } else {
            this.queryDataPartition(proxy);
        }
    }

    private void queryMetaPartition(ClusterMonitorMBean proxy) {
        PartitionGroup partitionGroup = proxy.getMetaPartition(this.path);
        if (partitionGroup == null) {
            Printer.msgPrintln("The cluster is being created.");
        } else if (partitionGroup.isEmpty()) {
            Printer.msgPrintln(String.format("The storage group of path <%s> doesn't exist.", this.path));
        } else {
            Printer.msgPrintln(String.format("META<%s>\t->\t%s", this.path, this.partitionGroupToString(partitionGroup)));
        }
    }

    private void queryDataPartition(ClusterMonitorMBean proxy) {
        MultiKeyMap<Long, PartitionGroup> timeRangeMapRaftGroup = proxy.getDataPartition(this.path, this.startTime, this.endTime);
        if (timeRangeMapRaftGroup == null) {
            Printer.msgPrintln("The cluster is being created.");
        } else if (timeRangeMapRaftGroup.isEmpty()) {
            Printer.msgPrintln(String.format("The storage group of path <%s> doesn't exist.", this.path));
        } else {
            timeRangeMapRaftGroup.forEach((timeRange, raftGroup) -> Printer.msgPrintln(String.format("DATA<%s, %d, %d>\t->\t%s", this.path, (long)((Long)timeRange.getKey(0)), (long)((Long)timeRange.getKey(1)), this.partitionGroupToString((PartitionGroup)raftGroup))));
        }
    }
}

