/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceInfo {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceInfo.class);
    private long readerId = -1L;
    private Node curSource;
    private PartitionGroup partitionGroup;
    private TSDataType dataType;
    private SingleSeriesQueryRequest request;
    private RemoteQueryContext context;
    private MetaGroupMember metaGroupMember;
    private List<Node> nodes;
    private int curPos;
    private boolean isNoData = false;
    private boolean isNoClient = false;

    public DataSourceInfo(PartitionGroup group, TSDataType dataType, SingleSeriesQueryRequest request, RemoteQueryContext context, MetaGroupMember metaGroupMember, List<Node> nodes) {
        this.partitionGroup = group;
        this.dataType = dataType;
        this.request = request;
        this.context = context;
        this.metaGroupMember = metaGroupMember;
        this.nodes = nodes;
        this.curPos = nodes.size() - 1;
        this.curSource = nodes.get(this.curPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextDataClient(boolean byTimestamp, long timestamp) {
        if (this.nodes.isEmpty()) {
            this.isNoData = false;
            return false;
        }
        int nextNodePos = (this.curPos + 1) % this.nodes.size();
        do {
            Node node = this.nodes.get(nextNodePos);
            logger.debug("querying {} from {} of {}", new Object[]{this.request.path, node, this.partitionGroup.getHeader()});
            try {
                Long newReaderId = this.getReaderId(node, byTimestamp, timestamp);
                if (newReaderId != null) {
                    logger.debug("get a readerId {} for {} from {}", new Object[]{newReaderId, this.request.path, node});
                    if (newReaderId != -1L) {
                        this.readerId = newReaderId;
                        this.curSource = node;
                        this.curPos = nextNodePos;
                        boolean bl = true;
                        return bl;
                    }
                    this.isNoClient = true;
                    this.isNoData = true;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException | TException e) {
                logger.error("Cannot query {} from {}", new Object[]{this.request.path, node, e});
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Cannot query {} from {}", new Object[]{this.request.path, node, e});
            }
            finally {
                this.context.registerRemoteNode(node, this.partitionGroup.getHeader());
            }
        } while ((nextNodePos = (nextNodePos + 1) % this.nodes.size()) != this.curPos);
        this.isNoClient = true;
        this.isNoData = false;
        return false;
    }

    private Long getReaderId(Node node, boolean byTimestamp, long timestamp) throws TException, InterruptedException, IOException {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return this.applyForReaderIdAsync(node, byTimestamp, timestamp);
        }
        return this.applyForReaderIdSync(node, byTimestamp, timestamp);
    }

    private Long applyForReaderIdAsync(Node node, boolean byTimestamp, long timestamp) throws TException, InterruptedException, IOException {
        AsyncDataClient client = this.metaGroupMember.getClientProvider().getAsyncDataClient(node, RaftServer.getReadOperationTimeoutMS());
        Long newReaderId = byTimestamp ? SyncClientAdaptor.querySingleSeriesByTimestamp(client, this.request) : SyncClientAdaptor.querySingleSeries(client, this.request, timestamp);
        return newReaderId;
    }

    private Long applyForReaderIdSync(Node node, boolean byTimestamp, long timestamp) throws TException, IOException {
        try (SyncDataClient client = this.metaGroupMember.getClientProvider().getSyncDataClient(node, RaftServer.getReadOperationTimeoutMS());){
            long newReaderId;
            try {
                if (byTimestamp) {
                    newReaderId = client.querySingleSeriesByTimestamp(this.request);
                } else {
                    TimeFilter.TimeGt newFilter;
                    if (this.request.isSetTimeFilterBytes()) {
                        Filter timeFilter = FilterFactory.deserialize((ByteBuffer)this.request.timeFilterBytes);
                        newFilter = new AndFilter(timeFilter, (Filter)TimeFilter.gt((long)timestamp));
                    } else {
                        newFilter = TimeFilter.gt((long)timestamp);
                    }
                    this.request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)newFilter));
                    newReaderId = client.querySingleSeries(this.request);
                }
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                throw e;
            }
            Long l = newReaderId;
            return l;
        }
    }

    public long getReaderId() {
        return this.readerId;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public Node getHeader() {
        return this.partitionGroup.getHeader();
    }

    Node getCurrentNode() {
        return this.curSource;
    }

    AsyncDataClient getCurAsyncClient(int timeout) throws IOException {
        return this.isNoClient ? null : this.metaGroupMember.getClientProvider().getAsyncDataClient(this.curSource, timeout);
    }

    SyncDataClient getCurSyncClient(int timeout) throws IOException {
        return this.isNoClient ? null : this.metaGroupMember.getClientProvider().getSyncDataClient(this.curSource, timeout);
    }

    public boolean isNoData() {
        return this.isNoData;
    }

    private boolean isNoClient() {
        return this.isNoClient;
    }

    public String toString() {
        return "DataSourceInfo{readerId=" + this.readerId + ", curSource=" + this.curSource + ", partitionGroup=" + this.partitionGroup + ", request=" + this.request + '}';
    }

    boolean checkCurClient() throws IOException {
        if (this.isNoClient()) {
            if (!this.isNoData()) {
                throw new IOException("no available client.");
            }
            return false;
        }
        return true;
    }

    boolean switchNode(boolean byTimestamp, long timeOffset) throws IOException {
        boolean hasClient = this.hasNextDataClient(byTimestamp, timeOffset);
        logger.info("Client failed, changed to {}", (Object)this.curSource);
        if (!hasClient) {
            if (!this.isNoData()) {
                throw new IOException("no available client.");
            }
            return false;
        }
        return true;
    }
}

