/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(AsyncClientFactory.class);
    static TAsyncClientManager[] managers;
    TProtocolFactory protocolFactory;
    AtomicInteger clientCnt = new AtomicInteger();

    protected abstract RaftService.AsyncClient getAsyncClient(Node var1, AsyncClientPool var2) throws IOException;

    static {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            managers = new TAsyncClientManager[ClusterDescriptor.getInstance().getConfig().getSelectorNumOfClientPool()];
            for (int i = 0; i < managers.length; ++i) {
                try {
                    AsyncClientFactory.managers[i] = new TAsyncClientManager();
                    continue;
                }
                catch (IOException e) {
                    logger.error("Cannot create data heartbeat client manager for factory", (Throwable)e);
                }
            }
        }
    }
}

